/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.teleportation;

import dev.sergiferry.randomtp.teleportation.SearchTask;
import dev.sergiferry.randomtp.teleportation.TeleportationHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;

public class PersonalTeleportationHandler<T>
extends TeleportationHandler<T> {
    private Map<Player, SearchTask> tasks = new HashMap<Player, SearchTask>();

    protected PersonalTeleportationHandler(TeleportationHandler.Type<T> type, T value) {
        super(type, value);
    }

    public SearchTask getSearchTask(Player player) {
        return this.tasks.get(player);
    }

    public boolean hasSearchTask(Player player) {
        return this.tasks.containsKey(player);
    }

    @Override
    public boolean isGroupTeleport() {
        return false;
    }

    @Override
    public SearchTask registerSearch(Player player, SearchTask.Options options) {
        Validate.isTrue((!this.hasSearchTask(player) ? 1 : 0) != 0);
        this.tasks.put(player, SearchTask.registerSearch(this, player, options));
        return this.tasks.get(player);
    }

    @Override
    public SearchTask unregisterSearch(Player player) {
        Validate.isTrue((boolean)this.hasSearchTask(player));
        if (this.getType().equals(TeleportationHandler.Type.SIGN)) {
            Sign sign = (Sign)this.getValue();
            player.sendSignChange(sign.getLocation(), sign.getLines());
        }
        return this.tasks.remove(player);
    }

    @Override
    public void cancelSearchTasks() {
        Map.copyOf(this.tasks).entrySet().forEach(x -> ((SearchTask)x.getValue()).cancel(SearchTask.Reason.ERROR));
    }
}

