/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.teleportation;

import dev.sergiferry.randomtp.teleportation.SearchTask;
import dev.sergiferry.randomtp.teleportation.TeleportationHandler;
import org.bukkit.entity.Player;

public class GroupTeleportationHandler<T>
extends TeleportationHandler<T> {
    private SearchTask searchTask = null;

    public GroupTeleportationHandler(TeleportationHandler.Type<T> type, T value) {
        super(type, value);
    }

    public boolean hasSearchTask() {
        return this.searchTask != null;
    }

    public SearchTask getSearchTask() {
        return this.searchTask;
    }

    public boolean isPlayer(Player player) {
        return this.searchTask.getParty().containsPlayer(player);
    }

    private void startSearchTask(Player player, SearchTask.Options options) {
        this.searchTask = SearchTask.registerSearch(this, player, options);
    }

    private void joinSearchTask(Player player) {
        if (this.isPlayer(player)) {
            return;
        }
        this.searchTask.joinPlayer(player);
    }

    private void quitSearchTask(Player player) {
        if (!this.isPlayer(player)) {
            return;
        }
        this.searchTask.quitPlayer(player);
    }

    public void cancelSearchTask(SearchTask.Reason reason) {
        this.searchTask.cancel(reason);
        this.searchTask = null;
    }

    @Override
    public boolean isGroupTeleport() {
        return true;
    }

    @Override
    public SearchTask registerSearch(Player player, SearchTask.Options options) {
        if (this.searchTask == null) {
            this.startSearchTask(player, options);
        } else {
            this.joinSearchTask(player);
        }
        return this.searchTask;
    }

    @Override
    public SearchTask unregisterSearch(Player player) {
        if (this.searchTask != null && this.searchTask.getParty().getPlayers().isEmpty()) {
            this.searchTask = null;
        }
        return this.searchTask;
    }

    @Override
    public void cancelSearchTasks() {
        if (this.searchTask != null) {
            this.searchTask.cancel(SearchTask.Reason.ERROR);
        }
    }
}

