/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.teleportation;

import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.debug.DebugManager;
import dev.sergiferry.randomtp.teleportation.SearchTask;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import dev.sergiferry.randomtp.utils.LocationUtils;
import dev.sergiferry.randomtp.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FindLocation {
    private static final Integer MAX_LOOP_TRIES = 10;

    public static CompletableFuture<Location> getRandomLocation(@Nullable SearchTask.Options options) {
        Validate.notNull((Object)options);
        Validate.notNull((Object)options.getWorld());
        World world = options.getWorld();
        CompletableFuture<Location> completableFuture = new CompletableFuture<Location>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)RandomTeleportPlugin.getInstance(), () -> {
            WorldOptions worldOptions = WorldOptions.of(world);
            Integer maxX = worldOptions.getMaxX();
            Integer maxY = worldOptions.getMaxY();
            Integer maxZ = worldOptions.getMaxZ();
            Integer minX = worldOptions.getMinX();
            Integer minY = worldOptions.getMinY();
            Integer minZ = worldOptions.getMinZ();
            if (LocationUtils.isOutsideOfBorder(world, maxX.doubleValue(), maxZ.doubleValue())) {
                maxX = (int)((double)world.getWorldBorder().getCenter().getBlockX() + world.getWorldBorder().getSize() / 2.0);
                maxZ = (int)((double)world.getWorldBorder().getCenter().getBlockZ() + world.getWorldBorder().getSize() / 2.0);
            }
            if (LocationUtils.isOutsideOfBorder(world, minX.doubleValue(), minZ.doubleValue())) {
                minX = (int)((double)world.getWorldBorder().getCenter().getBlockX() - world.getWorldBorder().getSize() / 2.0);
                minZ = (int)((double)world.getWorldBorder().getCenter().getBlockZ() - world.getWorldBorder().getSize() / 2.0);
            }
            maxY = Math.min(maxY, world.getMaxHeight());
            minY = Math.max(minY, world.getMinHeight());
            Integer rx = null;
            Integer rz = null;
            Integer chunkX = null;
            Integer chunkZ = null;
            int preventNearOtherPlayers = worldOptions.getPreventNearOtherPlayers();
            int preventNearSearchLocation = worldOptions.getPreventNearSearchLocation();
            int preventNearWorldSpawn = worldOptions.getPreventNearWorldSpawn();
            ArrayList forceLoadedChunks = new ArrayList();
            ArrayList<Chunk> loadedChunks = new ArrayList<Chunk>();
            if (worldOptions.isPreventNotLoadedChunks()) {
                loadedChunks.addAll(List.of(world.getLoadedChunks()));
                DebugManager.debug("Total loaded chunks: " + forceLoadedChunks.size() + " and " + loadedChunks.size());
            }
            boolean requirementsMet = false;
            int loopTries = 0;
            while (!requirementsMet) {
                Location worldSpawn;
                Double distance;
                Double distance2;
                Location searchStart;
                if (loopTries >= MAX_LOOP_TRIES) {
                    DebugManager.debug("Failed attempt: Max loop tries (" + MAX_LOOP_TRIES + ") reached.");
                    completableFuture.complete(null);
                    return;
                }
                ++loopTries;
                if (worldOptions.isPreventNotLoadedChunks()) {
                    Chunk loadedChunk = null;
                    if (!forceLoadedChunks.isEmpty()) {
                        rc = MathUtils.random(0, forceLoadedChunks.size() - 1);
                        loadedChunk = (Chunk)forceLoadedChunks.get(rc);
                    } else {
                        rc = MathUtils.random(0, loadedChunks.size() - 1);
                        loadedChunk = (Chunk)loadedChunks.get(rc);
                    }
                    if (loadedChunk == null) continue;
                    rx = loadedChunk.getX() * 16;
                    rz = loadedChunk.getZ() * 16;
                    chunkX = loadedChunk.getX();
                    chunkZ = loadedChunk.getZ();
                } else {
                    rx = MathUtils.random(minX, maxX);
                    rz = MathUtils.random(minZ, maxZ);
                    chunkX = LocationUtils.floor(rx.intValue()) >> 4;
                    chunkZ = LocationUtils.floor(rz.intValue()) >> 4;
                    if (worldOptions.isPreventNotGeneratedChunks() && !world.isChunkGenerated(chunkX.intValue(), chunkZ.intValue())) {
                        DebugManager.debug("Chunk (" + chunkX + ", " + chunkZ + ") is not generated. Looping...");
                        continue;
                    }
                }
                if (preventNearSearchLocation > 0 && !(searchStart = options.getTeleportationHandler().getLocation()).getWorld().equals(options.getWorld()) && (distance2 = MathUtils.distance(searchStart.getBlockX(), searchStart.getBlockZ(), rx, rz)) < (double)preventNearSearchLocation) {
                    DebugManager.debug("Too close from search location (" + distance2.intValue() + " < " + preventNearSearchLocation + "). Looping...");
                    continue;
                }
                if (preventNearWorldSpawn > 0 && (distance = MathUtils.distance((worldSpawn = world.getSpawnLocation()).getBlockX(), worldSpawn.getBlockZ(), rx, rz)) < (double)preventNearWorldSpawn) {
                    DebugManager.debug("Too close from world spawn (" + distance.intValue() + " < " + preventNearWorldSpawn + "). Looping...");
                    continue;
                }
                if (preventNearOtherPlayers > 0) {
                    NearestPlayer nearestPlayer = FindLocation.getNearestPlayer(world, rx, rz, Set.copyOf(options.getSearchTask().getParty().getPlayers()));
                    DebugManager.debug("Nearest player: " + (String)(nearestPlayer.getPlayer() != null ? nearestPlayer.getPlayer().getName() + " at " + nearestPlayer.getDistance() : "None"));
                    if (nearestPlayer.getPlayer() != null && nearestPlayer.getDistance() < (double)preventNearOtherPlayers) {
                        DebugManager.debug("There's a player too close (" + nearestPlayer.getDistance().intValue() + " < " + preventNearOtherPlayers + "). Looping...");
                        continue;
                    }
                }
                requirementsMet = true;
            }
            DebugManager.debug("Testing coords: " + rx + ", " + rz + " (from Y: " + maxY + " -> " + minY + ")");
            for (int ry = maxY.intValue(); ry >= minY; --ry) {
                String currentMillis = String.valueOf(System.currentTimeMillis());
                Block block = world.getBlockAt(rx.intValue(), ry, rz.intValue());
                if (block.getType().equals((Object)Material.AIR) || !block.getType().isSolid() || block.getType().equals((Object)Material.WATER) || block.getType().equals((Object)Material.LAVA)) continue;
                Block up = block.getRelative(BlockFace.UP);
                Block upper = up.getRelative(BlockFace.UP);
                if (block.getType().isSolid() && up.getType().isSolid() && upper.getType().isSolid() || up.getType().isSolid() || up.isLiquid() || upper.getType().isSolid() || upper.isLiquid() || !worldOptions.getPreventBiomes().isEmpty() && worldOptions.getPreventBiomes().contains(world.getBiome(rx.intValue(), ry, rz.intValue())) || !worldOptions.getPreventBlocks().isEmpty() && (worldOptions.getPreventBlocks().contains(block.getType()) || worldOptions.getPreventBlocks().contains(up.getType()) || worldOptions.getPreventBlocks().contains(upper.getType()))) continue;
                DebugManager.debug("Safe block was found at Y: " + ry);
                completableFuture.complete(block.getLocation().add(0.5, 1.0, 0.5));
                return;
            }
            DebugManager.debug("No safe block was found");
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    private static NearestPlayer getNearestPlayer(World world, int x, int z, Set<Player> ignored) {
        return new NearestPlayer(world, x, z, ignored);
    }

    public static class NearestPlayer {
        private final World world;
        private final Integer x;
        private final Integer z;
        private final Player player;
        private final Set<Player> ignored;
        private final Double distance;

        private NearestPlayer(@Nonnull World world, int x, int z, Set<Player> ignored) {
            this.world = world;
            this.x = x;
            this.z = z;
            this.ignored = ignored;
            Player candidate = null;
            Double distanceCandidate = null;
            for (Player checking : world.getPlayers()) {
                if (ignored.contains(checking) || !checking.getWorld().getUID().equals(world.getUID())) continue;
                int blockX = checking.getLocation().getBlockX();
                int blockZ = checking.getLocation().getBlockZ();
                Double distance = MathUtils.distance(blockX, blockZ, x, z);
                if (distanceCandidate != null && distanceCandidate >= distance) continue;
                candidate = checking;
                distanceCandidate = distance;
            }
            this.distance = distanceCandidate;
            this.player = candidate;
        }

        @Nonnull
        public World getWorld() {
            return this.world;
        }

        @Nonnull
        public Integer getX() {
            return this.x;
        }

        @Nonnull
        public Integer getZ() {
            return this.z;
        }

        @Nullable
        public Player getPlayer() {
            return this.player;
        }

        @Nonnull
        public Set<Player> getIgnored() {
            return this.ignored;
        }

        @Nullable
        public Double getDistance() {
            return this.distance;
        }
    }
}

