/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.player;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.config.ConfigValue;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.player.PermissionsManager;
import dev.sergiferry.randomtp.teleportation.PersonalTeleportationHandler;
import dev.sergiferry.randomtp.teleportation.SearchTask;
import dev.sergiferry.randomtp.teleportation.TeleportationHandler;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import dev.sergiferry.randomtp.utils.ColorUtils;
import dev.sergiferry.randomtp.utils.ItemBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import nesancodev.com.xgui.component.Button;
import nesancodev.com.xgui.enums.GUIType;
import nesancodev.com.xgui.gui.GUI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class PlayerManager {
    private static final Map<Player, Long> lastTeleport = new HashMap<Player, Long>();
    private static final Map<String, Integer> cooldown = new HashMap<String, Integer>();
    private static BukkitTask cooldownTask;
    private static PlayerListener playerListener;

    public static void onEnable() {
        playerListener = new PlayerListener();
        cooldownTask = Bukkit.getScheduler().runTaskTimer((Plugin)RandomTeleportPlugin.getInstance(), () -> {
            for (Map.Entry<String, Integer> entry : cooldown.entrySet()) {
                int cool = entry.getValue();
                if (cool < 0) continue;
                if (cool > 0) {
                    cooldown.put(entry.getKey(), cool - 1);
                    continue;
                }
                if (cool != 0) continue;
                Player player = Bukkit.getPlayerExact((String)entry.getKey());
                if (player != null && player.isOnline()) {
                    MessagesManager.Message.COOLDOWN_FINISH.sendMessage((CommandSender)player, new Pair[0]);
                    cooldown.put(entry.getKey(), -1);
                    continue;
                }
                cooldown.remove(entry.getKey());
            }
        }, 20L, 20L);
    }

    public static void onDisable() {
        HandlerList.unregisterAll((Listener)playerListener);
        cooldownTask.cancel();
        SearchTask.cancelAll();
    }

    public static Integer getCooldown(Player player) {
        if (!PlayerManager.isCooldownTaskActive()) {
            return -1;
        }
        if (!cooldown.containsKey(player.getName())) {
            PlayerManager.cancelCooldown(player);
        }
        return cooldown.get(player.getName());
    }

    public static boolean isCooldownTaskActive() {
        return cooldownTask != null && !cooldownTask.isCancelled();
    }

    public static void cancelCooldown(Player player) {
        PlayerManager.setCooldown(player, -1);
    }

    private static void setCooldown(Player player, Integer seconds) {
        cooldown.put(player.getName(), seconds);
    }

    public static void setCooldown(Player player) {
        if (PermissionsManager.Permission.COOLDOWN_BYPASS.has(player)) {
            return;
        }
        if (!PlayerManager.isCooldownTaskActive()) {
            return;
        }
        PlayerManager.setCooldown(player, ConfigValue.TELEPORT_TIMER_COOLDOWN.get());
    }

    public static void setLastTeleport(Player player) {
        lastTeleport.put(player, System.currentTimeMillis());
    }

    public static boolean isInvincible(Player player) {
        boolean invincible;
        if (!lastTeleport.containsKey(player)) {
            return false;
        }
        boolean bl = invincible = System.currentTimeMillis() - lastTeleport.get(player) <= (long)(1000 * ConfigValue.TELEPORT_TIMER_INVINCIBLE.get());
        if (!invincible) {
            lastTeleport.remove(player);
        }
        return invincible;
    }

    public static boolean hasAdvancement(Player player, String advancement) {
        Advancement ach = Bukkit.getServer().getAdvancement(NamespacedKey.minecraft((String)advancement));
        if (ach == null) {
            return false;
        }
        return player.getAdvancementProgress(ach).isDone();
    }

    /*
     * WARNING - void declaration
     */
    public static GUI confirmAction(final Player player, final Consumer<Player> confirm, String ... description) {
        final GUI gui = new GUI(MessagesManager.Message.GUI_CONFIRMATION_TITLE.getValue(player), GUIType.CHEST, 27);
        gui.lock();
        ArrayList<Object> lines = new ArrayList<Object>();
        for (int i = 0; i < description.length; ++i) {
            void var7_9;
            int ls = 0;
            String string = "";
            Integer MAX_LENGTH = 24;
            for (String qs : description[i].split(" ")) {
                String string2 = (String)var7_9 + qs + " ";
                if ((ls += qs.length()) < MAX_LENGTH) continue;
                lines.add(string2);
                String string3 = "";
                ls = 0;
            }
            if (var7_9 == "") continue;
            lines.add(var7_9);
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        for (String string : lines) {
            lore.add("\u00a77" + string);
        }
        gui.setSlot(11, new ItemBuilder(Material.GREEN_CONCRETE).setName("\u00a7a\u00a7l" + MessagesManager.Message.GUI_CONFIRMATION_CONFIRM.getValue(player)).setLore(lore).getItemStack());
        gui.setSlot(15, new ItemBuilder(Material.RED_CONCRETE).setName("\u00a7c\u00a7l" + MessagesManager.Message.GUI_CONFIRMATION_DECLINE.getValue(player)).setLore(lore).getItemStack());
        gui.addButton(11, new Button(new BukkitRunnable(){

            public void run() {
                if (confirm != null) {
                    confirm.accept(player);
                }
                gui.close(player);
                gui.clear();
            }
        }));
        gui.addButton(15, new Button(new BukkitRunnable(){

            public void run() {
                gui.close(player);
                gui.clear();
            }
        }));
        gui.open(player);
        return gui;
    }

    public static class PlayerListener
    implements Listener {
        private NamespacedKey signWorld;
        private NamespacedKey signAlias;
        private Set<Sign> updatedSigns = new HashSet<Sign>();

        public PlayerListener() {
            this.signWorld = new NamespacedKey((Plugin)RandomTeleportPlugin.getInstance(), "sign-world");
            this.signAlias = new NamespacedKey((Plugin)RandomTeleportPlugin.getInstance(), "sign-alias");
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RandomTeleportPlugin.getInstance());
        }

        @EventHandler
        public void onJoin(PlayerJoinEvent event) {
            Player player = event.getPlayer();
            if (!cooldown.containsKey(player.getName())) {
                PlayerManager.cancelCooldown(player);
            }
        }

        @EventHandler
        public void onQuit(PlayerQuitEvent event) {
            Player player = event.getPlayer();
            if (SearchTask.isSearching(player)) {
                SearchTask.getSearching(player).cancel(player, SearchTask.Reason.DECISION);
            }
        }

        @EventHandler
        public void onSign(SignChangeEvent event) {
            World world;
            Player player = event.getPlayer();
            String line0 = event.getLine(0);
            if (!line0.equalsIgnoreCase("[RandomTP]") && !line0.equalsIgnoreCase("[RTP]")) {
                return;
            }
            if (!PermissionsManager.Permission.CREATE_SIGN.has(player)) {
                for (int i = 0; i <= 3; ++i) {
                    event.setLine(i, "");
                }
                MessagesManager.Message.SIGN_CREATE_NO_PERMISSIONS.sendMessage((CommandSender)player, new Pair[0]);
                return;
            }
            Sign sign = (Sign)event.getBlock().getState();
            String worldName = player.getWorld().getName();
            if (!event.getLine(1).isEmpty()) {
                String line = event.getLine(1);
                World world2 = null;
                if (line.equalsIgnoreCase("end") || line.equalsIgnoreCase("the_end")) {
                    world2 = Bukkit.getWorlds().stream().filter(x -> x.getEnvironment().equals((Object)World.Environment.THE_END)).findAny().orElse(null);
                }
                if (line.equalsIgnoreCase("nether")) {
                    world2 = Bukkit.getWorlds().stream().filter(x -> x.getEnvironment().equals((Object)World.Environment.NETHER)).findAny().orElse(null);
                }
                worldName = world2 != null ? world2.getName() : event.getLine(1);
            }
            if ((world = Bukkit.getWorld((String)worldName)) == null) {
                MessagesManager.Message.WORLD_NO_EXIST.sendMessage((CommandSender)player, new Pair[0]);
                this.error(event, "Incorrect world");
                return;
            }
            WorldOptions worldOptions = WorldOptions.of(world);
            if (worldOptions == null) {
                MessagesManager.Message.WORLD_NO_CONFIG.sendMessage((CommandSender)player, new Pair[0]);
                this.error(event, "World not loaded");
                return;
            }
            String alias = worldOptions.getAlias();
            if (!event.getLine(2).isEmpty()) {
                alias = event.getLine(2);
                sign.getPersistentDataContainer().set(this.signAlias, PersistentDataType.STRING, (Object)alias);
            }
            alias = ColorUtils.color(alias);
            List<String> lines = ColorUtils.color(MessagesManager.Message.SIGN_TEXT_IDLE.getValue());
            for (int i = 0; i < 4; ++i) {
                event.setLine(i, MessagesManager.placeholder(lines.get(i), Pair.of((Object)"world", (Object)alias), Pair.of((Object)"level", (Object)("" + worldOptions.getRequirementsLevelAmount())), Pair.of((Object)"price", (Object)("" + worldOptions.getPrice()))));
            }
            sign.getPersistentDataContainer().set(this.signWorld, PersistentDataType.STRING, (Object)worldName);
            sign.update();
            MessagesManager.Message.SIGN_CREATE_SUCCESS.sendMessage((CommandSender)player, Pair.of((Object)"world", (Object)alias));
        }

        private void error(SignChangeEvent event, String error) {
            event.setLine(0, "\u00a7cError creating");
            event.setLine(1, "\u00a7cRandomTP sign.");
            event.setLine(2, "");
            event.setLine(3, "\u00a7f" + error);
        }

        @EventHandler
        public void onInteract(PlayerInteractEvent event) {
            Player player = event.getPlayer();
            if (event.getClickedBlock() == null) {
                return;
            }
            if (!(event.getClickedBlock().getState() instanceof Sign)) {
                return;
            }
            Sign sign = (Sign)event.getClickedBlock().getState();
            if (!sign.getPersistentDataContainer().has(this.signWorld, PersistentDataType.STRING)) {
                return;
            }
            if (!PermissionsManager.Permission.USE.has(player) && !PermissionsManager.Permission.USE_SIGN.has(player)) {
                PermissionsManager.sendPermissionsMessage(player);
                return;
            }
            if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
                    PersonalTeleportationHandler personalTeleportationHandler;
                    if (!TeleportationHandler.isTeleportationHandler(sign)) {
                        TeleportationHandler.registerPersonalHandler(TeleportationHandler.Type.SIGN, sign);
                    }
                    if (!(personalTeleportationHandler = (PersonalTeleportationHandler)TeleportationHandler.getHandler(TeleportationHandler.Type.SIGN, sign)).hasSearchTask(player)) {
                        return;
                    }
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RandomTeleportPlugin.getInstance(), () -> {
                        if (personalTeleportationHandler.hasSearchTask(player)) {
                            personalTeleportationHandler.getSearchTask(player).cancel(player, SearchTask.Reason.DECISION);
                        }
                    }, 1L);
                }
                return;
            }
            event.setUseInteractedBlock(Event.Result.DENY);
            if (SearchTask.isSearching(player)) {
                SearchTask searchTask = SearchTask.getSearching(player);
                if (searchTask.getHandler().getType().equals(TeleportationHandler.Type.SIGN) && searchTask.getHandler().getValue().equals(sign)) {
                    MessagesManager.Message.TELEPORT_WANT_CANCEL_SIGN.sendMessage((CommandSender)player, new Pair[0]);
                } else {
                    MessagesManager.Message.TELEPORT_ALREADY.sendMessage((CommandSender)player, new Pair[0]);
                }
                return;
            }
            String worldName = (String)sign.getPersistentDataContainer().get(this.signWorld, PersistentDataType.STRING);
            World world = RandomTeleportPlugin.getInstance().getServer().getWorld(worldName);
            if (world == null) {
                MessagesManager.Message.WORLD_NO_EXIST.sendMessage((CommandSender)player, new Pair[0]);
                return;
            }
            WorldOptions worldOptions = WorldOptions.of(world);
            if (worldOptions == null) {
                MessagesManager.Message.WORLD_NO_CONFIG.sendMessage((CommandSender)player, new Pair[0]);
                return;
            }
            if (!TeleportationHandler.isTeleportationHandler(sign)) {
                TeleportationHandler.registerPersonalHandler(TeleportationHandler.Type.SIGN, sign);
            }
            TeleportationHandler<Sign> handler = TeleportationHandler.getHandler(TeleportationHandler.Type.SIGN, sign);
            boolean updatedOld = this.updateOldSign(sign, worldOptions);
            handler.confirmTeleport(player, world, this.getColoredAlias(handler, worldOptions), () -> Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RandomTeleportPlugin.getInstance(), () -> this.updateSearchingSign(player, handler, worldOptions), updatedOld ? 3L : 1L));
        }

        private boolean updateOldSign(Sign sign, WorldOptions worldOptions) {
            if (this.updatedSigns.contains(this)) {
                return false;
            }
            String alias = worldOptions.getAlias();
            if (sign.getPersistentDataContainer().has(this.signAlias, PersistentDataType.STRING)) {
                alias = (String)sign.getPersistentDataContainer().get(this.signAlias, PersistentDataType.STRING);
            }
            alias = ColorUtils.color(alias);
            List<String> lines = ColorUtils.color(MessagesManager.Message.SIGN_TEXT_IDLE.getValue());
            for (int i = 0; i < 4; ++i) {
                sign.setLine(i, MessagesManager.placeholder(lines.get(i), Pair.of((Object)"world", (Object)alias), Pair.of((Object)"level", (Object)("" + worldOptions.getRequirementsLevelAmount())), Pair.of((Object)"price", (Object)("" + worldOptions.getPrice()))));
            }
            sign.update();
            this.updatedSigns.add(sign);
            return true;
        }

        private void updateSearchingSign(Player player, TeleportationHandler<Sign> handler, WorldOptions worldOptions) {
            SearchTask searchTask = SearchTask.getSearching(player);
            if (searchTask != null && searchTask.getHandler().equals(handler)) {
                List<String> lines = ColorUtils.color(MessagesManager.Message.SIGN_TEXT_SEARCHING.getValue(player));
                String alias = ColorUtils.color(handler.getValue().getPersistentDataContainer().has(this.signAlias, PersistentDataType.STRING) ? (String)handler.getValue().getPersistentDataContainer().get(this.signAlias, PersistentDataType.STRING) : worldOptions.getAlias());
                String[] signLines = new String[4];
                for (int i = 0; i < 4; ++i) {
                    signLines[i] = MessagesManager.placeholder(lines.get(i), Pair.of((Object)"world", (Object)alias), Pair.of((Object)"level", (Object)("" + worldOptions.getRequirementsLevelAmount())), Pair.of((Object)"price", (Object)("" + worldOptions.getPrice())));
                }
                player.sendSignChange(handler.getValue().getLocation(), signLines);
            }
        }

        public String getColoredAlias(TeleportationHandler<Sign> handler, WorldOptions worldOptions) {
            return ColorUtils.color(handler.getValue().getPersistentDataContainer().has(this.signAlias, PersistentDataType.STRING) ? (String)handler.getValue().getPersistentDataContainer().get(this.signAlias, PersistentDataType.STRING) : worldOptions.getAlias());
        }

        @EventHandler
        public void onSignBreak(BlockBreakEvent event) {
            PersonalTeleportationHandler personalTeleportationHandler;
            Player player = event.getPlayer();
            if (!(event.getBlock().getState() instanceof Sign)) {
                return;
            }
            Sign sign = (Sign)event.getBlock().getState();
            if (!sign.getPersistentDataContainer().has(this.signWorld, PersistentDataType.STRING)) {
                return;
            }
            event.setCancelled(true);
            if (!PermissionsManager.Permission.CREATE_SIGN.has(player)) {
                return;
            }
            TeleportationHandler<Sign> handler = TeleportationHandler.getHandler(TeleportationHandler.Type.SIGN, sign);
            if (handler != null && !handler.isGroupTeleport() && (personalTeleportationHandler = (PersonalTeleportationHandler)handler).getSearchTask(player) != null) {
                return;
            }
            if (!event.getPlayer().isSneaking()) {
                MessagesManager.Message.SIGN_REMOVE_SHIFT.sendMessage((CommandSender)player, new Pair[0]);
                return;
            }
            String aliasWorld = "\u00a7cUnknown world";
            String worldName = (String)sign.getPersistentDataContainer().get(this.signWorld, PersistentDataType.STRING);
            World world = RandomTeleportPlugin.getInstance().getServer().getWorld(worldName);
            if (world != null) {
                aliasWorld = world.getName();
                WorldOptions worldOptions = WorldOptions.of(world);
                if (worldOptions != null) {
                    aliasWorld = handler != null ? this.getColoredAlias(handler, worldOptions) : ColorUtils.color(worldOptions.getAlias());
                }
            }
            PlayerManager.confirmAction(player, p -> {
                if (event.getBlock().breakNaturally()) {
                    MessagesManager.Message.SIGN_REMOVE_SUCCESS.sendMessage((CommandSender)p, new Pair[0]);
                }
            }, MessagesManager.placeholder(MessagesManager.Message.GUI_CONFIRMATION_QUESTION_REMOVE_SIGN, player, Pair.of((Object)"world", (Object)aliasWorld)));
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onDamage(EntityDamageEvent event) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getEntity();
            if (PlayerManager.isInvincible(player)) {
                event.setDamage(0.0);
            }
            if (event.isCancelled() || event.getDamage() <= 0.0) {
                return;
            }
            if (!ConfigValue.TELEPORT_CANCEL_DAMAGE.get().booleanValue()) {
                return;
            }
            this.cancelConditionTeleport(player);
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onTeleport(PlayerTeleportEvent event) {
            Player player = event.getPlayer();
            if (event.isCancelled()) {
                return;
            }
            if (!ConfigValue.TELEPORT_CANCEL_TELEPORT.get().booleanValue()) {
                return;
            }
            this.cancelConditionTeleport(player);
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onMove(PlayerMoveEvent event) {
            Player player = event.getPlayer();
            if (event.isCancelled()) {
                return;
            }
            if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
                return;
            }
            if (!ConfigValue.TELEPORT_CANCEL_MOVE.get().booleanValue()) {
                return;
            }
            this.cancelConditionTeleport(player);
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onSneak(PlayerToggleSneakEvent event) {
            Player player = event.getPlayer();
            if (event.isCancelled()) {
                return;
            }
            if (!ConfigValue.TELEPORT_CANCEL_SNEAK.get().booleanValue()) {
                return;
            }
            this.cancelConditionTeleport(player);
        }

        private void cancelConditionTeleport(Player player) {
            SearchTask searchTask = SearchTask.getSearching(player);
            if (searchTask == null) {
                return;
            }
            if (searchTask.getHandler().isGroupTeleport()) {
                return;
            }
            searchTask.cancel(player, SearchTask.Reason.DECISION);
        }
    }
}

