/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.player;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.config.ConfigValue;
import dev.sergiferry.randomtp.messages.MessagesManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PermissionsManager {
    private static boolean hasPermission(Player player, String permission, boolean op) {
        if (!ConfigValue.USE_PERMISSIONS.get().booleanValue()) {
            if (op) {
                return player.isOp();
            }
            return true;
        }
        return player.isOp() || player.hasPermission(PermissionsManager.formatPermission(permission)) || player.hasPermission(PermissionsManager.formatPermission(Permission.ADMIN.getPermission()));
    }

    private static String formatPermission(String permission) {
        return PermissionsManager.getPluginName() + "." + permission;
    }

    public static void sendPermissionsMessage(Player player) {
        MessagesManager.Message.NO_PERMISSIONS.sendMessage((CommandSender)player, new Pair[0]);
    }

    private static String getPluginName() {
        return RandomTeleportPlugin.getInstance().getDescription().getName().toLowerCase();
    }

    public static class Permission {
        public static final Permission ADMIN = new Permission("*", true);
        public static final Permission USE = new Permission("use", false);
        public static final Permission USE_COMMAND = new Permission("use.command", false);
        public static final Permission USE_SIGN = new Permission("use.sign", false);
        public static final Permission COOLDOWN_BYPASS = new Permission("cooldown.bypass", true);
        public static final Permission CREATE_NPC = new Permission("create.npc", true);
        public static final Permission CREATE_SIGN = new Permission("create.sign", true);
        private String permission;
        private boolean op;

        public Permission(String permission, boolean op) {
            this.permission = permission;
            this.op = op;
        }

        public boolean has(Player player) {
            return PermissionsManager.hasPermission(player, this.permission, this.op);
        }

        public String getPermission() {
            return this.permission;
        }

        public boolean isOp() {
            return this.op;
        }
    }
}

