/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.messages.handlers;

import dev.sergiferry.randomtp.config.ConfigManager;
import dev.sergiferry.randomtp.config.ConfigValue;
import dev.sergiferry.randomtp.messages.MessagesHandler;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.utils.ColorUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Player;

public class LocalMessagesManager
implements MessagesHandler {
    @Override
    @ColorUtils.Colored(colored=true)
    public String getMessageString(@Nullable Player player, @Nonnull String code) {
        Validate.isTrue((boolean)MessagesManager.Message.getMessage(code).getType().equals(String.class));
        return this.formatString(ConfigManager.MESSAGES.getFileConfiguration().getString(code));
    }

    @Override
    @ColorUtils.Colored(colored=true)
    public List<String> getMessageList(@Nullable Player player, @Nonnull String code) {
        Validate.isTrue((boolean)MessagesManager.Message.getMessage(code).getType().equals(List.class));
        List list = ConfigManager.MESSAGES.getFileConfiguration().getStringList(code);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, this.formatString((String)list.get(i)));
        }
        return list;
    }

    private String formatString(String string) {
        string = string.replaceAll("\\{command}", "/" + ConfigValue.COMMAND_LABEL.get());
        string = string.replaceAll("\\{prefix}", ConfigManager.MESSAGES.getFileConfiguration().getString(MessagesManager.Message.PREFIX.getCode()));
        string = ColorUtils.color(string);
        return string;
    }
}

