/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.messages.handlers;

import dev.sergiferry.languages.api.Language;
import dev.sergiferry.languages.api.LanguagesAPI;
import dev.sergiferry.languages.api.Translation;
import dev.sergiferry.randomtp.debug.DebugManager;
import dev.sergiferry.randomtp.integration.IntegrationsManager;
import dev.sergiferry.randomtp.messages.MessagesHandler;
import dev.sergiferry.randomtp.messages.MessagesManager;
import java.util.List;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguagesAPIMessagesManager
implements MessagesHandler {
    private LanguagesAPI.PluginManager pluginManager;

    public LanguagesAPIMessagesManager() {
        DebugManager.debug("Using LanguagesAPI Message Handler");
        this.pluginManager = IntegrationsManager.getLanguagesAPI().getPluginManager();
    }

    @Override
    public void onEnable() {
        this.pluginManager.setDefaultTranslations(Language.en_US, MessagesManager.Message.getDefaults());
        this.setDefaultTranslation(Language.es_ES, MessagesManager.Message.WORLD_NO_EXIST, "&cEste mundo no existe.");
        this.pluginManager.saveDefaults();
    }

    public <T> void setDefaultTranslation(Language language, MessagesManager.Message<T> message, T def) {
        Translation.Type type = Translation.Type.STRING;
        if (message.getType().equals(List.class)) {
            type = Translation.Type.LIST;
        }
        this.pluginManager.setDefaultTranslation(language, message.getCode(), type, def);
    }

    @Override
    public String getMessageString(@Nullable Player player, @NotNull String code) {
        if (code == null) {
            LanguagesAPIMessagesManager.$$$reportNull$$$0(0);
        }
        return (String)this.pluginManager.getTranslation(code, Translation.Type.STRING).getForPlayer(player);
    }

    @Override
    public List<String> getMessageList(@Nullable Player player, @NotNull String code) {
        if (code == null) {
            LanguagesAPIMessagesManager.$$$reportNull$$$0(1);
        }
        return (List)this.pluginManager.getTranslation(code, Translation.Type.LIST).getForPlayer(player);
    }

    @Override
    public String getMessageString(@NotNull String code) {
        if (code == null) {
            LanguagesAPIMessagesManager.$$$reportNull$$$0(2);
        }
        return (String)this.pluginManager.getTranslation(code, Translation.Type.STRING).getInServerDefaultLanguage();
    }

    @Override
    public List<String> getMessageList(@NotNull String code) {
        if (code == null) {
            LanguagesAPIMessagesManager.$$$reportNull$$$0(3);
        }
        return (List)this.pluginManager.getTranslation(code, Translation.Type.LIST).getInServerDefaultLanguage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "code";
        objectArray2[1] = "dev/sergiferry/randomtp/messages/handlers/LanguagesAPIMessagesManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMessageString";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMessageList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

