/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.messages;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.randomtp.config.ConfigManager;
import dev.sergiferry.randomtp.config.ConfigValue;
import dev.sergiferry.randomtp.integration.IntegrationsManager;
import dev.sergiferry.randomtp.messages.MessagesHandler;
import dev.sergiferry.randomtp.messages.handlers.LanguagesAPIMessagesManager;
import dev.sergiferry.randomtp.messages.handlers.LocalMessagesManager;
import dev.sergiferry.randomtp.utils.ColorUtils;
import dev.sergiferry.spigot.server.ServerVersion;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.apache.commons.lang.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessagesManager {
    private static MessagesHandler handler;

    public static void onEnable() {
        MessagesManager.setHandler(IntegrationsManager.isUsingLanguagesAPI() ? new LanguagesAPIMessagesManager() : new LocalMessagesManager());
    }

    public static void onDisable() {
        handler.onDisable();
    }

    public static void setHandler(MessagesHandler messagesHandler) {
        handler = messagesHandler;
        handler.onEnable();
    }

    public static MessagesHandler getHandler() {
        return handler;
    }

    public static String getMessageString(@Nullable Player player, @Nonnull String code) {
        return handler.getMessageString(player, code);
    }

    public static List<String> getMessageList(@Nullable Player player, @Nonnull String code) {
        return handler.getMessageList(player, code);
    }

    public static String getMessageString(@Nonnull String code) {
        return MessagesManager.getMessageString(null, code);
    }

    public static List<String> getMessageList(@Nonnull String code) {
        return MessagesManager.getMessageList(null, code);
    }

    public static String placeholder(@Nonnull Message<String> message, Player player, Pair<String, String> ... placeholders) {
        return MessagesManager.placeholder(message.getValue(player), placeholders);
    }

    public static String placeholder(@Nonnull String message, Pair<String, String> ... placeholders) {
        if (placeholders != null) {
            for (Pair<String, String> placeholder : placeholders) {
                message = message.replaceAll("\\{" + (String)placeholder.getFirst() + "}", (String)placeholder.getSecond());
            }
        }
        return message;
    }

    public static String placeholderAndColor(@Nonnull Message<String> message, Player player, Pair<String, String> ... placeholders) {
        String displayMessage = ColorUtils.color(message.getValue(player));
        return MessagesManager.placeholder(displayMessage, placeholders);
    }

    public static String placeholderAndColor(@Nonnull String message, Pair<String, String> ... placeholders) {
        String displayMessage = ColorUtils.color(message);
        return MessagesManager.placeholder(displayMessage, placeholders);
    }

    public static class Message<T> {
        private static HashMap<String, Message> MESSAGES = new HashMap();
        public static final Message<String> PREFIX = new Message<String>("PREFIX", String.class, "&b&lRandomTP &8|");
        public static final Message<String> NO_PERMISSIONS = new Message<String>("NO_PERMISSIONS", String.class, ChatMessageType.CHAT, "{prefix} &cYou don't have permissions to do this.");
        public static final Message<String> GUI_CONFIRMATION_TITLE = new Message<String>("GUI.CONFIRMATION.TITLE", String.class, "Confirm action");
        public static final Message<String> GUI_CONFIRMATION_CONFIRM = new Message<String>("GUI.CONFIRMATION.CONFIRM", String.class, "Confirm");
        public static final Message<String> GUI_CONFIRMATION_DECLINE = new Message<String>("GUI.CONFIRMATION.DECLINE", String.class, "Decline");
        public static final Message<String> GUI_CONFIRMATION_QUESTION_REMOVE_NPC = new Message<String>("GUI.CONFIRMATION.QUESTION.REMOVE_NPC", String.class, "Remove NPC {id} with destination to {world}");
        public static final Message<String> GUI_CONFIRMATION_QUESTION_REMOVE_SIGN = new Message<String>("GUI.CONFIRMATION.QUESTION.REMOVE_SIGN", String.class, "Remove Sign with destination to {world}");
        public static final Message<String> GUI_CONFIRMATION_QUESTION_PAY_RTP = new Message<String>("GUI.CONFIRMATION.QUESTION.PAY_RTP", String.class, "Pay the cost to search for a random location at {world}");
        public static final Message<String> GUI_CONFIRMATION_COST_TITLE = new Message<String>("GUI.CONFIRMATION.COST.TITLE", String.class, "Teleport cost");
        public static final Message<String> GUI_CONFIRMATION_COST_PRICE = new Message<String>("GUI.CONFIRMATION.COST.PRICE", String.class, "&7Price: &6{price} $");
        public static final Message<String> GUI_CONFIRMATION_COST_XP = new Message<String>("GUI.CONFIRMATION.COST.XP", String.class, "&7XP: &d{levels} level(s)");
        public static final Message<String> SIGN_CREATE_NO_PERMISSIONS = new Message<String>("SIGN.CREATE.NO_PERMISSIONS", String.class, ChatMessageType.CHAT, "{prefix} &cYou do not have permission to create RandomTP signs.");
        public static final Message<String> SIGN_CREATE_SUCCESS = new Message<String>("SIGN.CREATE.SUCCESS", String.class, ChatMessageType.CHAT, "{prefix} &aYou have created a sign for world {world}.");
        public static final Message<String> SIGN_REMOVE_SHIFT = new Message<String>("SIGN.REMOVE.SHIFT", String.class, ChatMessageType.ACTION_BAR, "&7To remove a sign press &cshift + left click");
        public static final Message<String> SIGN_REMOVE_SUCCESS = new Message<String>("SIGN.REMOVE.SUCCESS", String.class, ChatMessageType.CHAT, "{prefix} &7Sign &cremoved &7successfully");
        public static final Message<List<String>> SIGN_TEXT_IDLE = new Message<List<String>>("SIGN.TEXT.IDLE", List.class, Arrays.asList("&b&lRandomTP", "&a{world}", "", "&eClick to teleport"));
        public static final Message<List<String>> SIGN_TEXT_SEARCHING = new Message<List<String>>("SIGN.TEXT.SEARCHING", List.class, Arrays.asList("&b&lRandomTP", "&a{world}", "", "&cPunch to cancel"));
        public static final Message<String> COMMAND_DISABLED = new Message<String>("COMMAND.DISABLED", String.class, ChatMessageType.ACTION_BAR, "&cRandomTP command is disabled.");
        public static final Message<String> COMMAND_ERROR_MUST_BE_PLAYER = new Message<String>("COMMAND.ERROR.MUST_BE_PLAYER", String.class, ChatMessageType.CHAT, "{prefix} &cYou must be a player to do this.");
        public static final Message<String> COMMAND_ERROR_PLAYER_NOT_FOUND = new Message<String>("COMMAND.ERROR.PLAYER_NOT_FOUND", String.class, ChatMessageType.CHAT, "{prefix} &cPlayer not found.");
        public static final Message<String> COMMAND_ERROR_USAGE = new Message<String>("COMMAND.ERROR.USAGE", String.class, ChatMessageType.CHAT, "{prefix} &7Usage: &e/{usage}");
        public static final Message<String> COMMAND_ERROR_NO_DEPENDENCY = new Message<String>("COMMAND.ERROR.NO_DEPENDENCY", String.class, "{prefix} &7You must use &e{dependency} &7dependency to use this. Download it at:\n&e{link}");
        public static final Message<String> COMMAND_ERROR_WORLD_NOT_RECOGNIZED = new Message<String>("COMMAND.ERROR.WORLD_NOT_RECOGNIZED", String.class, ChatMessageType.CHAT, "{prefix} &cWorld '{world}' is not recognized.");
        public static final Message<String> COMMAND_ERROR_COLOR_NOT_RECOGNIZED = new Message<String>("COMMAND.ERROR.COLOR_NOT_RECOGNIZED", String.class, ChatMessageType.CHAT, "{prefix} &cColor '{color}' is not recognized.");
        public static final Message<String> WORLD_DISABLED_COMMAND = new Message<String>("WORLD.DISABLED_COMMAND", String.class, ChatMessageType.ACTION_BAR, "&cRandomTP is disabled in this world.");
        public static final Message<String> WORLD_NO_EXIST = new Message<String>("WORLD.NO_EXIST", String.class, ChatMessageType.ACTION_BAR, "&cThis world doesn't exist.");
        public static final Message<String> WORLD_NO_CONFIG = new Message<String>("WORLD.NO_CONFIG", String.class, ChatMessageType.CHAT, "{prefix} &cThis world doesn't exist on RandomTP configuration file.");
        public static final Message<String> WORLD_REQUIREMENT_NETHER_GONE = new Message<String>("WORLD.REQUIREMENT.NETHER.GONE", String.class, ChatMessageType.ACTION_BAR, "&cYou must discover the Nether before doing a RandomTP");
        public static final Message<String> WORLD_REQUIREMENT_END_GONE = new Message<String>("WORLD.REQUIREMENT.END.GONE", String.class, ChatMessageType.ACTION_BAR, "&cYou must discover The End before doing a RandomTP");
        public static final Message<String> WORLD_REQUIREMENT_END_DRAGON = new Message<String>("WORLD.REQUIREMENT.END.DRAGON", String.class, ChatMessageType.ACTION_BAR, "&cYou must kill the dragon before doing a RandomTP");
        public static final Message<String> WORLD_REQUIREMENT_LEVEL = new Message<String>("WORLD.REQUIREMENT.LEVEL", String.class, ChatMessageType.ACTION_BAR, "&cYou must have {level} experience levels to do a RandomTP.");
        public static final Message<String> WORLD_REQUIREMENT_LEVEL_SUCCESS = new Message<String>("WORLD.REQUIREMENT.LEVEL_SUCCESS", String.class, ChatMessageType.CHAT, "{prefix} &cYou have paid {level} experience levels.");
        public static final Message<String> TELEPORT_FOUND = new Message<String>("TELEPORT.FOUND", String.class, ChatMessageType.ACTION_BAR, "&aRandomTP location was found, starting teleport...");
        public static final Message<String> TELEPORT_NOT_FOUND = new Message<String>("TELEPORT.NOT_FOUND", String.class, ChatMessageType.ACTION_BAR, "&cIt has not been possible to find a random location.");
        public static final Message<String> TELEPORT_ALREADY = new Message<String>("TELEPORT.ALREADY", String.class, ChatMessageType.ACTION_BAR, "&cAlready searching for random location");
        public static final Message<String> TELEPORT_WAITING = new Message<String>("TELEPORT.WAITING", String.class, ChatMessageType.ACTION_BAR, "&6Waiting for more players...");
        public static final Message<String> TELEPORT_STARTED = new Message<String>("TELEPORT.STARTED", String.class, ChatMessageType.ACTION_BAR, "&aStarted searching random location.");
        public static final Message<String> TELEPORT_SEARCHING = new Message<String>("TELEPORT.SEARCHING", String.class, ChatMessageType.ACTION_BAR, "&eSearching for a random location...");
        public static final Message<String> TELEPORT_COMPLETE = new Message<String>("TELEPORT.COMPLETE", String.class, ChatMessageType.ACTION_BAR, "&bYou've been teleported to random location");
        public static final Message<String> TELEPORT_CANCELLED = new Message<String>("TELEPORT.CANCELLED", String.class, ChatMessageType.ACTION_BAR, "&cRandomTP search has been cancelled");
        public static final Message<String> TELEPORT_SAME_FLOOR_NPC_GROUP = new Message<String>("TELEPORT.SAME_FLOOR.NPC_GROUP", String.class, ChatMessageType.ACTION_BAR, "&cYou must step the same floor as NPC to join Group Teleport.");
        public static final Message<String> TELEPORT_WANT_CANCEL_COMMAND = new Message<String>("TELEPORT.WANT_CANCEL.COMMAND", String.class, ChatMessageType.ACTION_BAR, "&cIf you want to cancel RandomTP use {command}");
        public static final Message<String> TELEPORT_WANT_CANCEL_SIGN = new Message<String>("TELEPORT.WANT_CANCEL.SIGN", String.class, ChatMessageType.ACTION_BAR, "&cIf you want to cancel RandomTP do Left Click on the Sign.");
        public static final Message<String> TELEPORT_WANT_CANCEL_NPC_PERSONAL = new Message<String>("TELEPORT.WANT_CANCEL.NPC_PERSONAL", String.class, ChatMessageType.ACTION_BAR, "&cIf you want to cancel RandomTP do Left Click on NPC");
        public static final Message<String> TELEPORT_WANT_CANCEL_NPC_GROUP = new Message<String>("TELEPORT.WANT_CANCEL.NPC_GROUP", String.class, ChatMessageType.ACTION_BAR, "&cIf you want to cancel RandomTP walk away from the NPC");
        public static final Message<String> COOLDOWN_ALREADY = new Message<String>("COOLDOWN.ALREADY", String.class, ChatMessageType.ACTION_BAR, "&cYou have to wait {cooldown} seconds before another random teleport.");
        public static final Message<String> COOLDOWN_FINISH = new Message<String>("COOLDOWN.FINISH", String.class, ChatMessageType.ACTION_BAR, "&aThe cooldown has finished, now you can teleport.");
        public static final Message<String> VAULT_NO_BALANCE = new Message<String>("INTEGRATIONS.VAULT.NO_BALANCE", String.class, ChatMessageType.CHAT, "{prefix} &cYou don't have enough money, the price is {price} $ and you have {balance} $");
        public static final Message<String> VAULT_SUCCESS = new Message<String>("INTEGRATIONS.VAULT.SUCCESS", String.class, ChatMessageType.CHAT, "{prefix} &aYou successfully paid {price} $ for RandomTP");
        public static final Message<String> VAULT_ERROR = new Message<String>("INTEGRATIONS.VAULT.ERROR", String.class, ChatMessageType.CHAT, "{prefix} &cError on payment: {error}");
        public static final Message<List<String>> PLAYERNPC_TEXT_PERSONAL_IDLE = new Message<List<String>>("INTEGRATIONS.PLAYERNPC.TEXT.PERSONAL.IDLE", List.class, Arrays.asList("&bRandom Teleport", "&a{world}", "&e&lRIGHT CLICK"));
        public static final Message<List<String>> PLAYERNPC_TEXT_PERSONAL_SEARCHING = new Message<List<String>>("INTEGRATIONS.PLAYERNPC.TEXT.PERSONAL.SEARCHING", List.class, Arrays.asList("&bRandom Teleport", "&aSearching location...", "&c&lPUNCH TO CANCEL"));
        public static final Message<List<String>> PLAYERNPC_TEXT_GROUP_IDLE = new Message<List<String>>("INTEGRATIONS.PLAYERNPC.TEXT.GROUP.IDLE", List.class, Arrays.asList("&bRandom Group Teleport", "&a{world}", "&e&lRIGHT CLICK"));
        public static final Message<List<String>> PLAYERNPC_TEXT_GROUP_WAITING = new Message<List<String>>("INTEGRATIONS.PLAYERNPC.TEXT.GROUP.WAITING", List.class, Arrays.asList("&bRandom Group Teleport", "&6Waiting for {players} more player(s)...", "&c&lWALK AWAY TO CANCEL"));
        public static final Message<List<String>> PLAYERNPC_TEXT_GROUP_SEARCHING = new Message<List<String>>("INTEGRATIONS.PLAYERNPC.TEXT.GROUP.SEARCHING", List.class, Arrays.asList("&bRandom Group Teleport", "&aSearching location for {players} player(s)...", "&c&lWALK AWAY TO CANCEL"));
        public static final Message<String> PLAYERNPC_COMMAND_INCORRECT = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.INCORRECT", String.class, ChatMessageType.CHAT, "{prefix} &cIncorrect command. &7Use '{command}' to see the command list.");
        public static final Message<String> PLAYERNPC_COMMAND_TITLE = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.TITLE", String.class, "{prefix} &7RandomTP NPC commands:");
        public static final Message<String> PLAYERNPC_COMMAND_ID_NOT_SPECIFIED = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.ID.NOT_SPECIFIED", String.class, ChatMessageType.CHAT, "{prefix} &cYou need to specify (id) of the NPC");
        public static final Message<String> PLAYERNPC_COMMAND_ID_NOT_VALID = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.ID.NOT_VALID", String.class, ChatMessageType.CHAT, "{prefix} &cSpecified id '{id}' is not valid.");
        public static final Message<String> PLAYERNPC_COMMAND_ID_NOT_FOUND = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.ID.NOT_FOUND", String.class, ChatMessageType.CHAT, "{prefix} &cNo NPC with id {id} was found.");
        public static final Message<String> PLAYERNPC_COMMAND_CREATE_SUCCESS = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.CREATE.SUCCESS", String.class, ChatMessageType.CHAT, "{prefix} &7NPC &acreated &7successfully");
        public static final Message<String> PLAYERNPC_COMMAND_REMOVE_SHIFT = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.REMOVE.SHIFT", String.class, ChatMessageType.ACTION_BAR, "&7Use &cshift+punch &7to remove this NPC");
        public static final Message<String> PLAYERNPC_COMMAND_REMOVE_SUCCESS = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.REMOVE.SUCCESS", String.class, ChatMessageType.CHAT, "{prefix} &7NPC &cremoved &7successfully");
        public static final Message<String> PLAYERNPC_COMMAND_SETDESTINATION_SUCCESS = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.SETDESTINATION.SUCCESS", String.class, ChatMessageType.CHAT, "{prefix} &7Destination for NPC &e{id} &7has been set as {destination}");
        public static final Message<String> PLAYERNPC_COMMAND_SETPERMISSION_SUCCESS = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.SETPERMISSION.SUCCESS", String.class, ChatMessageType.CHAT, "{prefix} &7Permission for NPC &e{id} &7has been set as {permission}");
        public static final Message<String> PLAYERNPC_COMMAND_SETGLOWINGCOLOR_SUCCESS = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.SETGLOWINGCOLOR.SUCCESS", String.class, ChatMessageType.CHAT, "{prefix} &7Glowing color for NPC &e{id} &7has been set as {color}");
        public static final Message<String> PLAYERNPC_COMMAND_SETFOLLOWGAZE_SUCCESS = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.SETFOLLOWGAZE.SUCCESS", String.class, ChatMessageType.CHAT, "{prefix} &7Follow gaze for NPC &e{id} &7has been set as {boolean}");
        public static final Message<String> PLAYERNPC_COMMAND_SETSKIN_SUCCESS = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.SETSKIN.SUCCESS", String.class, ChatMessageType.CHAT, "{prefix} &7Skin for NPC &e{id} &7has been set as &a{skin} &7of type &b{type}");
        public static final Message<String> PLAYERNPC_COMMAND_SETSKIN_TYPE = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.SETSKIN.TYPE", String.class, ChatMessageType.CHAT, "{prefix} &cUnrecognized skin type. Use Minecraft or Mineskin.");
        public static final Message<String> PLAYERNPC_COMMAND_SETSKIN_NOT_FOUND = new Message<String>("INTEGRATIONS.PLAYERNPC.COMMAND.SETSKIN.NOT_FOUND", String.class, ChatMessageType.CHAT, "{prefix} &cNo skin with that name was found.");
        public static final Message<String> CHUNKY_GENERATION_RESUME = new Message<String>("INTEGRATIONS.CHUNKY.GENERATION.RESUME", String.class, ChatMessageType.CHAT, "{prefix} &aGenerating terrain for {world}&a...");
        public static final Message<String> CHUNKY_GENERATION_PAUSE = new Message<String>("INTEGRATIONS.CHUNKY.GENERATION.PAUSE", String.class, ChatMessageType.CHAT, "{prefix} &cPaused terrain generation for {world}&c...");
        public static final Message<String> CHUNKY_PROGRESS_LOADING = new Message<String>("INTEGRATIONS.CHUNKY.PROGRESS.LOADING", String.class, "&fLoading Chunky for {world}&f...");
        public static final Message<String> CHUNKY_PROGRESS_CANCELLED = new Message<String>("INTEGRATIONS.CHUNKY.PROGRESS.CANCELLED", String.class, "&cGeneration cancelled for {world}");
        public static final Message<String> CHUNKY_PROGRESS_COMPLETE = new Message<String>("INTEGRATIONS.CHUNKY.PROGRESS.COMPLETE", String.class, "&aGeneration completed for {world}");
        public static final Message<String> CHUNKY_PROGRESS_PROCESS = new Message<String>("INTEGRATIONS.CHUNKY.PROGRESS.PROCESS", String.class, "&eGeneration progress of {world} &e(&f{progress}%&e)");
        private ChatMessageType chatMessageType;
        private Class type;
        private String code;
        private T def;

        public static Message getMessage(String code) {
            return MESSAGES.get(code);
        }

        public static Set<Map.Entry<String, Message>> getEntrySet() {
            return MESSAGES.entrySet();
        }

        public static HashMap<String, Object> getDefaults() {
            HashMap<String, Object> defaults = new HashMap<String, Object>();
            Message.getEntrySet().stream().forEach(x -> defaults.put((String)x.getKey(), ((Message)x.getValue()).getDefault()));
            return defaults;
        }

        private Message(@Nonnull String code, @Nonnull Class type, @Nullable ChatMessageType chatMessageType, @Nonnull T def) {
            Validate.notNull((Object)code);
            Validate.notNull(def);
            Validate.notNull((Object)type);
            this.chatMessageType = chatMessageType;
            this.code = code.toUpperCase();
            this.type = type;
            this.def = def;
            MESSAGES.put(code, this);
        }

        private Message(@Nonnull String code, @Nonnull Class type, @Nonnull T def) {
            this(code, type, null, def);
        }

        @Nonnull
        public String getCode() {
            return this.code;
        }

        @Nullable
        public ChatMessageType getChatMessageType() {
            List comments;
            if (this.chatMessageType != null && ServerVersion.getServerVersion().isNewerThanOrEqual(ServerVersion.VERSION_1_18_2) && (comments = ConfigManager.MESSAGES.getFileConfiguration().getInlineComments(this.code)) != null) {
                try {
                    return ChatMessageType.valueOf((String)((String)comments.get(0)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.chatMessageType;
        }

        @Nonnull
        @ColorUtils.Colored(colored=true)
        public T getValue() {
            return this.getValue(null);
        }

        @Nonnull
        public Class<T> getType() {
            return this.type;
        }

        @Nonnull
        @ColorUtils.Colored(colored=true)
        public T getValue(@Nullable Player player) {
            if (this.type.equals(String.class)) {
                return (T)handler.getMessageString(player, this.code);
            }
            if (this.type.equals(List.class)) {
                return (T)handler.getMessageList(player, this.code);
            }
            return this.def;
        }

        @Nonnull
        @ColorUtils.Colored(colored=false)
        public T getDefault() {
            return this.def;
        }

        public void sendMessage(@Nonnull CommandSender sender, Pair<String, String> ... placeholders) {
            Validate.isTrue((boolean)this.getType().equals(String.class));
            Validate.notNull((Object)sender);
            String displayMessage = (String)this.getValue(sender instanceof Player ? (Player)sender : null);
            displayMessage = MessagesManager.placeholder(displayMessage, placeholders);
            TextComponent textComponent = new TextComponent(displayMessage);
            if (sender instanceof Player) {
                Player player = (Player)sender;
                ChatMessageType chatMessageType = this.getChatMessageType();
                if (chatMessageType == null) {
                    chatMessageType = ChatMessageType.CHAT;
                }
                if (player.isOp() && chatMessageType.equals((Object)ChatMessageType.CHAT) && ConfigValue.DEBUG.get().booleanValue()) {
                    String hover = "\u00a7b\u00a7lRandomTP Message\n\u00a77Displaying message: \u00a7b" + this.getCode();
                    if (placeholders != null) {
                        for (Pair<String, String> placeholder : placeholders) {
                            hover = hover + "\n\u00a77Placeholder \u00a7a{" + (String)placeholder.getFirst() + "} \u00a77-> \u00a7e" + (String)placeholder.getSecond();
                        }
                    }
                    textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hover)}));
                }
                player.spigot().sendMessage(chatMessageType, (BaseComponent)textComponent);
            } else {
                sender.spigot().sendMessage((BaseComponent)textComponent);
            }
        }
    }
}

