/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.integration.integrations;

import dev.sergiferry.randomtp.integration.IntegrationsManager;
import dev.sergiferry.randomtp.integration.PluginIntegration;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Vault
extends PluginIntegration {
    private Economy economy;
    private EconomyManager economyManager;

    public Vault(Plugin vaultPlugin) {
        super(vaultPlugin);
    }

    @Override
    public void load() {
        RegisteredServiceProvider economy = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (economy == null) {
            Bukkit.getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a7cNo plugin is using Vault Economy API. Removing integration...");
            this.removeIntegration();
            return;
        }
        this.economy = (Economy)economy.getProvider();
        Bukkit.getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a77Using " + economy.getPlugin().getName() + " v" + economy.getPlugin().getDescription().getVersion() + " hooked into Vault Economy API");
        this.economyManager = new EconomyManager(this);
    }

    @Override
    public void unload() {
    }

    public Economy getEconomy() {
        Validate.notNull((Object)this.economy, (String)"No Economy plugin is using Vault API");
        return this.economy;
    }

    public boolean isUsingEconomy() {
        return this.economy != null;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public static class EconomyManager {
        private Vault vault;

        public EconomyManager(Vault vault) {
            this.vault = vault;
        }

        public String getBalanceFormat(Player player) {
            return this.getFormat(this.getBalance(player));
        }

        public String getFormat(double balance) {
            return this.vault.getEconomy().format(balance);
        }

        public Double getBalance(Player player) {
            return this.vault.getEconomy().getBalance((OfflinePlayer)player);
        }

        public boolean hasBalance(Player player, double balance) {
            return this.getBalance(player) >= balance;
        }

        public EconomyResponse addBalance(Player player, double balance) {
            return this.vault.getEconomy().depositPlayer((OfflinePlayer)player, balance);
        }

        public EconomyResponse withdrawBalance(Player player, double balance) {
            return this.vault.getEconomy().withdrawPlayer((OfflinePlayer)player, balance);
        }
    }
}

