/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.integration.integrations;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.utils.EnumUtils;
import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.api.events.PlayerCancelRandomTPEvent;
import dev.sergiferry.randomtp.api.events.PlayerRandomTeleportEvent;
import dev.sergiferry.randomtp.config.ConfigManager;
import dev.sergiferry.randomtp.integration.PluginIntegration;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.teleportation.TeleportationHandler;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import dev.sergiferry.randomtp.teleportation.handlers.npc.GroupRandomTPNPC;
import dev.sergiferry.randomtp.teleportation.handlers.npc.PersonalRandomTPNPC;
import dev.sergiferry.randomtp.teleportation.handlers.npc.RandomTPNPC;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerNPC
extends PluginIntegration
implements Listener {
    private static final String PATH_PREFIX = "integrations.playernpc.npcs";
    private HashMap<Integer, RandomTPNPC> randomTPNPC;

    public PlayerNPC(Plugin plugin) {
        super(plugin);
    }

    @Override
    protected void load() {
        NPCLib.PluginManager pluginManager = NPCLib.getInstance().registerPlugin((Plugin)RandomTeleportPlugin.getInstance());
        pluginManager.setTicksUntilTabListHide(Integer.valueOf(1));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RandomTeleportPlugin.getInstance());
        PersonalRandomTPNPC.OVERWORLD_SKIN = NPC.Skin.Custom.createCustomSkin((Plugin)RandomTeleportPlugin.getInstance(), (String)"Personal_Overworld", (String)"ewogICJ0aW1lc3RhbXAiIDogMTY1NTMxNDY5NDcxMSwKICAicHJvZmlsZUlkIiA6ICIzYjA1NTdlYmVmYjc0MDdmYmFmMjVhN2IyNzYwZTZlMCIsCiAgInByb2ZpbGVOYW1lIiA6ICJNcl9JY2VTcGlrZXMiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjRiMjE4MjkyZWQwNjZmZWI3OTY4N2E2MWJlMjI0YWExMDhmZWM4ZWQ0YjM3OTFkMGE4NTNiMDM0MmVkNjFjNiIKICAgIH0KICB9Cn0=", (String)"Rb7ogmpkBLDgHsJCsVNQr2gyYkB066AFQHzhnsNPa/9SkAyKZABR4Vybw0NJYV9WUJ2AAwhZc/Z/a5tSli6zDdofz4H7wTanOKXCDM4hLICjozhTLtaTpD9bWzSm3+Dg3GcqpPoZsiTgDLef/sUP0ut/EZSj9XtJstjVQJWu4f4TNWqMINi1Y81A9w92/Tmok9cRsFT3x9d8BatCX8yo/1v/wxY1gnKp7q8gExQwswUPSvVxOcIEqDKmI5XIciRac1zo7okN21BNxtPbsQ/OGFqmJCQy3tE8fv0H/ZYtLmsxdhG9fo8YNWnfAzH4lAIpRxhAYMJLhn1MvAn3gpVx5fV5s9ra9hdhJ7BQediG+Td6kard2Xj5VC01vpVP9g8RTJTl1M4KamO6Iuvc00XfKCJV/QDG/7rcjFkVMtpLLl12p+4HF43oeWlZxc+hmWIFAzdsCtKBjeQXrPgCCcGa+lx7hDAZmi89tNde8O898Hd5HE8Vkt/aefmdCtL9B9Ouq22fNf8bUVUSOlwuY+vJvQPjZPMEgrxM7mN3Fm5mJreQyLkKzyflQueVbRqhRcjRG908ZKUQ2Bpnijd85CvYi0tlPjr79Q4WOmIKk6uzJD80xr8AT4mOj3dBNAqrbJDGG8VJgNdnkNgJjXilfIXjwPqAQtBCfYTY2X7XNKaEfyg=");
        PersonalRandomTPNPC.NETHER_SKIN = NPC.Skin.Custom.createCustomSkin((Plugin)RandomTeleportPlugin.getInstance(), (String)"Personal_Nether", (String)"ewogICJ0aW1lc3RhbXAiIDogMTYyOTYyNTY0NjYxNiwKICAicHJvZmlsZUlkIiA6ICJmMTA0NzMxZjljYTU0NmI0OTkzNjM4NTlkZWY5N2NjNiIsCiAgInByb2ZpbGVOYW1lIiA6ICJ6aWFkODciLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY2Njg3Zjg4MjJmNTJmMWY4ODU0N2E5YTk1ODM4ZDg3MmM3ZWYyM2Y5NGNiZDkyMDE2NDgyYzE0Y2M2OWQwNSIKICAgIH0KICB9Cn0=", (String)"RGNEZObjreuUopyS0DrlSl7BR/wDrU0rp/lugkOfsPT8Im7ivHISYTw92GaWEEy2EF1k3ANyxbzQu0DgBMG4BCR/KJbQMn9mzfvSSzMGNEp9CsreGkjUdLX+hQYAqEsj0rW5KIkXoM+LxYvhzm+/wX+knLOGup6A02t+JSsJRcou0iCP63QfDCxKFBBjl7HQ63GKlf7g+tXzX9hOOSj+U7HYggTb8pXRR+Ld/K+O8lKaMp/slTi7ucTb/g4lbWR0eUawrc/gSIJ1IQYhzRasFv3a4XcL6HkoXJn78owD4iTz60p8gvsuGkhMI9lHsd/hfdAaOChobLU/3Qtt04GWwxvq79ie1CeM96OwkY+o4l0tFSB0RLIv7U5ntzO2a597ZnPXSeIXZfz+L2CVqDJrQVZA2v/AcSLCmhDFY4O/a8ZPgeni8a+pUmQQCzLuAt0UxieiFqybXyjTx0RoXW8o/bgMFqFIMBjQBHsevliZqQsIxzSB2m3dQShpGnQNS/M84wBxhwOHWiefPpM7yel9QaPRdi15RJg5Qow+GmtQlUuDjC4T0ZEri5dN23CNxzyPbL0WLiUZua4O+r1RGryHk1iwbU+NRgjEgD7jzi0Ks3w94RWNtT81ZEmu1YpAg4c9x/palpqu1KVmmei58GUDn7S1QzjdFBnI2sxjqrv0F4o=");
        PersonalRandomTPNPC.END_SKIN = NPC.Skin.Custom.createCustomSkin((Plugin)RandomTeleportPlugin.getInstance(), (String)"Personal_End", (String)"ewogICJ0aW1lc3RhbXAiIDogMTY3MzU4OTU2NjI0NiwKICAicHJvZmlsZUlkIiA6ICI3YmRhNDBlM2E1YjU0YzE0YWJmZGYzNGMyODY2NjQ0NiIsCiAgInByb2ZpbGVOYW1lIiA6ICJfRWdvcl9wbGF5XyIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS80MzdhY2JjOTQzZDk2OWQ3MmM5ZGIzNGQ3MTFiMWFkM2MwMjBjZGFiZmJkMjg2M2Y3MTljZTJiYjUzZTRhOWRiIgogICAgfQogIH0KfQ==", (String)"jDpbuebzpjMA3G25daW1v+SqBBTKGff0LiGJ/P8Sq9VjVRj4vLIeW39RFgJ0nOoBLAlAi0PqUDrkh8f1+D60mqc1syixtWhxKsx3Utn79PdfpLNkuIx1GIcT7TkpzWf5N/UFD4yumllvsaQ1cK8OfJLNRyM4PPJkakBi/jLo2/ZoiYLDFQMjxNuqJqQYmOYjHgB0VQEcqY6bF2eGnJqyJ6ZN6g9fSS46Uzj0bq4yAWIbQCr5/lkh8a2R9PMNkxz+2a3QZJdqqmCSh5FIFvouEuzg/J6TiGRg5bVDLupDEQ37qHpw2si16JQgvjzLnCAzyXYk25+c1qC0cQWfcI8XIapS37TMlOuOVuKpTGNgPu0eXuY781H7SoxGFYb7BXjMYqrtrVpCf5ndaQ1Ikyes0SF58Gqt13GgKDaJI5TUWNBLNwKSY9xCxGvTmrnPYlsMx7dE8KgahmxvYxxYC2M8myZoN3R6MSNiiZT9HDd2wviLMKztCIebOAYAByPA8yV9NtcXeA67TQL+XgEhVuEeg7egCGtv1iaTqS4g8L5YxLRjUeigeZTmwwW+BGD2QfVTdIFTUDGAO8euD4tUQj0AveccMC/I/5qbzSfflDOk09oXhO0IP5G2drQuH/DhcKKIW/+2vTWWS29deI9K42hwA7m4gvVPr3a1mtOURgxJQ5M=");
        GroupRandomTPNPC.OVERWORLD_SKIN = NPC.Skin.Custom.createCustomSkin((Plugin)RandomTeleportPlugin.getInstance(), (String)"Group_Overworld", (String)"ewogICJ0aW1lc3RhbXAiIDogMTY3MTc1OTU2MjkwNiwKICAicHJvZmlsZUlkIiA6ICIwNTVhOTk2NTk2M2E0YjRmOGMwMjRmMTJmNDFkMmNmMiIsCiAgInByb2ZpbGVOYW1lIiA6ICJUaGVWb3hlbGxlIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2Q2ZWU3ZmVlOGYxYjdjNTRmODdiYjk4ZjRjYThkZDgwNjNkYzZiMzZiNWQyYzNiNWM0ZTE1YWNjM2I1YjdiZTIiCiAgICB9CiAgfQp9", (String)"KVhZuOQb2OCm48t6G/UjpaZ4bbm4cUTITtUSgP5lDOwhLwRc6z8cMffGAj6j7GxSm110yi7VnzEizD3WnNHFegVuBj3bSmK8BBUT448ui2V3uYM1Xx/yEDNJC6t/bRVMRgSt6AvNpG3DDgp/mEsDN9T+OwyKgLaxNbg9BzCTJnS7Mp534lA81fTHFJHjsJwcXMKEP3E4KSCvJeQ5mnwB+AjLVGjSlsF1XnWGDasIM/spA62JeAo02ltj4KRbgUJ9HCv6UytYNruqBT0IHdZvZ3/xxksvessxthGENLjydBrbQsQENv9oIcsfNBxt7O7/K9OqoUfKksJYcgchUWInHWe9BQfOtrcczIgK/7C7GIlwa4VMQ//8ak8sNxsSeE27IBe9VpcTWOywuR1igN89fGxlf85DvB6acTULKSXEYy5N5kVebSy97lyL36M/GoPgNq9lrumEyBTCMdfzkUTtT8c0ucwiCiJWk//j8+209b9SOEMzLEf98WdSirYfrWJ8irpRKYDMfQR1clAjINJQMKTG1zIj5iCzQqB5rpgICapx9/jNeraYm/shuCjq0nncg+7N9iXALLbVj6kSPnMK9j4U23wN5E3ne7JfbiQmsZN7Cp5LTmrD8LdN6BGfVwseNHYNt7O0AGYVeNGqwukQA7PjUMsiaKP7z26zM3KRVg8=");
        GroupRandomTPNPC.NETHER_SKIN = NPC.Skin.Custom.createCustomSkin((Plugin)RandomTeleportPlugin.getInstance(), (String)"Group_Nether", (String)"eyJ0aW1lc3RhbXAiOjE1NjI5NjM2NTAzMzAsInByb2ZpbGVJZCI6IjkxZjA0ZmU5MGYzNjQzYjU4ZjIwZTMzNzVmODZkMzllIiwicHJvZmlsZU5hbWUiOiJTdG9ybVN0b3JteSIsInNpZ25hdHVyZVJlcXVpcmVkIjp0cnVlLCJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODFhOWY4OGI1NzI0ZGM2ZTcxMDM3MWQyODgzNGQ0M2ZhYTQ2ZmIzNDU4OWZkYzI2NDBmN2YzYzVkMzVhOTVmMiJ9fX0=", (String)"XmRC1wGAw9cFuCGV91MVWzIIfs+R5aCeK8ydRJ6r6PIALG0bEobuWi1R6SiZw4X5o2a7VX14CPfe+bJuc1R4XfrLaLXSuz7M9UgvXfJaAXRqXw/GjkwIahRqIgzbK5GKuSBqZT1kdmz7XW7giOvhfo/1yCX0fz8WpXRYSsrXx1jJWlDnw6ShDuxionqWs/KnEVtUFloMI05M31B4qpWL36bVAqA2sSvk6EywXZgkODPw/KizTrs/Rqem0z31UAoot78THIb/ZDr7fIRIbPplPGrloZrIpGeCOcWQlad06A3MyVxEQrmX3sGuShXealx1TX6mzPk6P8iOjcxH47QyyGyIUwNYoZo6q7OW2/Pn20YVQgI4xgMDW5I5fKoxq0rKAVCrW7J+hzYPW7Xmgkz9SjWIGS03wRIKynnu2YCBAPUpwyZYHIdUUDUe/DEYUXrKjBPYHkUcLqctW3tPsgJsVphgbCZOsnTrz+dsoAMypegHtoxHGAhxTrLo+ZRfbazvHLAR3HcB5dYjoBCELZrkAH4TwowbG8UvJ+IQ0DcUgFJM2bRMt/xV7DdNHDPwQh589W2VaKx7UhjPm252hENdd2Yt5pAU69vX0FXubIwe+OVw7qGcmr+r3NuGkvnjyHYn4/fWVey2NQ7vnVoaaUn2Oxi7eBMn7jZ7AMkkCy0ALYo=");
        GroupRandomTPNPC.END_SKIN = NPC.Skin.Custom.createCustomSkin((Plugin)RandomTeleportPlugin.getInstance(), (String)"Group_End", (String)"ewogICJ0aW1lc3RhbXAiIDogMTY1MzMxOTE4ODAxOCwKICAicHJvZmlsZUlkIiA6ICI4ZjZmYTgxOGU5NmM0OWVlOTRhMTgyNTY0MjE4ODJmZiIsCiAgInByb2ZpbGVOYW1lIiA6ICJSaXZrYXQiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODhmMWY0NzNiYmVkNjExNjJjODRjZGMzNDI2ZDc0NGJjNjYzYjI4Y2E1ZTIxMGEwNDdlNWRhZWNjMWQyMGM1MCIsCiAgICAgICJtZXRhZGF0YSIgOiB7CiAgICAgICAgIm1vZGVsIiA6ICJzbGltIgogICAgICB9CiAgICB9CiAgfQp9", (String)"k+G6DydsCk3fCXkCforYAiYCtZMqI28iC6K3RlXUNaLzKR9nCVbY532cRgRYDKJ+WdVgCvv/GtFuERnw41ihXz+GHQeyIF1duUSAmxQY7PRRXLTkDUAmBMVqfv9SzvdrlCqRKPXHfeBjupkeXdrNRZbaq/M15ANNFBEteLqbu9I52zvm3kx1M6Q4QEY9bhsV36YNLdonP3LbZoTdCQVwahF0rAKwLUdIEONdoIKiZiilggDs+XTBK8gXV9pBdOiVvLw9NfqdnOepCk7TA2pS0gWzwzOwG/VXAsYNJ/AlA+7Wbgynr9cvpnSR7BOvt0+BZmq3IpYyniHq60uSTSoHkW7Hx8HJsEZVIIGLzPaSuOL7LpUfcpdWqxIsL9/pkLLO6PfVpMJHDZAr9cPakmoq0arakNWczx+hAt9O/qsYt6ytSw3l6lnrRXrMeImUfQSX/SDj8F0s0u9TDU0x5EmuXloLMDDh7WqwKqXvg9a44+pOGs9wpa2Gc1/iSIMzerHc+uEAmge48GItiqjYEpz45+JulBfe2S31jzJeAOffLRdGJYuYXF21Xedz9QFcs2QsYV9mIvR+LOsNgrSMxDaKFewaqf4OxPSf1cJ9Zb7rrMp/TQN73OicDOWC9hvfR7R0QGzaGq3R2163jGWI214RFZL32u2fXN9lf2d47wIoVoc=");
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RandomTeleportPlugin.getInstance(), () -> this.loadNPCs(), 20L);
    }

    @Override
    protected void unload() {
        NPCLib.getInstance().unregisterPlugin((Plugin)RandomTeleportPlugin.getInstance());
    }

    public void setupNPC(Player player, Location location, RandomTPNPC.Type type, WorldOptions worldOptions) {
        NPC.Skin.Custom npcSkin;
        World world = worldOptions.getWorld();
        ChatColor glowingColor = ChatColor.DARK_GREEN;
        NPC.Skin.Custom custom = npcSkin = type.equals((Object)RandomTPNPC.Type.GROUP) ? GroupRandomTPNPC.OVERWORLD_SKIN : PersonalRandomTPNPC.OVERWORLD_SKIN;
        if (world.getEnvironment().equals((Object)World.Environment.NETHER)) {
            npcSkin = type.equals((Object)RandomTPNPC.Type.GROUP) ? GroupRandomTPNPC.NETHER_SKIN : PersonalRandomTPNPC.NETHER_SKIN;
            glowingColor = ChatColor.DARK_RED;
        } else if (world.getEnvironment().equals((Object)World.Environment.THE_END)) {
            npcSkin = type.equals((Object)RandomTPNPC.Type.GROUP) ? GroupRandomTPNPC.END_SKIN : PersonalRandomTPNPC.END_SKIN;
            glowingColor = ChatColor.DARK_PURPLE;
        }
        Integer id = this.getNewId();
        ConfigurationSection section = ConfigManager.CONFIG.getFileConfiguration().createSection("integrations.playernpc.npcs." + id);
        section.set(RandomTPNPC.Value.TYPE.getPath(), (Object)type.name().toUpperCase());
        section.set(RandomTPNPC.Value.DESTINATION.getPath(), (Object)WorldOptions.format(world));
        section.set(RandomTPNPC.Value.ALIAS.getPath(), (Object)RandomTPNPC.Value.ALIAS.getDefault());
        section.set(RandomTPNPC.Value.PERMISSION.getPath(), (Object)RandomTPNPC.Value.PERMISSION.getDefault());
        section.set(RandomTPNPC.Value.GLOWING_COLOR.getPath(), (Object)glowingColor.name());
        section.set(RandomTPNPC.Value.CANCEL_DISTANCE.getPath(), (Object)RandomTPNPC.Value.CANCEL_DISTANCE.getDefault());
        section.set(RandomTPNPC.Value.FOLLOW_GAZE.getPath(), (Object)RandomTPNPC.Value.FOLLOW_GAZE.getDefault());
        section.set(RandomTPNPC.Value.COLLIDABLE.getPath(), (Object)RandomTPNPC.Value.COLLIDABLE.getDefault());
        section.set(RandomTPNPC.Value.SKIN_VALUE.getPath(), (Object)npcSkin.getTexture());
        section.set(RandomTPNPC.Value.SKIN_SIGNATURE.getPath(), (Object)npcSkin.getSignature());
        section.set(RandomTPNPC.Value.LOCATION.getPath(), (Object)location);
        try {
            this.loadNPCs();
            MessagesManager.Message.PLAYERNPC_COMMAND_CREATE_SUCCESS.sendMessage((CommandSender)player, new Pair[0]);
        }
        catch (Exception e) {
            player.sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a7cThere was an unexpected error while creating NPC. Please contact \u00a7e@SergiFerry\u00a7c, and send the console log.");
            e.printStackTrace();
        }
    }

    public Integer getNewId() {
        int id = 1;
        while (this.randomTPNPC.get(id) != null) {
            ++id;
        }
        return id;
    }

    public void removeNPC(RandomTPNPC randomTPNPC) {
        FileConfiguration config = ConfigManager.CONFIG.getFileConfiguration();
        config.set("integrations.playernpc.npcs." + randomTPNPC.getId(), null);
        try {
            ConfigManager.CONFIG.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        randomTPNPC.remove();
        this.loadNPCs();
    }

    public void loadNPCs() {
        if (this.randomTPNPC != null) {
            this.randomTPNPC.values().forEach(x -> x.remove());
        }
        this.randomTPNPC = new HashMap();
        ConfigurationSection section = ConfigManager.CONFIG.getFileConfiguration().getConfigurationSection(PATH_PREFIX);
        if (section == null) {
            return;
        }
        for (String npcID : section.getKeys(false)) {
            try {
                Integer id = Integer.parseInt(npcID);
                ConfigurationSection npcSection = section.getConfigurationSection(npcID);
                RandomTPNPC.Type type = RandomTPNPC.Type.PERSONAL;
                if (npcSection.contains(RandomTPNPC.Value.TYPE.getPath())) {
                    type = RandomTPNPC.Type.valueOf(npcSection.getString(RandomTPNPC.Value.TYPE.getPath()).toUpperCase());
                }
                if (type.equals((Object)RandomTPNPC.Type.PERSONAL)) {
                    this.randomTPNPC.put(id, new PersonalRandomTPNPC(id, npcSection));
                    continue;
                }
                if (!type.equals((Object)RandomTPNPC.Type.GROUP)) continue;
                this.randomTPNPC.put(id, new GroupRandomTPNPC(id, npcSection));
            }
            catch (Exception e) {
                Bukkit.getConsoleSender().sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a7cThere was an error loading NPC #" + npcID + " \u00a77(" + e.getLocalizedMessage());
            }
        }
        try {
            ConfigManager.CONFIG.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (Player online : Bukkit.getOnlinePlayers()) {
            this.randomTPNPC.values().forEach(x -> x.setIdle(online));
        }
    }

    public HashMap<Integer, RandomTPNPC> getMapNPC() {
        return this.randomTPNPC;
    }

    public RandomTPNPC getNPC(Integer id) {
        return this.randomTPNPC.get(id);
    }

    public List<String> getSuggestedSkins(String type) {
        if (type.equalsIgnoreCase(NPC.Skin.Type.MINECRAFT.name())) {
            return NPC.Skin.Minecraft.getSuggestedSkinNames();
        }
        if (type.equalsIgnoreCase(NPC.Skin.Type.MINESKIN.name())) {
            return NPC.Skin.MineSkin.getSuggestedSkinNames();
        }
        if (type.equalsIgnoreCase(NPC.Skin.Type.CUSTOM.name())) {
            return NPC.Skin.Custom.getSuggestedSkinNames();
        }
        if (type.equalsIgnoreCase("url")) {
            return NPC.Skin.MineSkin.getSuggestedSkinWebsites();
        }
        if (type.equalsIgnoreCase("npc")) {
            return NPCLib.getInstance().getAllGlobalNPCs().stream().map(x -> x.getID().getFullID()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.getMapNPC() == null) {
            return;
        }
        this.getMapNPC().values().stream().filter(x -> x.getNPC().hasPlayer(player)).forEach(x -> {
            x.setIdle(player);
            x.getNPC().forceUpdate(player);
        });
    }

    @EventHandler
    public void onComplete(PlayerRandomTeleportEvent event) {
        Player player = event.getPlayer();
        if (!event.getSearchTask().getHandler().getType().equals(TeleportationHandler.Type.NPC)) {
            return;
        }
        TeleportationHandler handler = event.getSearchTask().getHandler();
        ((RandomTPNPC)handler.getValue()).setIdle(player);
    }

    @EventHandler
    public void onCancel(PlayerCancelRandomTPEvent event) {
        Player player = event.getPlayer();
        if (!event.getSearchTask().getHandler().getType().equals(TeleportationHandler.Type.NPC)) {
            return;
        }
        TeleportationHandler handler = event.getSearchTask().getHandler();
        if (!handler.isGroupTeleport()) {
            ((RandomTPNPC)handler.getValue()).setIdle(player);
        }
    }

    public void updateSkin(CommandSender commandSender, RandomTPNPC npc, String[] args) {
        this.updateSkin(commandSender, npc, args[2], args[3]);
    }

    public void updateSkin(CommandSender commandSender, RandomTPNPC npc, String type, String skinName) {
        if (type.equalsIgnoreCase(NPC.Skin.Type.MINECRAFT.name())) {
            NPC.Skin.Minecraft.fetchSkinAsync((Plugin)RandomTeleportPlugin.getInstance(), (String)skinName).thenAccept(fetchResult -> {
                if (!fetchResult.hasFound()) {
                    MessagesManager.Message.PLAYERNPC_COMMAND_SETSKIN_NOT_FOUND.sendMessage(commandSender, new Pair[0]);
                    return;
                }
                NPC.Skin.Minecraft skin = (NPC.Skin.Minecraft)fetchResult.grabSkin().get();
                npc.setSkin(skin.getTexture(), skin.getSignature());
                MessagesManager.Message.PLAYERNPC_COMMAND_SETSKIN_SUCCESS.sendMessage(commandSender, Pair.of((Object)"id", (Object)("#" + npc.getId())), Pair.of((Object)"skin", (Object)skin.getName()), Pair.of((Object)"type", (Object)skin.getType().getName(EnumUtils.NameFormat.LOWER_CASE)));
            });
            return;
        }
        if (type.equalsIgnoreCase(NPC.Skin.Type.MINESKIN.name())) {
            NPC.Skin.MineSkin.fetchSkinAsync((Plugin)RandomTeleportPlugin.getInstance(), (String)skinName).thenAccept(fetchResult -> {
                if (!fetchResult.hasFound()) {
                    MessagesManager.Message.PLAYERNPC_COMMAND_SETSKIN_NOT_FOUND.sendMessage(commandSender, new Pair[0]);
                    return;
                }
                NPC.Skin.MineSkin skin = (NPC.Skin.MineSkin)fetchResult.grabSkin().get();
                npc.setSkin(skin.getTexture(), skin.getSignature());
                MessagesManager.Message.PLAYERNPC_COMMAND_SETSKIN_SUCCESS.sendMessage(commandSender, Pair.of((Object)"id", (Object)("#" + npc.getId())), Pair.of((Object)"skin", (Object)("#" + skin.getId())), Pair.of((Object)"type", (Object)skin.getType().getName(EnumUtils.NameFormat.LOWER_CASE)));
            });
            return;
        }
        if (type.equalsIgnoreCase(NPC.Skin.Type.CUSTOM.name())) {
            NPC.Skin.Custom.fetchCustomSkinAsync((String)skinName).thenAccept(fetchResult -> {
                if (!fetchResult.hasFound()) {
                    MessagesManager.Message.PLAYERNPC_COMMAND_SETSKIN_NOT_FOUND.sendMessage(commandSender, new Pair[0]);
                    return;
                }
                NPC.Skin.Custom skin = (NPC.Skin.Custom)fetchResult.grabSkin().get();
                npc.setSkin(skin.getTexture(), skin.getSignature());
                MessagesManager.Message.PLAYERNPC_COMMAND_SETSKIN_SUCCESS.sendMessage(commandSender, Pair.of((Object)"id", (Object)("#" + npc.getId())), Pair.of((Object)"skin", (Object)skin.getFullID()), Pair.of((Object)"type", (Object)skin.getType().getName(EnumUtils.NameFormat.LOWER_CASE)));
            });
            return;
        }
        if (type.equalsIgnoreCase("url")) {
            NPC.Skin.MineSkin.generateSkinFromURLAsync((String)skinName).thenAccept(fetchResult -> {
                if (!fetchResult.hasFound()) {
                    MessagesManager.Message.PLAYERNPC_COMMAND_SETSKIN_NOT_FOUND.sendMessage(commandSender, new Pair[0]);
                    return;
                }
                NPC.Skin.MineSkin skin = (NPC.Skin.MineSkin)fetchResult.grabSkin().get();
                npc.setSkin(skin.getTexture(), skin.getSignature());
                MessagesManager.Message.PLAYERNPC_COMMAND_SETSKIN_SUCCESS.sendMessage(commandSender, Pair.of((Object)"id", (Object)("#" + npc.getId())), Pair.of((Object)"skin", (Object)("#" + skin.getId())), Pair.of((Object)"type", (Object)skin.getType().getName(EnumUtils.NameFormat.LOWER_CASE)));
            });
            return;
        }
        if (type.equalsIgnoreCase("npc")) {
            if (!NPCLib.Registry.ID.isFullValid((String)skinName) || !NPCLib.getInstance().hasGlobalNPC(skinName)) {
                MessagesManager.Message.PLAYERNPC_COMMAND_SETSKIN_NOT_FOUND.sendMessage(commandSender, new Pair[0]);
                return;
            }
            NPC.Global global = NPCLib.getInstance().getGlobalNPC(skinName);
            npc.setSkin(global.getSkin().getTexture(), global.getSkin().getSignature());
            MessagesManager.Message.PLAYERNPC_COMMAND_SETSKIN_SUCCESS.sendMessage(commandSender, Pair.of((Object)"id", (Object)("#" + npc.getId())), Pair.of((Object)"skin", (Object)global.getSkin().getName()), Pair.of((Object)"type", (Object)global.getSkin().getType().getName(EnumUtils.NameFormat.LOWER_CASE)));
            return;
        }
        MessagesManager.Message.PLAYERNPC_COMMAND_SETSKIN_TYPE.sendMessage(commandSender, new Pair[0]);
    }
}

