/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.integration.integrations;

import dev.sergiferry.randomtp.config.ConfigValue;
import dev.sergiferry.randomtp.integration.IntegrationsManager;
import dev.sergiferry.randomtp.integration.PluginIntegration;
import dev.sergiferry.randomtp.player.PlayerManager;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import dev.sergiferry.randomtp.utils.ColorUtils;
import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Relational;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPI
extends PluginIntegration {
    private Extension extension = new Extension((Plugin)IntegrationsManager.getPlugin());

    public PlaceholderAPI(Plugin plugin) {
        super(plugin);
    }

    @Override
    public void load() {
        this.extension.register();
    }

    @Override
    public void unload() {
        this.extension.unregister();
    }

    public String replace(Player player, String text) {
        return me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((Player)player, (String)text);
    }

    public List<String> replace(Player player, List<String> text) {
        return me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((Player)player, text);
    }

    public String replace(OfflinePlayer player, String text) {
        return me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)text);
    }

    public List<String> replace(OfflinePlayer player, List<String> text) {
        return me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((OfflinePlayer)player, text);
    }

    public static class Extension
    extends PlaceholderExpansion
    implements Relational {
        private Plugin plugin;

        public Extension(Plugin plugin) {
            this.plugin = plugin;
        }

        @NotNull
        public String getIdentifier() {
            String string = this.plugin.getName().toLowerCase();
            if (string == null) {
                Extension.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getAuthor() {
            String string = (String)this.plugin.getDescription().getAuthors().get(0);
            if (string == null) {
                Extension.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getVersion() {
            String string = this.plugin.getDescription().getVersion();
            if (string == null) {
                Extension.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean persist() {
            return true;
        }

        public boolean canRegister() {
            return true;
        }

        public String onPlaceholderRequest(Player player, @NotNull String identifier) {
            if (identifier == null) {
                Extension.$$$reportNull$$$0(3);
            }
            if ((identifier = identifier.toLowerCase()).equals("author")) {
                return this.getAuthor();
            }
            if (identifier.equals("version")) {
                return this.getVersion();
            }
            if (identifier.equals("command_label")) {
                return ConfigValue.COMMAND_LABEL.get();
            }
            if (identifier.equals("cooldown") || identifier.equals("cooldown_short")) {
                Integer seconds = PlayerManager.getCooldown(player);
                if (seconds <= 0) {
                    return "\u00a7aReady";
                }
                return "\u00a7c" + seconds + " s";
            }
            if (identifier.equals("cooldown_long")) {
                Integer seconds = PlayerManager.getCooldown(player);
                if (seconds <= 0) {
                    return "\u00a7aReady";
                }
                return "\u00a7c" + seconds + " seconds";
            }
            if (identifier.startsWith("world_format_")) {
                String worldName = identifier.replaceFirst("world_format_", "");
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    return null;
                }
                return WorldOptions.format(world);
            }
            if (identifier.startsWith("world_alias_")) {
                WorldOptions worldOptions;
                String worldName = identifier.replaceFirst("world_alias_", "");
                World world = Bukkit.getWorld((String)worldName);
                String unknown = "\u00a7cUnknown";
                if (world != null) {
                    worldOptions = WorldOptions.of(world);
                } else {
                    worldOptions = WorldOptions.of(worldName);
                    if (worldOptions == null) {
                        return unknown;
                    }
                }
                return worldOptions != null ? ColorUtils.color(worldOptions.getAlias()) : unknown;
            }
            return null;
        }

        public String onPlaceholderRequest(Player playerOne, Player playerTwo, String identifier) {
            return this.onPlaceholderRequest(playerOne, identifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dev/sergiferry/randomtp/integration/integrations/PlaceholderAPI$Extension";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIdentifier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersion";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "dev/sergiferry/randomtp/integration/integrations/PlaceholderAPI$Extension";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onPlaceholderRequest";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

