/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.integration.integrations;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.randomtp.integration.PluginIntegration;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import dev.sergiferry.randomtp.utils.ColorUtils;
import dev.sergiferry.randomtp.utils.MathUtils;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.chunky.ChunkyProvider;
import org.popcraft.chunky.api.ChunkyAPI;

public class Chunky
extends PluginIntegration {
    private Set<World> cancelled;
    private ChunkyAPI chunkyAPI;

    public Chunky(Plugin plugin) {
        super(plugin);
    }

    @Override
    protected void load() {
        this.cancelled = new HashSet<World>();
        this.chunkyAPI = ChunkyProvider.get().getApi();
        this.chunkyAPI.onGenerationProgress(event -> {
            World world = Bukkit.getWorld((String)event.world());
            if (world == null) {
                return;
            }
            WorldOptions worldOptions = WorldOptions.of(world);
            if (worldOptions == null) {
                return;
            }
            BossBar bossBar = this.getBossBar(worldOptions);
            bossBar.setProgress((double)(event.progress() / 100.0f));
            bossBar.setTitle(MessagesManager.Message.CHUNKY_PROGRESS_PROCESS.getValue().replaceAll("\\{world}", ColorUtils.color(worldOptions.getAlias())).replaceAll("\\{progress}", MathUtils.getFormat(event.progress())));
            bossBar.setColor(BarColor.YELLOW);
        });
        this.chunkyAPI.onGenerationComplete(event -> {
            World world = Bukkit.getWorld((String)event.world());
            if (world == null) {
                return;
            }
            if (this.cancelled.contains(world)) {
                return;
            }
            WorldOptions worldOptions = WorldOptions.of(world);
            if (worldOptions == null) {
                return;
            }
            BossBar bossBar = this.getBossBar(worldOptions);
            bossBar.setProgress(1.0);
            bossBar.setTitle(MessagesManager.Message.CHUNKY_PROGRESS_COMPLETE.getValue().replaceAll("\\{world}", ColorUtils.color(worldOptions.getAlias())));
            bossBar.setColor(BarColor.GREEN);
            NamespacedKey namespacedKey = this.getNamespacedKey(world);
            Bukkit.getScheduler().runTaskLater(this.getPlugin(), () -> {
                if (bossBar.getColor().equals((Object)BarColor.GREEN)) {
                    bossBar.removeAll();
                    Bukkit.removeBossBar((NamespacedKey)namespacedKey);
                }
            }, 60L);
        });
    }

    @Override
    protected void unload() {
        for (World world : Bukkit.getWorlds()) {
            NamespacedKey namespacedKey = this.getNamespacedKey(world);
            KeyedBossBar result = Bukkit.getBossBar((NamespacedKey)namespacedKey);
            if (result == null) continue;
            result.removeAll();
            Bukkit.removeBossBar((NamespacedKey)namespacedKey);
        }
    }

    public void command(CommandSender sender, WorldOptions worldOptions) {
        BossBar bossBar = this.getBossBar(worldOptions);
        if (this.stopGenerate(worldOptions)) {
            if (!this.cancelled.contains(worldOptions.getWorld())) {
                this.cancelled.add(worldOptions.getWorld());
            }
            MessagesManager.Message.CHUNKY_GENERATION_PAUSE.sendMessage(sender, Pair.of((Object)"world", (Object)ColorUtils.color(worldOptions.getAlias())));
            bossBar.setColor(BarColor.RED);
            bossBar.setTitle(MessagesManager.Message.CHUNKY_PROGRESS_CANCELLED.getValue().replaceAll("\\{world}", ColorUtils.color(worldOptions.getAlias())));
            NamespacedKey namespacedKey = this.getNamespacedKey(worldOptions.getWorld());
            Bukkit.getScheduler().runTaskLater(this.getPlugin(), () -> {
                if (bossBar.getColor().equals((Object)BarColor.RED)) {
                    bossBar.removeAll();
                    Bukkit.removeBossBar((NamespacedKey)namespacedKey);
                }
            }, 60L);
            return;
        }
        this.startGenerate(worldOptions);
        MessagesManager.Message.CHUNKY_GENERATION_RESUME.sendMessage(sender, Pair.of((Object)"world", (Object)ColorUtils.color(worldOptions.getAlias())));
        if (sender instanceof Player) {
            bossBar.addPlayer((Player)sender);
        }
    }

    public boolean startGenerate(WorldOptions worldOptions) {
        boolean before;
        if (this.cancelled.contains(worldOptions.getWorld())) {
            this.cancelled.remove(worldOptions.getWorld());
        }
        if (before = this.chunkyAPI.continueTask(worldOptions.getWorld().getName())) {
            return false;
        }
        double centerX = (worldOptions.getMaxX() + worldOptions.getMinX()) / 2;
        double centerZ = (worldOptions.getMaxZ() + worldOptions.getMinZ()) / 2;
        double radiusX = (double)worldOptions.getMaxX() - centerX;
        double radiusZ = (double)worldOptions.getMaxZ() - centerZ;
        return this.chunkyAPI.startTask(worldOptions.getWorld().getName(), "square", centerX, centerZ, radiusX, radiusZ, "spiral");
    }

    public BossBar getBossBar(WorldOptions worldOptions) {
        NamespacedKey namespacedKey = this.getNamespacedKey(worldOptions.getWorld());
        KeyedBossBar result = Bukkit.getBossBar((NamespacedKey)namespacedKey);
        if (result != null) {
            return result;
        }
        return Bukkit.createBossBar((NamespacedKey)namespacedKey, (String)MessagesManager.Message.CHUNKY_PROGRESS_LOADING.getValue().replaceAll("\\{world}", ColorUtils.color(worldOptions.getAlias())), (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
    }

    public NamespacedKey getNamespacedKey(World world) {
        return new NamespacedKey(this.getPlugin(), "progress_" + world.getName());
    }

    public boolean stopGenerate(WorldOptions worldOptions) {
        return this.chunkyAPI.pauseTask(worldOptions.getWorld().getName());
    }

    public ChunkyAPI getChunkyAPI() {
        return this.chunkyAPI;
    }
}

