/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.integration;

import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.config.ConfigValue;
import dev.sergiferry.randomtp.integration.PluginIntegration;
import dev.sergiferry.randomtp.integration.integrations.Chunky;
import dev.sergiferry.randomtp.integration.integrations.LanguagesAPI;
import dev.sergiferry.randomtp.integration.integrations.PlaceholderAPI;
import dev.sergiferry.randomtp.integration.integrations.PlayerNPC;
import dev.sergiferry.randomtp.integration.integrations.Vault;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class IntegrationsManager {
    public static final String PLAYERNPC_OLDER_VERSION = "2023.4";
    public static final String PLAYERNPC_SPIGOT_LINK = "https://www.spigotmc.org/resources/playernpc.93625/";
    public static final String LANGUAGESAPI_OLDER_VERSION = "2023.1";
    public static final String LANGUAGESAPI_SPIGOT_LINK = "https://www.spigotmc.org/resources/languagesapi.93625/";
    public static final String VAULT_SPIGOT_LINK = "https://www.spigotmc.org/resources/vault.34315/";
    public static final String PLACEHOLDERAPI_SPIGOT_LINK = "https://www.spigotmc.org/resources/placeholderapi.6245/";
    public static final String CHUNKY_SPIGOT_LINK = "https://www.spigotmc.org/resources/chunky.81534/";
    public static final String XGUI_SPIGOT_LINK = "https://www.spigotmc.org/resources/xgui.105847/";
    private static List<PluginIntegration> hookedPlugins;
    private static PlaceholderAPI placeholderAPI;
    private static LanguagesAPI languagesAPI;
    private static PlayerNPC playerNPC;
    private static Chunky chunky;
    private static Vault vault;

    public static void onEnable() {
        IntegrationsManager.check();
        IntegrationsManager.load();
    }

    public static void onDisable() {
        IntegrationsManager.unload();
    }

    private static void check() {
        hookedPlugins = new ArrayList<PluginIntegration>();
        IntegrationsManager.getPlugin().getServer().getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a77Looking for soft dependencies...");
        IntegrationsManager.checkChunky();
        IntegrationsManager.checkVault();
        IntegrationsManager.checkPlaceHolderAPI();
        IntegrationsManager.checkPlayerNPC();
        if (hookedPlugins.isEmpty()) {
            IntegrationsManager.getPlugin().getServer().getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a77No soft dependencies were found.");
        }
    }

    private static void load() {
        hookedPlugins.forEach(x -> x.load());
    }

    private static void unload() {
        hookedPlugins.forEach(x -> x.unload());
        placeholderAPI = null;
        languagesAPI = null;
        playerNPC = null;
        chunky = null;
        vault = null;
    }

    private static void checkVault() {
        if (!ConfigValue.INTEGRATIONS_VAULT_ENABLED.get().booleanValue()) {
            return;
        }
        Plugin vaultPlugin = IntegrationsManager.getPlugin().getServer().getPluginManager().getPlugin("Vault");
        if (vaultPlugin == null || !vaultPlugin.isEnabled()) {
            return;
        }
        vault = new Vault(vaultPlugin);
    }

    private static void checkChunky() {
        Plugin chunkyPlugin = IntegrationsManager.getPlugin().getServer().getPluginManager().getPlugin("Chunky");
        if (chunkyPlugin == null || !chunkyPlugin.isEnabled()) {
            return;
        }
        chunky = new Chunky(chunkyPlugin);
    }

    private static void checkPlayerNPC() {
        Plugin playerNPCPlugin = IntegrationsManager.getPlugin().getServer().getPluginManager().getPlugin("PlayerNPC");
        if (playerNPCPlugin == null || !playerNPCPlugin.isEnabled()) {
            return;
        }
        String version = playerNPCPlugin.getDescription().getVersion();
        if (RandomTeleportPlugin.getInstance().isHigherVersion(version, PLAYERNPC_OLDER_VERSION, true) < 0) {
            Bukkit.getConsoleSender().sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a7cYou are running an unsupported version of PlayerNPC plugin. Please update it at");
            Bukkit.getConsoleSender().sendMessage("\u00a7ehttps://www.spigotmc.org/resources/playernpc.93625/");
            return;
        }
        playerNPC = new PlayerNPC(playerNPCPlugin);
    }

    private static void checkLanguagesAPI() {
        Plugin languagesPlugin = IntegrationsManager.getPlugin().getServer().getPluginManager().getPlugin("LanguagesAPI");
        if (languagesPlugin == null || !languagesPlugin.isEnabled()) {
            return;
        }
        String version = languagesPlugin.getDescription().getVersion();
        if (RandomTeleportPlugin.getInstance().isHigherVersion(version, LANGUAGESAPI_OLDER_VERSION, true) < 0) {
            Bukkit.getConsoleSender().sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a7cYou are running an unsupported version of LanguagesAPI plugin. Please update it at");
            Bukkit.getConsoleSender().sendMessage("\u00a7ehttps://www.spigotmc.org/resources/languagesapi.93625/");
            return;
        }
        languagesAPI = new LanguagesAPI(languagesPlugin);
    }

    private static void checkPlaceHolderAPI() {
        Plugin placeholderAPIPlugin = IntegrationsManager.getPlugin().getServer().getPluginManager().getPlugin("PlaceholderAPI");
        if (placeholderAPIPlugin == null || !placeholderAPIPlugin.isEnabled()) {
            return;
        }
        placeholderAPI = new PlaceholderAPI(placeholderAPIPlugin);
    }

    public static PlaceholderAPI getPlaceholderAPI() {
        return placeholderAPI;
    }

    public static Vault getVault() {
        return vault;
    }

    public static Chunky getChunky() {
        return chunky;
    }

    public static PlayerNPC getPlayerNPC() {
        return playerNPC;
    }

    public static LanguagesAPI getLanguagesAPI() {
        return languagesAPI;
    }

    public static boolean isUsingVault() {
        return vault != null;
    }

    public static boolean isUsingPlaceholderAPI() {
        return placeholderAPI != null;
    }

    public static boolean isUsingPlayerNPC() {
        return playerNPC != null;
    }

    public static boolean isUsingLanguagesAPI() {
        return languagesAPI != null;
    }

    public static boolean isUsingChunky() {
        return chunky != null;
    }

    public static RandomTeleportPlugin getPlugin() {
        return RandomTeleportPlugin.getInstance();
    }

    protected static void addHookedPlugin(PluginIntegration pluginIntegration) {
        hookedPlugins.add(pluginIntegration);
        IntegrationsManager.getPlugin().getServer().getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a77Hooked into \u00a7a" + pluginIntegration.getPlugin().getName() + " \u00a77v" + pluginIntegration.getPlugin().getDescription().getVersion() + ".");
    }

    protected static void removeHookedPlugin(PluginIntegration pluginIntegration) {
        if (!hookedPlugins.contains(pluginIntegration)) {
            return;
        }
        hookedPlugins.remove(pluginIntegration);
        IntegrationsManager.getPlugin().getServer().getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a77Removed integration from \u00a7c" + pluginIntegration.getPlugin().getName());
    }

    public static List<PluginIntegration> getHookedPlugins() {
        return hookedPlugins;
    }
}

