/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.config;

import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public abstract class PathValue<T> {
    private String path;
    private Class<T> type;

    public PathValue(String path, Class<T> type) {
        Validate.notNull((Object)path);
        Validate.notNull(type);
        this.path = path;
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T get(ConfigurationSection section) {
        return (T)section.getObject(this.path, this.type);
    }

    public T get(ConfigurationSection section, T def) {
        return (T)section.getObject(this.path, this.type, def);
    }

    public T get(FileConfiguration configuration, String route) {
        return (T)configuration.getObject(route + "." + this.path, this.type);
    }

    public T get(FileConfiguration configuration, String route, T def) {
        return (T)configuration.getObject(route + "." + this.path, this.type, def);
    }

    public void set(FileConfiguration configuration, String route, T value) {
        configuration.set(route + "." + this.path, value);
    }

    public void set(ConfigurationSection section, T value) {
        section.set(this.path, value);
    }
}

