/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.config;

import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.config.ConfigManager;
import dev.sergiferry.randomtp.config.ConfigValue;
import dev.sergiferry.randomtp.config.PathValue;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import dev.sergiferry.randomtp.teleportation.handlers.npc.RandomTPNPC;
import dev.sergiferry.randomtp.utils.Array;
import dev.sergiferry.randomtp.utils.LocationUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LegacyConfig {
    public static void checkLegacy() {
        ConfigurationSection dependenciesSection;
        ConfigurationSection worldsSection;
        File file = ConfigManager.CONFIG.getFile();
        if (!file.exists()) {
            return;
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        String initial = configuration.saveToString();
        Value.AUTO_UPDATE.check((ConfigurationSection)configuration);
        Value.TELEPORT_TIMER_COOLDOWN.check((ConfigurationSection)configuration);
        Value.TELEPORT_TIMER_MAX_SEARCH.check((ConfigurationSection)configuration);
        Value.TELEPORT_TIMER_INVINCIBLE.check((ConfigurationSection)configuration);
        Value.COMMAND_LABEL.check((ConfigurationSection)configuration);
        Value.COMMAND_TO_OTHER_WORLDS.check((ConfigurationSection)configuration);
        List<String> preventBlocks = null;
        if (Value.WORLD_PREVENT_BLOCKS.contains((ConfigurationSection)configuration)) {
            preventBlocks = Value.WORLD_PREVENT_BLOCKS.getAndDelete((ConfigurationSection)configuration);
        }
        if ((worldsSection = configuration.getConfigurationSection("worlds")) != null) {
            for (Object worldName : worldsSection.getKeys(false)) {
                ConfigurationSection worldSection = worldsSection.getConfigurationSection((String)worldName);
                if (Value.WORLD_COMMAND_ENABLED.contains(worldSection)) {
                    worldSection.set(Value.WORLD_COMMAND_ENABLED.getNewPath(), (Object)(Value.WORLD_COMMAND_ENABLED.getAndDelete(worldSection) == false ? 1 : 0));
                }
                Value.WORLD_COMMAND_DESTINATION.check(worldSection);
                Value.WORLD_COORDINATES_MAX_X.check(worldSection);
                Value.WORLD_COORDINATES_MAX_Z.check(worldSection);
                Value.WORLD_COORDINATES_MIN_X.check(worldSection);
                Value.WORLD_COORDINATES_MIN_Z.check(worldSection);
                Value.WORLD_REQUIREMENTS_MONEY_AMOUNT.check(worldSection);
                Value.WORLD_PREVENT_PROTECTED_REGIONS.check(worldSection);
                if (preventBlocks == null) continue;
                worldSection.set(Value.WORLD_PREVENT_BLOCKS.getNewPath(), preventBlocks);
            }
        }
        HashMap<MessagesManager.Message, Object> messages = new HashMap<MessagesManager.Message, Object>();
        for (LegacyMessage legacyMessage : LegacyMessage.MESSAGES) {
            if (!configuration.contains(legacyMessage.getOldPath())) continue;
            messages.put(legacyMessage.getMessage(), configuration.get(legacyMessage.getOldPath()));
            configuration.set(legacyMessage.getOldPath(), null);
        }
        if (configuration.contains("sign-line")) {
            ConfigurationSection signLine = configuration.getConfigurationSection("sign-line");
            ArrayList<String> signLines = new ArrayList<String>();
            for (int i = 1; i <= 4; ++i) {
                if (!signLine.contains("" + i)) {
                    signLines.add("");
                    continue;
                }
                signLines.add(signLine.getString("" + i));
            }
            messages.put(MessagesManager.Message.SIGN_TEXT_IDLE, signLines);
            configuration.set("sign-line", null);
        }
        if (!messages.isEmpty()) {
            File mfile = ConfigManager.MESSAGES.getFile();
            if (!mfile.exists()) {
                try {
                    mfile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            YamlConfiguration mconfiguration = YamlConfiguration.loadConfiguration((File)mfile);
            messages.forEach((arg_0, arg_1) -> LegacyConfig.lambda$checkLegacy$0((FileConfiguration)mconfiguration, arg_0, arg_1));
            Bukkit.getConsoleSender().sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a7eDetected legacy messages values...");
            try {
                mconfiguration.save(mfile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Bukkit.getConsoleSender().sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a77Updated messages file.");
        }
        if ((dependenciesSection = configuration.getConfigurationSection("dependencies")) != null) {
            ConfigurationSection vaultSection;
            ConfigurationSection playerNPCSection = dependenciesSection.getConfigurationSection("playernpc");
            if (playerNPCSection != null) {
                if (playerNPCSection.contains("enabled")) {
                    playerNPCSection.set("enabled", null);
                }
                String glowingColorName = Value.NPC_GLOWING_COLOR.contains(playerNPCSection) ? Value.NPC_GLOWING_COLOR.get(playerNPCSection) : null;
                ConfigurationSection npcsSection = playerNPCSection.getConfigurationSection("npcs");
                if (npcsSection != null) {
                    for (String npcID : npcsSection.getKeys(false)) {
                        ConfigurationSection npcSection = npcsSection.getConfigurationSection(npcID);
                        Value.NPC_DESTINATION.check(npcSection);
                        if (npcSection.isString("location")) {
                            npcSection.set(RandomTPNPC.Value.LOCATION.getPath(), (Object)LocationUtils.serialize(npcSection.getString("location")));
                        }
                        if (npcSection.contains(Value.NPC_GLOWING_COLOR.newPath) || glowingColorName == null) continue;
                        npcSection.set(Value.NPC_GLOWING_COLOR.newPath, (Object)glowingColorName);
                    }
                }
                if (playerNPCSection.contains("glowing-color")) {
                    playerNPCSection.set("glowing-color", null);
                }
            }
            if ((vaultSection = dependenciesSection.getConfigurationSection("vault")) != null && vaultSection.isConfigurationSection("messages")) {
                vaultSection.set("messages", null);
            }
            ConfigurationSection integrationsSection = configuration.isConfigurationSection("integrations") ? configuration.getConfigurationSection("integrations") : configuration.createSection("integrations");
            for (String keys : dependenciesSection.getKeys(true)) {
                if (dependenciesSection.isConfigurationSection(keys)) continue;
                Object value = dependenciesSection.get(keys);
                dependenciesSection.set(keys, null);
                if (integrationsSection.contains(keys) && integrationsSection.get(keys).getClass().isInstance(value)) continue;
                integrationsSection.set(keys, value);
            }
        }
        List<String> emptyConfigSections = Arrays.asList("messages", "dependencies");
        for (String section : emptyConfigSections) {
            if (!configuration.contains(section)) continue;
            configuration.set(section, null);
        }
        if (!configuration.saveToString().equals(initial)) {
            Bukkit.getConsoleSender().sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a7eDetected legacy configuration values...");
            try {
                configuration.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Bukkit.getConsoleSender().sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a77Updated configuration file.");
        }
    }

    private static /* synthetic */ void lambda$checkLegacy$0(FileConfiguration mconfiguration, MessagesManager.Message x, Object y) {
        mconfiguration.set(x.getCode(), y);
    }

    public static class Value<T> {
        public static final Value<Boolean> AUTO_UPDATE = new Value("autoUpdate", ConfigValue.AUTO_UPDATE, Boolean.class);
        public static final Value<Integer> TELEPORT_TIMER_COOLDOWN = new Value("cooldown-sec", ConfigValue.TELEPORT_TIMER_COOLDOWN, Integer.class);
        public static final Value<Integer> TELEPORT_TIMER_MAX_SEARCH = new Value("max-search-sec", ConfigValue.TELEPORT_TIMER_MAX_SEARCH, Integer.class);
        public static final Value<Integer> TELEPORT_TIMER_INVINCIBLE = new Value("invincible-seconds", ConfigValue.TELEPORT_TIMER_INVINCIBLE, Integer.class);
        public static final Value<String> COMMAND_LABEL = new Value("command", ConfigValue.COMMAND_LABEL, String.class);
        public static final Value<Boolean> COMMAND_TO_OTHER_WORLDS = new Value("command-all-worlds", ConfigValue.COMMAND_TO_OTHER_WORLDS, Boolean.class);
        public static final Value<Boolean> WORLD_COMMAND_ENABLED = new Value("disable-command", WorldOptions.Value.COMMAND_ENABLED, Boolean.class);
        public static final Value<String> WORLD_COMMAND_DESTINATION = new Value("world-command", WorldOptions.Value.COMMAND_DESTINATION, String.class);
        public static final Value<Integer> WORLD_COORDINATES_MAX_X = new Value(Array.of("max-x", "max.x"), WorldOptions.Value.COORDINATES_MAX_X, Integer.class);
        public static final Value<Integer> WORLD_COORDINATES_MAX_Z = new Value(Array.of("max-z", "max.z"), WorldOptions.Value.COORDINATES_MAX_Z, Integer.class);
        public static final Value<Integer> WORLD_COORDINATES_MIN_X = new Value(Array.of("min-x", "min.x"), WorldOptions.Value.COORDINATES_MIN_X, Integer.class);
        public static final Value<Integer> WORLD_COORDINATES_MIN_Z = new Value(Array.of("min-z", "min.z"), WorldOptions.Value.COORDINATES_MIN_Z, Integer.class);
        public static final Value<Double> WORLD_REQUIREMENTS_MONEY_AMOUNT = new Value("price", WorldOptions.Value.REQUIREMENTS_MONEY_AMOUNT, Double.class);
        public static final Value<Boolean> WORLD_PREVENT_PROTECTED_REGIONS = new Value("prevent-regions", WorldOptions.Value.PREVENT_PROTECTED_REGIONS, Boolean.class);
        public static final Value<List<String>> WORLD_PREVENT_BLOCKS = new Value("avoid-blocks", WorldOptions.Value.PREVENT_BLOCKS, List.class);
        public static final Value<String> NPC_DESTINATION = new Value("world", RandomTPNPC.Value.DESTINATION, String.class);
        public static final Value<String> NPC_GLOWING_COLOR = new Value("glowing-color.searching", RandomTPNPC.Value.GLOWING_COLOR, String.class);
        private String[] oldPath;
        private String newPath;
        private Class type;

        private Value(String[] oldPath, String newPath, Class type) {
            this.oldPath = oldPath;
            this.newPath = newPath;
            this.type = type;
        }

        private Value(String oldPath, String newPath, Class type) {
            this(new String[]{oldPath}, newPath, type);
        }

        private Value(String[] oldPath, PathValue value, Class type) {
            this(oldPath, value.getPath(), type);
        }

        private Value(String oldPath, PathValue value, Class type) {
            this(oldPath, value.getPath(), type);
        }

        public T get(ConfigurationSection section) {
            for (String oldPath : this.oldPath) {
                T value = this.get(section, oldPath);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        private T get(ConfigurationSection section, String oldPath) {
            if (!section.contains(oldPath)) {
                return null;
            }
            Object object = section.get(oldPath);
            if (!this.type.isInstance(object)) {
                return null;
            }
            return (T)object;
        }

        public void check(ConfigurationSection section) {
            for (String oldPath : this.oldPath) {
                T value = this.getAndDelete(section, oldPath);
                if (value == null || section.contains(this.newPath) && this.type.isInstance(section.get(this.newPath))) continue;
                section.set(this.newPath, value);
            }
        }

        private T getAndDelete(ConfigurationSection section, String oldPath) {
            if (!section.contains(oldPath)) {
                return null;
            }
            Object object = section.get(oldPath);
            if (!this.type.isInstance(object)) {
                return null;
            }
            section.set(oldPath, null);
            return (T)object;
        }

        public T getAndDelete(ConfigurationSection section) {
            for (String oldPath : this.oldPath) {
                T value = this.getAndDelete(section, oldPath);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        public boolean contains(ConfigurationSection section) {
            for (String oldPath : this.oldPath) {
                if (!section.contains(oldPath) || !this.type.isInstance(section.get(oldPath))) continue;
                return true;
            }
            return false;
        }

        public String[] getOldPaths() {
            return this.oldPath;
        }

        public String getNewPath() {
            return this.newPath;
        }

        public Class getType() {
            return this.type;
        }
    }

    public static class LegacyMessage {
        private static final List<LegacyMessage> MESSAGES = new ArrayList<LegacyMessage>();
        public static final LegacyMessage MESSAGES_PERMISSIONS = new LegacyMessage("messages.permissions", MessagesManager.Message.NO_PERMISSIONS);
        public static final LegacyMessage MESSAGES_PREFIX = new LegacyMessage("messages.prefix", MessagesManager.Message.PREFIX);
        public static final LegacyMessage MESSAGES_SIGN_PERMISSIONS = new LegacyMessage("messages.sign.permissions", MessagesManager.Message.SIGN_CREATE_NO_PERMISSIONS);
        public static final LegacyMessage MESSAGES_SIGN_CREATE = new LegacyMessage("messages.sign.create", MessagesManager.Message.SIGN_CREATE_SUCCESS);
        public static final LegacyMessage MESSAGES_SIGN_SHIFT = new LegacyMessage("messages.sign.shift", MessagesManager.Message.SIGN_REMOVE_SHIFT);
        public static final LegacyMessage MESSAGES_WORLD_DISABLED_COMMAND = new LegacyMessage("messages.world.disabled-command", MessagesManager.Message.WORLD_DISABLED_COMMAND);
        public static final LegacyMessage MESSAGES_WORLD_NO_EXIST = new LegacyMessage("messages.world.no-exist", MessagesManager.Message.WORLD_NO_EXIST);
        public static final LegacyMessage MESSAGES_TELEPORT_FOUND = new LegacyMessage("messages.teleport.found", MessagesManager.Message.TELEPORT_FOUND);
        public static final LegacyMessage MESSAGES_TELEPORT_WANT_CANCEL = new LegacyMessage("messages.teleport.want-cancel", MessagesManager.Message.TELEPORT_WANT_CANCEL_COMMAND);
        public static final LegacyMessage MESSAGES_TELEPORT_WANT_CANCEL_NPC = new LegacyMessage("messages.teleport.want-cancel-npc", MessagesManager.Message.TELEPORT_WANT_CANCEL_NPC_PERSONAL);
        public static final LegacyMessage MESSAGES_TELEPORT_ALREADY = new LegacyMessage("messages.teleport.already", MessagesManager.Message.TELEPORT_ALREADY);
        public static final LegacyMessage MESSAGES_TELEPORT_STARTED = new LegacyMessage("messages.teleport.started", MessagesManager.Message.TELEPORT_STARTED);
        public static final LegacyMessage MESSAGES_TELEPORT_SEARCHING = new LegacyMessage("messages.teleport.searching", MessagesManager.Message.TELEPORT_SEARCHING);
        public static final LegacyMessage MESSAGES_TELEPORT_COMPLETE = new LegacyMessage("messages.teleport.complete", MessagesManager.Message.TELEPORT_COMPLETE);
        public static final LegacyMessage MESSAGES_TELEPORT_CANCELED = new LegacyMessage("messages.teleport.canceled", MessagesManager.Message.TELEPORT_CANCELLED);
        public static final LegacyMessage MESSAGES_COOLDOWN_ALREADY = new LegacyMessage("messages.cooldown.already", MessagesManager.Message.COOLDOWN_ALREADY);
        public static final LegacyMessage MESSAGES_COOLDOWN_FINISH = new LegacyMessage("messages.cooldown.finish", MessagesManager.Message.COOLDOWN_FINISH);
        public static final LegacyMessage DEPENDENCIES_VAULT_MESSAGES_NO_BALANCE = new LegacyMessage("dependencies.vault.messages.no-balance", MessagesManager.Message.VAULT_NO_BALANCE);
        public static final LegacyMessage DEPENDENCIES_VAULT_MESSAGES_SUCCESSFULLY = new LegacyMessage("dependencies.vault.messages.successfully", MessagesManager.Message.VAULT_SUCCESS);
        public static final LegacyMessage DEPENDENCIES_VAULT_MESSAGES_ERROR = new LegacyMessage("dependencies.vault.messages.error", MessagesManager.Message.VAULT_ERROR);
        public static final LegacyMessage DEPENDENCIES_PLAYERNPC_TEXT_SEARCH = new LegacyMessage("dependencies.playernpc.text.search", MessagesManager.Message.PLAYERNPC_TEXT_PERSONAL_IDLE);
        public static final LegacyMessage DEPENDENCIES_PLAYERNPC_TEXT_SEARCHING = new LegacyMessage("dependencies.playernpc.text.searching", MessagesManager.Message.PLAYERNPC_TEXT_PERSONAL_SEARCHING);
        private String oldPath;
        private MessagesManager.Message message;

        private LegacyMessage(String oldPath, MessagesManager.Message message) {
            this.oldPath = oldPath;
            this.message = message;
            MESSAGES.add(this);
        }

        public String getOldPath() {
            return this.oldPath;
        }

        public MessagesManager.Message getMessage() {
            return this.message;
        }
    }
}

