/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.config;

import dev.sergiferry.randomtp.config.ConfigManager;
import dev.sergiferry.randomtp.config.PathValue;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;

public class ConfigValue<T>
extends PathValue<T> {
    public static final ConfigValue<Boolean> AUTO_UPDATE = ConfigValue.of("auto-update", Boolean.class);
    public static final ConfigValue<Boolean> DEBUG = ConfigValue.of("debug", Boolean.class);
    public static final ConfigValue<String> COMMAND_LABEL = ConfigValue.of("command.label", String.class);
    public static final ConfigValue<Boolean> COMMAND_ENABLED = ConfigValue.of("command.enabled", Boolean.class);
    public static final ConfigValue<Boolean> COMMAND_TO_OTHER_WORLDS = ConfigValue.of("command.to-other-worlds", Boolean.class);
    public static final ConfigValue<Boolean> USE_PERMISSIONS = ConfigValue.of("use-permissions", Boolean.class);
    public static final ConfigValue<Integer> TELEPORT_TIMER_INVINCIBLE = ConfigValue.of("teleport.timer.invincible", Integer.class);
    public static final ConfigValue<Integer> TELEPORT_TIMER_MAX_SEARCH = ConfigValue.of("teleport.timer.max-search", Integer.class);
    public static final ConfigValue<Integer> TELEPORT_TIMER_COOLDOWN = ConfigValue.of("teleport.timer.cooldown", Integer.class);
    public static final ConfigValue<Boolean> TELEPORT_EFFECT_VISUAL = ConfigValue.of("teleport.effects.visual", Boolean.class);
    public static final ConfigValue<Boolean> TELEPORT_EFFECT_SOUNDS = ConfigValue.of("teleport.effects.sounds", Boolean.class);
    public static final ConfigValue<Boolean> TELEPORT_EFFECT_SLOWNESS = ConfigValue.of("teleport.effects.slowness", Boolean.class);
    public static final ConfigValue<Boolean> TELEPORT_CANCEL_SNEAK = ConfigValue.of("teleport.cancel.sneak", Boolean.class);
    public static final ConfigValue<Boolean> TELEPORT_CANCEL_MOVE = ConfigValue.of("teleport.cancel.move", Boolean.class);
    public static final ConfigValue<Boolean> TELEPORT_CANCEL_TELEPORT = ConfigValue.of("teleport.cancel.teleport", Boolean.class);
    public static final ConfigValue<Boolean> TELEPORT_CANCEL_DAMAGE = ConfigValue.of("teleport.cancel.damage", Boolean.class);
    public static final ConfigValue<Boolean> TELEPORT_CANCEL_DIE = ConfigValue.of("teleport.cancel.die", Boolean.class);
    public static final ConfigValue<Boolean> INTEGRATIONS_VAULT_ENABLED = ConfigValue.of("integrations.vault.enabled", Boolean.class);
    private ConfigManager configManager;

    public static ConfigValue of(ConfigManager configManager, String path, Class<?> type) {
        return new ConfigValue(configManager, path, type);
    }

    public static ConfigValue of(String path, Class<?> type) {
        return ConfigValue.of(ConfigManager.CONFIG, path, type);
    }

    public ConfigValue(@Nonnull ConfigManager configManager, @Nonnull String path, @Nonnull Class<T> type) {
        super(path, type);
        Validate.notNull((Object)((Object)configManager));
        this.configManager = configManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public T get() {
        return (T)this.configManager.getFileConfiguration().getObject(this.getPath(), this.getType());
    }

    public T get(T defaultValue) {
        return (T)this.configManager.getFileConfiguration().getObject(this.getPath(), this.getType(), defaultValue);
    }

    public void set(T value) {
        this.configManager.getFileConfiguration().set(this.getPath(), value);
    }
}

