/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.config;

import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.config.ConfigValue;
import dev.sergiferry.randomtp.config.LegacyConfig;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.nms.spigot.NMSFileConfiguration;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import dev.sergiferry.randomtp.utils.LocationUtils;
import dev.sergiferry.spigot.server.ServerVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public enum ConfigManager {
    CONFIG("config.yml", config -> {
        ConfigManager.setHeader(config, Arrays.asList("Random Teleport by SergiFerry", "Spigot: " + RandomTeleportPlugin.getInstance().getSpigotResource(), "", "Compatible with PlayerNPC API", "Spigot: https://www.spigotmc.org/resources/playernpc.93625/", "", "Compatible with PlaceholderAPI", "Spigot: https://www.spigotmc.org/resources/placeholderapi.6245/", "", "Compatible with Chunky", "Spigot: https://www.spigotmc.org/resources/chunky.81534/", "", "Compatible with Vault (Economy)", "Spigot: https://www.spigotmc.org/resources/vault.34315/", "Use {price} placeholder on Signs, NPCs and Messages."));
        boolean cancelAutoUpdate = !config.contains(ConfigValue.AUTO_UPDATE.getPath());
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put(ConfigValue.AUTO_UPDATE.getPath(), true);
        defaults.put(ConfigValue.DEBUG.getPath(), false);
        defaults.put(ConfigValue.USE_PERMISSIONS.getPath(), true);
        defaults.put(ConfigValue.TELEPORT_TIMER_COOLDOWN.getPath(), 30);
        defaults.put(ConfigValue.TELEPORT_TIMER_MAX_SEARCH.getPath(), 30);
        defaults.put(ConfigValue.TELEPORT_TIMER_INVINCIBLE.getPath(), 5);
        defaults.put(ConfigValue.TELEPORT_CANCEL_SNEAK.getPath(), false);
        defaults.put(ConfigValue.TELEPORT_CANCEL_MOVE.getPath(), false);
        defaults.put(ConfigValue.TELEPORT_CANCEL_TELEPORT.getPath(), true);
        defaults.put(ConfigValue.TELEPORT_CANCEL_DAMAGE.getPath(), true);
        defaults.put(ConfigValue.TELEPORT_CANCEL_DIE.getPath(), true);
        defaults.put(ConfigValue.TELEPORT_EFFECT_VISUAL.getPath(), true);
        defaults.put(ConfigValue.TELEPORT_EFFECT_SOUNDS.getPath(), true);
        defaults.put(ConfigValue.TELEPORT_EFFECT_SLOWNESS.getPath(), true);
        defaults.put(ConfigValue.COMMAND_LABEL.getPath(), "randomtp");
        defaults.put(ConfigValue.COMMAND_ENABLED.getPath(), true);
        defaults.put(ConfigValue.COMMAND_TO_OTHER_WORLDS.getPath(), false);
        for (World world : Bukkit.getWorlds()) {
            if (!WorldOptions.isValid(world.getName())) {
                Bukkit.getConsoleSender().sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a7cWorld '" + world.getName() + "' contains space characters and it's not supported.");
                continue;
            }
            String color = "&a";
            int maxX = 5000;
            int maxY = 150;
            int maxZ = 5000;
            int minX = -5000;
            int minY = 50;
            int minZ = -5000;
            double price = 100.0;
            int preventNearWorldSpawn = 0;
            ArrayList<Object> preventBlocks = new ArrayList<Object>();
            ArrayList<Object> preventBiomes = new ArrayList<Object>();
            preventBlocks.addAll(List.of(Material.OAK_LEAVES, Material.SPRUCE_LEAVES, Material.BIRCH_LEAVES, Material.JUNGLE_LEAVES, Material.ACACIA_LEAVES, Material.DARK_OAK_LEAVES));
            preventBiomes.addAll(List.of(Biome.OCEAN, Biome.COLD_OCEAN, Biome.DEEP_OCEAN, Biome.DEEP_COLD_OCEAN, Biome.DEEP_FROZEN_OCEAN, Biome.DEEP_LUKEWARM_OCEAN));
            if (ServerVersion.getServerVersion().isNewerThanOrEqual(ServerVersion.VERSION_1_18)) {
                preventBlocks.addAll(List.of());
                preventBiomes.addAll(List.of(Biome.GROVE));
            }
            if (ServerVersion.getServerVersion().isNewerThanOrEqual(ServerVersion.VERSION_1_19)) {
                preventBiomes.addAll(List.of());
                preventBlocks.addAll(List.of(Material.MANGROVE_LEAVES));
            }
            if (world.getEnvironment().equals((Object)World.Environment.NETHER)) {
                color = "&c";
                maxX = 1000;
                maxY = 100;
                maxZ = 1000;
                minX = -1000;
                minY = 50;
                minZ = -1000;
                price = 200.0;
                preventBlocks = new ArrayList();
                preventBiomes = new ArrayList();
                preventBlocks.addAll(List.of(Material.NETHER_WART_BLOCK, Material.WARPED_WART_BLOCK));
                preventBiomes.addAll(List.of(Biome.SOUL_SAND_VALLEY));
            } else if (world.getEnvironment().equals((Object)World.Environment.THE_END)) {
                color = "&d";
                maxX = 3000;
                maxY = 100;
                maxZ = 3000;
                minX = -3000;
                minY = 50;
                minZ = -3000;
                price = 500.0;
                preventNearWorldSpawn = 1000;
                preventBlocks = new ArrayList();
                preventBiomes = new ArrayList();
                preventBiomes.addAll(List.of(Biome.SMALL_END_ISLANDS));
            }
            ArrayList preventBlocksString = new ArrayList();
            ArrayList preventBiomesString = new ArrayList();
            preventBlocks.forEach(x -> preventBlocksString.add(x.name()));
            preventBiomes.forEach(x -> preventBiomesString.add(x.name()));
            String configSection = ConfigManager.getConfigSection(world);
            defaults.put(WorldOptions.Value.COORDINATES_MAX_X.getPath(configSection), maxX);
            defaults.put(WorldOptions.Value.COORDINATES_MAX_Y.getPath(configSection), maxY);
            defaults.put(WorldOptions.Value.COORDINATES_MAX_Z.getPath(configSection), maxZ);
            defaults.put(WorldOptions.Value.COORDINATES_MIN_X.getPath(configSection), minX);
            defaults.put(WorldOptions.Value.COORDINATES_MIN_Y.getPath(configSection), minY);
            defaults.put(WorldOptions.Value.COORDINATES_MIN_Z.getPath(configSection), minZ);
            defaults.put(WorldOptions.Value.ALIAS.getPath(configSection), color + "&l" + LocationUtils.getReplacedWorldName(world.getName()));
            defaults.put(WorldOptions.Value.COMMAND_ENABLED.getPath(configSection), true);
            defaults.put(WorldOptions.Value.COMMAND_DESTINATION.getPath(configSection), WorldOptions.format(world));
            defaults.put(WorldOptions.Value.PREVENT_CHUNKS_NOT_GENERATED.getPath(configSection), true);
            defaults.put(WorldOptions.Value.PREVENT_CHUNKS_NOT_LOADED.getPath(configSection), false);
            defaults.put(WorldOptions.Value.PREVENT_PROTECTED_REGIONS.getPath(configSection), false);
            defaults.put(WorldOptions.Value.PREVENT_NEAR_OTHER_PLAYERS.getPath(configSection), 0);
            defaults.put(WorldOptions.Value.PREVENT_NEAR_SEARCH_LOCATION.getPath(configSection), 0);
            defaults.put(WorldOptions.Value.PREVENT_NEAR_WORLD_SPAWN.getPath(configSection), preventNearWorldSpawn);
            defaults.put(WorldOptions.Value.PREVENT_BLOCKS.getPath(configSection), preventBlocksString);
            defaults.put(WorldOptions.Value.PREVENT_BIOMES.getPath(configSection), preventBiomesString);
            defaults.put(WorldOptions.Value.REQUIREMENTS_MONEY_AMOUNT.getPath(configSection), price);
            defaults.put(WorldOptions.Value.REQUIREMENTS_LEVEL_AMOUNT.getPath(configSection), 0);
            defaults.put(WorldOptions.Value.REQUIREMENTS_LEVEL_SUBTRACT.getPath(configSection), false);
            if (world.getEnvironment().equals((Object)World.Environment.NETHER)) {
                defaults.put(WorldOptions.Value.REQUIREMENTS_NETHER_HAVE_GONE_BEFORE.getPath(configSection), true);
            }
            if (!world.getEnvironment().equals((Object)World.Environment.THE_END)) continue;
            defaults.put(WorldOptions.Value.REQUIREMENTS_END_HAVE_GONE_BEFORE.getPath(configSection), true);
            defaults.put(WorldOptions.Value.REQUIREMENTS_END_DEAD_ENDER_DRAGON.getPath(configSection), true);
        }
        defaults.put(ConfigValue.INTEGRATIONS_VAULT_ENABLED.getPath(), false);
        defaults.entrySet().stream().filter(x -> !config.contains((String)x.getKey())).forEachOrdered(x -> config.set((String)x.getKey(), x.getValue()));
        ConfigManager.setComments(config, ConfigValue.DEBUG.getPath(), Arrays.asList("If you set \"debug\" as 'true', RandomTP plugin will print a lot of internal information in the console, useful in case of reporting any error."));
        ConfigManager.setComments(config, ConfigValue.AUTO_UPDATE.getPath(), Arrays.asList("If you set \"auto-update\" as 'true', RandomTP plugin will update automatically when a version is available.", "You can check it manually at: " + RandomTeleportPlugin.getInstance().getSpigotResource()));
        ConfigManager.setComments(config, ConfigValue.USE_PERMISSIONS.getPath(), Arrays.asList("If you set \"use-permissions\" as 'false', players will be able to do all necessary actions without a permissions plugin.", "\u26a0 All ADMIN actions will be available through server OP"));
        ConfigManager.setComments(config, ConfigValue.COMMAND_LABEL.getPath(), Arrays.asList("This will be the label that the player can execute to perform the RandomTP", "Command usage: /<command.label>"));
        ConfigManager.setComments(config, ConfigValue.COMMAND_TO_OTHER_WORLDS.getPath(), Arrays.asList("If you set \"command.to-other-worlds\" as 'true', when doing RandomTP command, you will be able to select other world on the command argument, otherwise you will be teleported to the 'world.command.destination'", "Command usage: /<command.label> (worldName)"));
        ConfigManager.setComments(config, ConfigValue.COMMAND_ENABLED.getPath(), Arrays.asList("If you set \"command.enabled\" as 'false', the command will not be registered, and therefore nobody will be able to use it."));
        ConfigManager.setInlineComments(config, ConfigValue.TELEPORT_TIMER_COOLDOWN.getPath(), "seconds after the last RandomTP");
        ConfigManager.setInlineComments(config, ConfigValue.TELEPORT_TIMER_MAX_SEARCH.getPath(), "seconds after the beginning of the search");
        ConfigManager.setInlineComments(config, ConfigValue.TELEPORT_TIMER_INVINCIBLE.getPath(), "seconds after the RandomTP");
        Bukkit.getWorlds().stream().filter(x -> WorldOptions.isValid(x)).forEach(x -> {
            String configSection = ConfigManager.getConfigSection(x);
            ConfigManager.setComments(config, configSection, Arrays.asList("##############################", "  OPTIONS FOR " + x.getName().toUpperCase(), "##############################"));
            ConfigManager.setComments(config, WorldOptions.Value.ALIAS.getPath(configSection), "This alias will be displayed on messages, signs or NPCs.");
            ConfigManager.setComments(config, WorldOptions.Value.COMMAND_ENABLED.getPath(configSection), Arrays.asList("If you set \"command.enabled\" as 'false', people will not be able to use the command /<command.label> if they are at " + x.getName()));
            ConfigManager.setComments(config, WorldOptions.Value.COMMAND_DESTINATION.getPath(configSection), Arrays.asList("This will be the destination if the player executes /<command.label> without any argument, from " + x.getName()));
            ConfigManager.setComments(config, WorldOptions.Value.REQUIREMENTS.getPath(configSection), Arrays.asList("These requirements will be checked for the player before teleporting, and if not met, the player will not be teleported."));
            ConfigManager.setComments(config, WorldOptions.Value.PREVENT_BLOCKS.getPath(configSection), Arrays.asList("Random locations will be discarded if the block on the ground is one of the following materials.", "List of materials: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html", "\u26a0 Note that not all materials are available on older minecraft versions, or may be called different."));
            ConfigManager.setComments(config, WorldOptions.Value.PREVENT_BIOMES.getPath(configSection), Arrays.asList("Random locations will be discarded if they are in one of the following biomes.", "List of biomes: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/block/Biome.html", "\u26a0 Note that not all biomes are available on older minecraft versions, or may be called different."));
            ConfigManager.setComments(config, WorldOptions.Value.REQUIREMENTS_MONEY_AMOUNT.getPath(configSection), Arrays.asList("This price will be charged to the player when performing a RandomTP to " + x.getName() + ", otherwise it will not be teleported.", "\u26a0 This requires Vault enabled, with an Economy plugin."));
            ConfigManager.setComments(config, WorldOptions.Value.PREVENT_PROTECTED_REGIONS.getPath(configSection), Arrays.asList("This will prevent players from being teleported to a location where they do not have building permissions.", "\u26a0 This works with ALL protection plugins that prevents players from placing blocks."));
            ConfigManager.setComments(config, WorldOptions.Value.PREVENT_NEAR_OTHER_PLAYERS.getPath(configSection), Arrays.asList("This will prevent a RandomTP too close to other players.", "Set as 0 to disable."));
            ConfigManager.setComments(config, WorldOptions.Value.PREVENT_NEAR_SEARCH_LOCATION.getPath(configSection), Arrays.asList("This will prevent a RandomTP too close from the start search location.", "Set as 0 to disable."));
            ConfigManager.setComments(config, WorldOptions.Value.PREVENT_NEAR_WORLD_SPAWN.getPath(configSection), Arrays.asList("This will prevent a RandomTP too close from the " + x.getName() + "'s spawn.", x.getName() + "'s spawn is at x:" + x.getSpawnLocation().getBlockX() + ", z:" + x.getSpawnLocation().getBlockZ(), "Set as 0 to disable."));
            ConfigManager.setComments(config, WorldOptions.Value.REQUIREMENTS_LEVEL_AMOUNT.getPath(configSection), Arrays.asList("The player will be checked if he have at least this amount of experience levels before teleporting, otherwise he won't be teleported."));
            ConfigManager.setComments(config, WorldOptions.Value.REQUIREMENTS_LEVEL_SUBTRACT.getPath(configSection), Arrays.asList("The required experience levels will be removed from the player if the teleport is completed, otherwise they will not be removed."));
            ConfigManager.setInlineComments(config, WorldOptions.Value.PREVENT_NEAR_OTHER_PLAYERS.getPath(configSection), "blocks from the nearest player");
            ConfigManager.setInlineComments(config, WorldOptions.Value.PREVENT_NEAR_SEARCH_LOCATION.getPath(configSection), "blocks from the start search location");
            ConfigManager.setInlineComments(config, WorldOptions.Value.PREVENT_NEAR_WORLD_SPAWN.getPath(configSection), "blocks from the " + x.getName() + "'s spawn");
            ConfigManager.setInlineComments(config, WorldOptions.Value.REQUIREMENTS_LEVEL_AMOUNT.getPath(configSection), "levels of experience");
            ConfigManager.setInlineComments(config, WorldOptions.Value.COORDINATES_MAX_X.getPath(configSection), "blocks from x:0");
            ConfigManager.setInlineComments(config, WorldOptions.Value.COORDINATES_MAX_Y.getPath(configSection), "height blocks (Max: " + x.getMaxHeight() + ")");
            ConfigManager.setInlineComments(config, WorldOptions.Value.COORDINATES_MAX_Z.getPath(configSection), "blocks from z:0");
            ConfigManager.setInlineComments(config, WorldOptions.Value.COORDINATES_MIN_X.getPath(configSection), "blocks from x:0");
            ConfigManager.setInlineComments(config, WorldOptions.Value.COORDINATES_MIN_Y.getPath(configSection), "height blocks (Min: " + x.getMinHeight() + ")");
            ConfigManager.setInlineComments(config, WorldOptions.Value.COORDINATES_MIN_Z.getPath(configSection), "blocks from z:0");
        });
        List<String> footer = ConfigManager.getFooter(config);
        if (footer == null || footer.isEmpty()) {
            ConfigManager.setFooter(config, Arrays.asList("", "Most recent configuration save: Never", "Configuration file created at: " + new Date() + " (Using RandomTP v" + RandomTeleportPlugin.getInstance().getDescription().getVersion() + " and Minecraft Server v" + ServerVersion.getServerVersion().getMinecraftVersion() + ")"));
        }
        if (cancelAutoUpdate || !config.getBoolean(ConfigValue.AUTO_UPDATE.getPath())) {
            RandomTeleportPlugin.getInstance().cancelAutomaticDownload();
        }
        WorldOptions.loadWorlds(config);
    }),
    MESSAGES("messages.yml", config -> {
        MessagesManager.Message.getEntrySet().stream().filter(x -> !config.contains((String)x.getKey())).forEach(x -> {
            config.set((String)x.getKey(), ((MessagesManager.Message)x.getValue()).getDefault());
            if (((MessagesManager.Message)x.getValue()).getChatMessageType() != null) {
                ConfigManager.setInlineComments(config, (String)x.getKey(), Arrays.asList(((MessagesManager.Message)x.getValue()).getChatMessageType().name()));
            }
        });
        ConfigManager.setHeader(config, Arrays.asList("Messages for Random Teleport plugin.", "You can change # CHAT or # ACTION_BAR to modify where you want to display the message. (Not always is available)"));
    });

    private FileConfiguration fileConfiguration;
    private String initialSnapshot;
    private String path;
    private File file;
    private Consumer<FileConfiguration> load;

    private ConfigManager(String path, Consumer<FileConfiguration> load) {
        this.path = path;
        this.file = new File(RandomTeleportPlugin.getInstance().getDataFolder(), path);
        this.fileConfiguration = null;
        this.load = load;
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public void checkExists() throws IOException {
        RandomTeleportPlugin.getInstance().getDataFolder().mkdirs();
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
    }

    public void load() throws IOException {
        this.load.accept(this.createFileConfiguration());
        this.save();
    }

    public void save() throws IOException {
        Validate.notNull((Object)this.fileConfiguration);
        String actualSnapshot = this.fileConfiguration.saveToString();
        if (this.initialSnapshot != null && this.initialSnapshot.equals(actualSnapshot)) {
            return;
        }
        this.setLastSavedComment();
        this.checkExists();
        this.fileConfiguration.save(this.file);
        this.initialSnapshot = actualSnapshot;
    }

    public void setLastSavedComment() {
        if (!this.equals((Object)CONFIG)) {
            return;
        }
        ArrayList<String> footer = new ArrayList<String>();
        List<String> actual = ConfigManager.getFooter(this.fileConfiguration);
        if (actual == null || actual.isEmpty()) {
            return;
        }
        footer.addAll(actual);
        String title = "Most recent configuration save:";
        String comment = title + " " + new Date() + " (Using RandomTP v" + RandomTeleportPlugin.getInstance().getDescription().getVersion() + " and Minecraft Server v" + ServerVersion.getServerVersion().getMinecraftVersion() + ")";
        boolean modified = false;
        for (int i = 0; i < actual.size(); ++i) {
            if (!actual.get(i).startsWith(title)) continue;
            footer.set(i, comment);
            modified = true;
            break;
        }
        if (!modified) {
            return;
        }
        ConfigManager.setFooter(this.fileConfiguration, footer);
    }

    protected void setInitialSnapshot(FileConfiguration configuration) {
        this.initialSnapshot = configuration.saveToString();
    }

    public FileConfiguration createFileConfiguration() throws IOException {
        this.checkExists();
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        this.setInitialSnapshot(this.fileConfiguration);
        return this.fileConfiguration;
    }

    public FileConfiguration getFileConfiguration() {
        return this.fileConfiguration;
    }

    public static void onEnable() {
        Bukkit.getConsoleSender().sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a77Loading configuration files...");
        LegacyConfig.checkLegacy();
        Arrays.stream(ConfigManager.values()).forEach(x -> {
            try {
                x.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static void onDisable() {
        Arrays.stream(ConfigManager.values()).forEach(x -> {
            try {
                x.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private static String getConfigSection(World world) {
        return "worlds." + WorldOptions.format(world);
    }

    public static void setHeader(FileConfiguration fileConfiguration, List<String> header) {
        NMSFileConfiguration.setHeader(fileConfiguration, header);
    }

    public static void setFooter(FileConfiguration fileConfiguration, List<String> footer) {
        NMSFileConfiguration.setFooter(fileConfiguration, footer);
    }

    public static List<String> getFooter(FileConfiguration fileConfiguration) {
        return NMSFileConfiguration.getFooter(fileConfiguration);
    }

    public static List<String> getHeader(FileConfiguration fileConfiguration) {
        return NMSFileConfiguration.getHeader(fileConfiguration);
    }

    public static void setComments(FileConfiguration fileConfiguration, String path, List<String> comments) {
        ArrayList<String> finalComments = new ArrayList<String>();
        finalComments.add("");
        finalComments.addAll(comments);
        NMSFileConfiguration.setComments(fileConfiguration, path, finalComments);
    }

    public static void setInlineComments(FileConfiguration fileConfiguration, String path, List<String> comments) {
        NMSFileConfiguration.setInlineComments(fileConfiguration, path, comments);
    }

    public static void setComments(FileConfiguration fileConfiguration, String path, String comments) {
        ConfigManager.setComments(fileConfiguration, path, Arrays.asList(comments));
    }

    public static void setInlineComments(FileConfiguration fileConfiguration, String path, String comments) {
        ConfigManager.setInlineComments(fileConfiguration, path, Arrays.asList(comments));
    }

    public static void setComments(FileConfiguration fileConfiguration, ConfigurationSection section, String path, String comments) {
        ConfigManager.setComments(fileConfiguration, section.getCurrentPath() + "." + path, Arrays.asList(comments));
    }

    public static void setInlineComments(FileConfiguration fileConfiguration, ConfigurationSection section, String path, String comments) {
        ConfigManager.setInlineComments(fileConfiguration, section.getCurrentPath() + "." + path, Arrays.asList(comments));
    }

    public static void setComments(FileConfiguration fileConfiguration, ConfigurationSection section, String path, List<String> comments) {
        ConfigManager.setComments(fileConfiguration, section.getCurrentPath() + "." + path, comments);
    }

    public static void setInlineComments(FileConfiguration fileConfiguration, ConfigurationSection section, String path, List<String> comments) {
        ConfigManager.setComments(fileConfiguration, section.getCurrentPath() + "." + path, comments);
    }
}

