/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.commands;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.config.ConfigValue;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.player.PermissionsManager;
import dev.sergiferry.randomtp.teleportation.PersonalTeleportationHandler;
import dev.sergiferry.randomtp.teleportation.SearchTask;
import dev.sergiferry.randomtp.teleportation.TeleportationHandler;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeleportCommand
extends Command {
    public static final String DEFAULT_COMMAND = "randomtp";

    public TeleportCommand(String name) {
        super(name);
        super.setDescription("This command will teleport you to a random location.");
        if (!name.equalsIgnoreCase(DEFAULT_COMMAND)) {
            super.setAliases(Arrays.asList(DEFAULT_COMMAND));
        }
    }

    public boolean execute(CommandSender sender, String cmd, String[] args) {
        WorldOptions worldOptions;
        if (!ConfigValue.COMMAND_ENABLED.get().booleanValue()) {
            MessagesManager.Message.COMMAND_DISABLED.sendMessage(sender, new Pair[0]);
            return true;
        }
        if (!(sender instanceof Player)) {
            if (args.length < 1) {
                MessagesManager.Message.COMMAND_ERROR_USAGE.sendMessage(sender, Pair.of((Object)"usage", (Object)(super.getName() + " (playerName) [world]")));
                return true;
            }
            Player player = Bukkit.getPlayerExact((String)args[0]);
            if (player == null) {
                MessagesManager.Message.COMMAND_ERROR_PLAYER_NOT_FOUND.sendMessage(sender, new Pair[0]);
                return true;
            }
            TeleportationHandler.getPlayerPersonalHandler(player).teleportTo(player, args.length > 1 ? Bukkit.getWorld((String)args[1]) : player.getWorld());
            return true;
        }
        Player player = (Player)sender;
        if (!PermissionsManager.Permission.USE.has(player) && !PermissionsManager.Permission.USE_COMMAND.has(player)) {
            PermissionsManager.sendPermissionsMessage(player);
            return true;
        }
        if (SearchTask.isSearching(player)) {
            SearchTask.getSearching(player).cancel(player, SearchTask.Reason.DECISION);
            return true;
        }
        World world = player.getWorld();
        if (WorldOptions.exists(player.getWorld())) {
            worldOptions = WorldOptions.of(player.getWorld());
            if (!worldOptions.isCommandEnabled()) {
                MessagesManager.Message.WORLD_DISABLED_COMMAND.sendMessage((CommandSender)player, new Pair[0]);
                return true;
            }
            world = worldOptions.getWorld();
        }
        if (args.length >= 1 && ConfigValue.COMMAND_TO_OTHER_WORLDS.get().booleanValue()) {
            world = Bukkit.getWorld((String)args[0]);
            if (world == null) {
                MessagesManager.Message.WORLD_NO_EXIST.sendMessage((CommandSender)player, new Pair[0]);
                return true;
            }
            worldOptions = WorldOptions.of(world);
            if (worldOptions == null) {
                MessagesManager.Message.WORLD_NO_CONFIG.sendMessage((CommandSender)player, new Pair[0]);
                return true;
            }
            if (!worldOptions.isCommandEnabled()) {
                MessagesManager.Message.WORLD_DISABLED_COMMAND.sendMessage((CommandSender)player, new Pair[0]);
                return true;
            }
        }
        try {
            PersonalTeleportationHandler<Player> handler = TeleportationHandler.getPlayerPersonalHandler(player);
            handler.confirmTeleport(player, world, null, () -> {});
        }
        catch (Exception e) {
            player.sendMessage(RandomTeleportPlugin.getInstance().getPrefix() + "\u00a7cThere was an error trying to do RandomTP, please contact an administrator.");
            e.printStackTrace();
        }
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> strings = new ArrayList<String>();
        if (sender instanceof Player) {
            if (args.length > 1 || !ConfigValue.COMMAND_TO_OTHER_WORLDS.get().booleanValue()) {
                return strings;
            }
            if (args.length == 1) {
                Bukkit.getWorlds().stream().filter(x -> WorldOptions.exists(x) && WorldOptions.of(x).isCommandEnabled() && x.getName().toLowerCase().startsWith(args[0].toLowerCase())).forEach(x -> strings.add(x.getName()));
            }
        } else {
            if (args.length > 2) {
                return strings;
            }
            if (args.length == 1) {
                Bukkit.getOnlinePlayers().stream().filter(x -> x.getName().toLowerCase().startsWith(args[0].toLowerCase())).forEach(x -> strings.add(x.getName()));
            }
            if (args.length == 2) {
                Bukkit.getWorlds().stream().filter(x -> WorldOptions.exists(x) && x.getName().toLowerCase().startsWith(args[1].toLowerCase())).forEach(x -> strings.add(x.getName()));
            }
        }
        return strings;
    }
}

