/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.commands;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.integration.IntegrationsManager;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.player.PermissionsManager;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import dev.sergiferry.randomtp.teleportation.handlers.npc.RandomTPNPC;
import dev.sergiferry.randomtp.utils.ColorUtils;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.commands.CommandInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class NPCCommand
extends CommandInstance
implements TabCompleter {
    public static final String LABEL = "rtpnpc";

    public NPCCommand(SpigotPlugin plugin) {
        super(plugin, LABEL);
        this.setTabCompleter(this);
    }

    @Override
    public void onExecute(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            MessagesManager.Message.COMMAND_ERROR_MUST_BE_PLAYER.sendMessage(sender, new Pair[0]);
            return;
        }
        Player playerSender = (Player)sender;
        if (!PermissionsManager.Permission.CREATE_NPC.has(playerSender)) {
            PermissionsManager.sendPermissionsMessage(playerSender);
            return;
        }
        if (!IntegrationsManager.isUsingPlayerNPC()) {
            MessagesManager.Message.COMMAND_ERROR_NO_DEPENDENCY.sendMessage((CommandSender)playerSender, Pair.of((Object)"dependency", (Object)"PlayerNPC"), Pair.of((Object)"link", (Object)"https://www.spigotmc.org/resources/playernpc.93625/"));
            return;
        }
        if (args.length == 0) {
            playerSender.sendMessage(MessagesManager.Message.PLAYERNPC_COMMAND_TITLE.getValue(playerSender));
            playerSender.sendMessage("\u00a78\u2022 \u00a7b/rtpnpc create (world) [personal/group]");
            playerSender.sendMessage("\u00a78\u2022 \u00a7b/rtpnpc remove (id)");
            playerSender.sendMessage("\u00a78\u2022 \u00a73/rtpnpc setskin (id) (minecraft/mineskin) (skin)");
            playerSender.sendMessage("\u00a78\u2022 \u00a73/rtpnpc setdestination (id) (world)");
            playerSender.sendMessage("\u00a78\u2022 \u00a73/rtpnpc setpermission (id) (permission)");
            playerSender.sendMessage("\u00a78\u2022 \u00a73/rtpnpc setglowingcolor (id) (color)");
            playerSender.sendMessage("\u00a78\u2022 \u00a73/rtpnpc setfollowgaze (id) (true/false)");
            return;
        }
        if (args[0].equalsIgnoreCase("create")) {
            if (args.length < 2) {
                MessagesManager.Message.COMMAND_ERROR_USAGE.sendMessage((CommandSender)playerSender, Pair.of((Object)"usage", (Object)"rtpnpc create (world) [personal/group]"));
                return;
            }
            World world = Bukkit.getWorld((String)args[1]);
            if (world == null) {
                MessagesManager.Message.WORLD_NO_EXIST.sendMessage((CommandSender)playerSender, new Pair[0]);
                return;
            }
            WorldOptions worldOptions = WorldOptions.of(world);
            if (worldOptions == null) {
                MessagesManager.Message.WORLD_NO_CONFIG.sendMessage((CommandSender)playerSender, new Pair[0]);
                return;
            }
            RandomTPNPC.Type type = RandomTPNPC.Type.PERSONAL;
            if (args.length > 2 && args[2].equalsIgnoreCase("group")) {
                type = RandomTPNPC.Type.GROUP;
            }
            IntegrationsManager.getPlayerNPC().setupNPC(playerSender, playerSender.getLocation(), type, worldOptions);
            return;
        }
        if (args.length < 2) {
            MessagesManager.Message.PLAYERNPC_COMMAND_ID_NOT_SPECIFIED.sendMessage((CommandSender)playerSender, new Pair[0]);
            return;
        }
        Integer id = null;
        try {
            id = Integer.valueOf(args[1]);
        }
        catch (Exception worldOptions) {
            // empty catch block
        }
        if (id == null) {
            MessagesManager.Message.PLAYERNPC_COMMAND_ID_NOT_VALID.sendMessage((CommandSender)playerSender, Pair.of((Object)"id", (Object)args[1]));
            return;
        }
        RandomTPNPC randomTPNPC = IntegrationsManager.getPlayerNPC().getMapNPC().get(id);
        if (randomTPNPC == null) {
            MessagesManager.Message.PLAYERNPC_COMMAND_ID_NOT_FOUND.sendMessage((CommandSender)playerSender, Pair.of((Object)"id", (Object)("#" + id)));
            return;
        }
        if (args[0].equalsIgnoreCase("remove")) {
            randomTPNPC.removeConfirmation(playerSender);
            return;
        }
        if (args[0].equalsIgnoreCase("setpermission")) {
            if (args.length < 3) {
                MessagesManager.Message.COMMAND_ERROR_USAGE.sendMessage((CommandSender)playerSender, Pair.of((Object)"usage", (Object)"rtpnpc setpermission (id) (permission)"));
                return;
            }
            randomTPNPC.setPermission(args[2]);
            MessagesManager.Message.PLAYERNPC_COMMAND_SETPERMISSION_SUCCESS.sendMessage((CommandSender)playerSender, Pair.of((Object)"id", (Object)("#" + id)), Pair.of((Object)"permission", (Object)randomTPNPC.getPermission()));
            return;
        }
        if (args[0].equalsIgnoreCase("setdestination")) {
            if (args.length < 3) {
                MessagesManager.Message.COMMAND_ERROR_USAGE.sendMessage((CommandSender)playerSender, Pair.of((Object)"usage", (Object)"rtpnpc setdestination (id) (world)"));
                return;
            }
            WorldOptions worldOptions = WorldOptions.of(args[2]);
            if (worldOptions == null) {
                MessagesManager.Message.COMMAND_ERROR_WORLD_NOT_RECOGNIZED.sendMessage((CommandSender)playerSender, Pair.of((Object)"world", (Object)args[2]));
                return;
            }
            randomTPNPC.setDestination(worldOptions.getWorld());
            MessagesManager.Message.PLAYERNPC_COMMAND_SETDESTINATION_SUCCESS.sendMessage((CommandSender)playerSender, Pair.of((Object)"id", (Object)("#" + id)), Pair.of((Object)"destination", (Object)ColorUtils.color(worldOptions.getAlias())));
            return;
        }
        if (args[0].equalsIgnoreCase("setglowingcolor")) {
            if (args.length < 3) {
                MessagesManager.Message.COMMAND_ERROR_USAGE.sendMessage((CommandSender)playerSender, Pair.of((Object)"usage", (Object)"rtpnpc setglowingcolor (id) (color)"));
                return;
            }
            ChatColor chatColor = null;
            boolean none = args[2].equalsIgnoreCase("none");
            if (!none) {
                try {
                    chatColor = ChatColor.valueOf((String)args[2].toUpperCase());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(none || chatColor != null && chatColor.isColor())) {
                MessagesManager.Message.COMMAND_ERROR_COLOR_NOT_RECOGNIZED.sendMessage((CommandSender)playerSender, Pair.of((Object)"color", (Object)args[2]));
                return;
            }
            randomTPNPC.setGlowingColor(chatColor);
            MessagesManager.Message.PLAYERNPC_COMMAND_SETGLOWINGCOLOR_SUCCESS.sendMessage((CommandSender)playerSender, Pair.of((Object)"id", (Object)("#" + id)), Pair.of((Object)"color", (Object)(none ? "\u00a7cnone" : "\u00a7a" + chatColor.name().toLowerCase())));
            return;
        }
        if (args[0].equalsIgnoreCase("setfollowgaze")) {
            if (args.length < 3) {
                MessagesManager.Message.COMMAND_ERROR_USAGE.sendMessage((CommandSender)playerSender, Pair.of((Object)"usage", (Object)"rtpnpc setfollowgaze (id) (boolean)"));
                return;
            }
            Boolean aBoolean = Boolean.valueOf(args[2]);
            randomTPNPC.setFollowGaze(aBoolean);
            MessagesManager.Message.PLAYERNPC_COMMAND_SETFOLLOWGAZE_SUCCESS.sendMessage((CommandSender)playerSender, Pair.of((Object)"id", (Object)("#" + id)), Pair.of((Object)"boolean", (Object)(aBoolean != false ? "\u00a7atrue" : "\u00a7cfalse")));
            return;
        }
        if (args[0].equalsIgnoreCase("setskin")) {
            if (args.length < 4) {
                MessagesManager.Message.COMMAND_ERROR_USAGE.sendMessage((CommandSender)playerSender, Pair.of((Object)"usage", (Object)"rtpnpc setskin (id) (minecraft/mineskin) (skin)"));
                return;
            }
            IntegrationsManager.getPlayerNPC().updateSkin((CommandSender)playerSender, randomTPNPC, args);
            return;
        }
        MessagesManager.Message.PLAYERNPC_COMMAND_INCORRECT.sendMessage((CommandSender)playerSender, Pair.of((Object)"command", (Object)"/rtpnpc"));
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        Player playerSender;
        if (!label.equalsIgnoreCase(this.getCommandLabel())) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        Player player = playerSender = sender instanceof Player ? (Player)sender : null;
        if (playerSender == null || !PermissionsManager.Permission.CREATE_NPC.has(playerSender)) {
            return strings;
        }
        if (args.length == 1) {
            Arrays.asList("create", "remove", "setpermission", "setdestination", "setglowingcolor", "setfollowgaze", "setskin").stream().filter(x -> x.startsWith(args[0].toLowerCase())).forEach(x -> strings.add((String)x));
        } else {
            if (args[0].equalsIgnoreCase("create")) {
                if (args.length == 2) {
                    Bukkit.getWorlds().stream().filter(x -> WorldOptions.exists(x) && x.getName().toLowerCase().startsWith(args[1].toLowerCase())).forEach(x -> strings.add(x.getName()));
                }
                if (args.length == 3) {
                    Arrays.asList("personal", "group").stream().filter(x -> x.startsWith(args[2].toLowerCase())).forEach(x -> strings.add((String)x));
                }
                return strings;
            }
            if (args.length == 2) {
                IntegrationsManager.getPlayerNPC().getMapNPC().keySet().stream().filter(x -> x.toString().startsWith(args[1])).forEach(x -> strings.add(x.toString()));
            }
            if (args.length < 3) {
                return strings;
            }
            Integer id = null;
            try {
                id = Integer.valueOf(args[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (id == null) {
                return strings;
            }
            RandomTPNPC randomTPNPC = IntegrationsManager.getPlayerNPC().getNPC(id);
            if (randomTPNPC == null) {
                return strings;
            }
            if (args[0].equalsIgnoreCase("setpermission")) {
                if (args.length == 3 && randomTPNPC.getPermission().toLowerCase().startsWith(args[2].toLowerCase())) {
                    strings.add(randomTPNPC.getPermission().toLowerCase());
                }
            } else if (args[0].equalsIgnoreCase("setdestination")) {
                if (args.length == 3) {
                    Bukkit.getWorlds().stream().filter(x -> WorldOptions.exists(x) && WorldOptions.format(x).toLowerCase().startsWith(args[2].toLowerCase())).forEach(x -> strings.add(WorldOptions.format(x).toLowerCase()));
                }
            } else if (args[0].equalsIgnoreCase("setglowingcolor")) {
                if (args.length == 3) {
                    Arrays.stream(ChatColor.values()).filter(x -> x.isColor() && x.name().toLowerCase().startsWith(args[2].toLowerCase())).forEach(x -> strings.add(x.name().toLowerCase()));
                    if ("none".startsWith(args[2].toLowerCase())) {
                        strings.add("none");
                    }
                }
            } else if (args[0].equalsIgnoreCase("setfollowgaze")) {
                if (args.length == 3) {
                    List.of("true", "false").stream().filter(x -> x.startsWith(args[2].toLowerCase())).forEach(x -> strings.add((String)x));
                }
            } else if (args[0].equalsIgnoreCase("setskin")) {
                if (args.length == 3) {
                    Arrays.asList("mineskin", "minecraft", "custom", "url", "npc").stream().filter(x -> x.startsWith(args[2].toLowerCase())).forEach(x -> strings.add((String)x));
                }
                if (args.length == 4) {
                    IntegrationsManager.getPlayerNPC().getSuggestedSkins(args[2]).stream().filter(x -> x.toLowerCase().startsWith(args[3].toLowerCase())).forEach(x -> strings.add(x.toLowerCase()));
                }
            }
        }
        return strings;
    }

    public String getPrefix() {
        return RandomTeleportPlugin.getInstance().getPrefix();
    }
}

