/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.commands;

import com.mojang.datafixers.util.Pair;
import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.integration.IntegrationsManager;
import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.player.PermissionsManager;
import dev.sergiferry.randomtp.teleportation.WorldOptions;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.commands.CommandInstance;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class GenerateCommand
extends CommandInstance
implements TabCompleter {
    public static final String LABEL = "rtpgenerate";

    public GenerateCommand(SpigotPlugin plugin) {
        super(plugin, LABEL);
        this.getCommand().setUsage("/rtpgenerate (world)");
        this.setTabCompleter(this);
    }

    @Override
    public void onExecute(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && !PermissionsManager.Permission.ADMIN.has((Player)sender)) {
            PermissionsManager.sendPermissionsMessage((Player)sender);
            return;
        }
        if (!IntegrationsManager.isUsingChunky()) {
            MessagesManager.Message.COMMAND_ERROR_NO_DEPENDENCY.sendMessage(sender, Pair.of((Object)"dependency", (Object)"Chunky"), Pair.of((Object)"link", (Object)"https://www.spigotmc.org/resources/chunky.81534/"));
            return;
        }
        if (args.length == 0) {
            MessagesManager.Message.COMMAND_ERROR_USAGE.sendMessage(sender, Pair.of((Object)"usage", (Object)"rtpgenerate (world)"));
            return;
        }
        World world = Bukkit.getWorld((String)args[0]);
        if (world == null) {
            MessagesManager.Message.WORLD_NO_EXIST.sendMessage(sender, new Pair[0]);
            return;
        }
        WorldOptions worldOptions = WorldOptions.of(world);
        if (worldOptions == null) {
            MessagesManager.Message.WORLD_NO_CONFIG.sendMessage(sender, new Pair[0]);
            return;
        }
        IntegrationsManager.getChunky().command(sender, worldOptions);
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        Player playerSender;
        if (!label.equalsIgnoreCase(this.getCommandLabel())) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        Player player = playerSender = sender instanceof Player ? (Player)sender : null;
        if (playerSender == null || !PermissionsManager.Permission.ADMIN.has(playerSender)) {
            return strings;
        }
        if (args.length == 1) {
            Bukkit.getWorlds().stream().filter(x -> WorldOptions.exists(x) && x.getName().toLowerCase().startsWith(args[0].toLowerCase())).forEach(x -> strings.add(x.getName()));
        }
        return strings;
    }

    public String getPrefix() {
        return RandomTeleportPlugin.getInstance().getPrefix();
    }
}

