/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.commands;

import dev.sergiferry.randomtp.RandomTeleportPlugin;
import dev.sergiferry.randomtp.commands.GenerateCommand;
import dev.sergiferry.randomtp.commands.NPCCommand;
import dev.sergiferry.randomtp.commands.ReloadCommand;
import dev.sergiferry.randomtp.commands.TeleportCommand;
import dev.sergiferry.randomtp.config.ConfigValue;
import java.lang.reflect.Field;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;

public class CommandsManager {
    private static CommandMap commandMap;
    private static Command customCommand;

    public static void onEnable() {
        new NPCCommand(RandomTeleportPlugin.getInstance());
        new ReloadCommand(RandomTeleportPlugin.getInstance());
        new GenerateCommand(RandomTeleportPlugin.getInstance());
        CommandsManager.loadCustomCommand();
    }

    public static void onDisable() {
        if (customCommand != null) {
            customCommand.unregister(commandMap);
        }
        customCommand = null;
        commandMap = null;
    }

    private static void loadCustomCommand() {
        if (!ConfigValue.COMMAND_ENABLED.get().booleanValue()) {
            return;
        }
        String cmd = ConfigValue.COMMAND_LABEL.get();
        try {
            Field cmdMap = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            cmdMap.setAccessible(true);
            commandMap = (CommandMap)cmdMap.get(Bukkit.getPluginManager());
            customCommand = new TeleportCommand(cmd);
            commandMap.register("randomtp", customCommand);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

