/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.randomtp.api;

import dev.sergiferry.randomtp.messages.MessagesManager;
import dev.sergiferry.randomtp.player.PlayerManager;
import dev.sergiferry.randomtp.teleportation.FindLocation;
import dev.sergiferry.randomtp.teleportation.SearchTask;
import dev.sergiferry.randomtp.teleportation.TeleportationHandler;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class RandomTPAPI {
    public static CompletableFuture<Location> getRandomLocation(@Nonnull SearchTask.Options options, Consumer<Location> action) {
        CompletableFuture<Location> completableFuture = RandomTPAPI.getRandomLocation(options);
        if (action != null) {
            completableFuture.thenAccept(location -> action.accept((Location)location));
        }
        return completableFuture;
    }

    public static CompletableFuture<Location> getRandomLocation(@Nonnull SearchTask.Options options) {
        Validate.notNull((Object)options);
        return FindLocation.getRandomLocation(options);
    }

    @Deprecated
    public static void teleport(@Nonnull Player player, @Nonnull World world) {
        RandomTPAPI.searchRandomLocation(player, world);
    }

    public static void searchRandomLocation(@Nonnull Player player, @Nonnull World world) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)world);
        if (RandomTPAPI.isSearching(player)) {
            return;
        }
        SearchTask.registerSearch(null, player, new SearchTask.Options(world, TeleportationHandler.getPlayerPersonalHandler(player))).start();
    }

    public static boolean isSearching(@Nonnull Player player) {
        Validate.notNull((Object)player);
        return SearchTask.isSearching(player);
    }

    public static void cancelSearching(@Nonnull Player player) {
        RandomTPAPI.cancelSearching(player, null);
    }

    public static void cancelSearching(@Nonnull Player player, @Nullable SearchTask.Reason reason) {
        SearchTask searchTask;
        Validate.notNull((Object)player);
        if (reason == null) {
            reason = SearchTask.Reason.UNKNOWN;
        }
        if ((searchTask = SearchTask.getSearching(player)) == null) {
            return;
        }
        searchTask.cancel(player, reason);
    }

    public static void cancelCooldown(@Nonnull Player player) {
        Validate.notNull((Object)player);
        PlayerManager.cancelCooldown(player);
    }

    public static Integer getCooldown(@Nonnull Player player) {
        Validate.notNull((Object)player);
        return PlayerManager.getCooldown(player);
    }

    public static Boolean hasCooldown(@Nonnull Player player) {
        Validate.notNull((Object)player);
        return !RandomTPAPI.getCooldown(player).equals(-1);
    }

    public static MessagesManager.Message getMessage(@Nonnull String code) {
        Validate.notNull((Object)code);
        return MessagesManager.Message.getMessage(code.toUpperCase());
    }
}

