/*
 * Decompiled with CFR 0.152.
 */
package com.martinambrus.bukkitopfix;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitOpFix
extends JavaPlugin
implements Listener {
    private Integer opLevel = 0;
    private Map<String, Integer> perPlayerLevel = new HashMap<String, Integer>();

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        File f = new File("server.properties");
        this.opLevel = Integer.parseInt(BukkitOpFix.getString("op-permission-level", f));
        this.reloadOpsCache();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private void reloadOpsCache() {
        this.perPlayerLevel = new HashMap<String, Integer>();
        try {
            String opsFileContent = this.readFile("ops.json", StandardCharsets.UTF_8);
            List ops = (List)new Gson().fromJson(opsFileContent, ArrayList.class);
            for (Object pair : ops) {
                Map values = (Map)pair;
                this.perPlayerLevel.put((String)values.get("uuid"), ((Double)values.get("level")).intValue());
            }
        }
        catch (IOException e1) {
            Bukkit.getLogger().warning("[BukkitOpFix] Failed to load data from ops.json file.");
            e1.printStackTrace();
        }
    }

    private String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public static String getString(String s, File f) {
        Properties pr = new Properties();
        try {
            FileInputStream in = new FileInputStream(f);
            pr.load(in);
            String string = pr.getProperty(s);
            return string;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (event.getMessage().startsWith("/op") || event.getMessage().startsWith("/deop")) {
            this.reloadOpsCache();
        }
        if (player.isOp()) {
            String cmd = event.getMessage().replace("/", "");
            if (cmd.contains(" ")) {
                cmd = cmd.split(" ")[0];
            }
            List disabledOpCommands = new ArrayList();
            Integer localOpLevel = this.perPlayerLevel.containsKey(player.getUniqueId().toString()) ? this.perPlayerLevel.get(player.getUniqueId().toString()) : this.opLevel;
            disabledOpCommands = this.getConfig().getStringList("level" + localOpLevel + "disabledCommands");
            if (disabledOpCommands.contains(cmd.toLowerCase())) {
                player.sendMessage(ChatColor.RED + this.getConfig().getString("disallowMessage"));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void redirectConsoleCommand(ServerCommandEvent event) {
        if (event.getCommand().startsWith("op") || event.getCommand().startsWith("deop")) {
            this.reloadOpsCache();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Integer localOpLevel;
        Integer n = localOpLevel = this.perPlayerLevel.containsKey(event.getPlayer().getUniqueId().toString()) ? this.perPlayerLevel.get(event.getPlayer().getUniqueId().toString()) : this.opLevel;
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && event.getClickedBlock().getType().equals((Object)Material.COMMAND) && localOpLevel < 2) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(ChatColor.RED + this.getConfig().getString("disallowMessage"));
            event.getPlayer().closeInventory();
        }
    }
}

