package com.ralitski.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Simple reflection helper. Not meant to be any sort of external API.
 * 
 * @author ralitski
 */
public class Reflection {
    
    //==========================================================================
    //fields
    //==========================================================================
    
    public static Object getFieldValue(Object o, String name) {
        Field field = getField(o.getClass(), name);
        if(field != null) {
            try {
                field.setAccessible(true);
                return field.get(o);
            } catch (IllegalArgumentException | IllegalAccessException ex) {
                Logger.getLogger(Reflection.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }
    
    public static Field getField(Class<?> c, String name) {
        try {
            return c.getDeclaredField(name);
        } catch (NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(Reflection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
    
    //==========================================================================
    //methods
    //==========================================================================
    
    public static Object invokeDynamic(Object o, String name, Object... params) {
        Class<?> c = o.getClass();
        return doInvoke(o, c, name, params);
    }
    
    public static Object invokeStatic(Class<?> c, String name, Object... params) {
        return doInvoke(null, c, name, params);
    }
    
    private static Object doInvoke(Object o, Class<?> c, String name, Object... params) {
        int len = params.length;
        //Create the array of parameter types to retrieve the Method object
        Class[] types = new Class[len];
        for(int i = 0; i < len; i++) {
            types[i] = params[i].getClass();
        }
        //Retrieve and invoke method
        Method m = getMethod(c, name, types);
        if(m != null) {
            try {
                m.setAccessible(true);
                return m.invoke(o, params);
            } catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                //Don't care
                Logger.getLogger(Reflection.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }
    
    public static Method getMethod(Class<?> c, String name, Class...types) {
        try {
            Method m = c.getDeclaredMethod(name, types);
            return m;
        } catch (NoSuchMethodException | SecurityException ex) {
            return null;
        }
    }
}
