package com.ralitski.mc.bukkit.util.commands;

import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Player;

/**
 *
 * @author ralitski
 */
public class SenderType {
    
    /**
     * Any sender (all types OR'd together).
     */
    public static final int ALL = 0b00011111;
    public static final int COMMAND_BLOCK = 0b00000001;
    public static final int CONSOLE = 0b00000010;
    public static final int PLAYER = 0b00000100;
    public static final int REMOTE_CONSOLE = 0b00001000;
    public static final int UNKNOWN = 0b00010000;
    
    public static int getSenderType(CommandSender sender) {
        if (sender instanceof Player) {
            return PLAYER;
        } else if (sender instanceof ConsoleCommandSender) {
            return CONSOLE;
        } else if (sender instanceof BlockCommandSender) {
            return COMMAND_BLOCK;
        } else if (sender instanceof RemoteConsoleCommandSender) {
            return REMOTE_CONSOLE;
        }
        return UNKNOWN;
    }
}
