package com.ralitski.mc.bukkit.util.commands;

import java.lang.annotation.Annotation;

/**
 *
 * @author ralitski
 */
public class CustomCommand implements Command {
    
    private String name;
    private String[] description = {};
    private String usage = "";
    private String permission = "";
    private int senderTypes = SenderType.ALL;
    private int minArgs = 0;
    private int maxArgs = -1;

    CustomCommand() {
        this("");
    }

    CustomCommand(String commandName) {
        this.name = commandName;
    }
    
    //==========================================================================
    //setters
    //==========================================================================

    public CustomCommand setName(String name) {
        this.name = name;
        return this;
    }

    public CustomCommand setDescription(String[] description) {
        this.description = description;
        return this;
    }

    public CustomCommand setUsage(String usage) {
        this.usage = usage;
        return this;
    }

    public CustomCommand setPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public CustomCommand setSenderTypes(int senderTypes) {
        this.senderTypes = senderTypes;
        return this;
    }

    public CustomCommand setMinArgs(int minArgs) {
        this.minArgs = minArgs;
        return this;
    }

    public CustomCommand setMaxArgs(int maxArgs) {
        this.maxArgs = maxArgs;
        return this;
    }
    
    //==========================================================================
    //@Command methods
    //==========================================================================

    @Override
    public String name() {
        return name;
    }

    @Override
    public String[] description() {
        return description;
    }

    @Override
    public String usage() {
        return usage;
    }

    @Override
    public String permission() {
        return permission;
    }

    @Override
    public int senderTypes() {
        return senderTypes;
    }

    @Override
    public int minArgs() {
        return minArgs;
    }

    @Override
    public int maxArgs() {
        return maxArgs;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Command.class;
    }

}
