package com.ralitski.mc.bukkit.util.commands;

import java.util.Arrays;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

/**
 *
 * @author ralitski
 */
public class CommandWrapper {

    private CommandSender sender;
    private Command cmd;
    private String alias;
    private String[] args;

    public CommandWrapper(CommandSender cs, Command cmd, String string, String[] strings) {
        this.sender = cs;
        this.cmd = cmd;
        this.alias = string;
        this.args = strings;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public Command getCommand() {
        return this.cmd;
    }

    public String getAlias() {
        return this.alias;
    }

    public String[] getArgs() {
        return this.args;
    }
    
    public int getSize() {
        return this.args.length;
    }
    
    public String getArg(int index) {
        try {
            return args[index];
        } catch (Exception e) {
            //Silently ignore exceptions, eg. ArrayIndexOutOfBounds
            return null;
        }
    }
    
    @Override
    public String toString() {
        return "CommandWrapper[sender = " + sender.getName() + ", command = " + cmd + ", alias = " + alias + ", args = " + Arrays.toString(args) + "]";
    }
}
