package com.ralitski.mc.bukkit.util.commands;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * @author ralitski
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Command {
    
    /**
     * The name of the command sub-section this Command handles
     * @return 
     */
    public String name();
    
    //description and usage are not yet implemented

    /**
     * A description of this Command, with each String in the array representing
     * a new line. This is to explain to users what a command does.
     *
     * @return
     */
    public String[] description();
    
    /**
     * A string that explains the usage of this command, ie. the arguments it takes
     * @return 
     */
    public String usage();

    /**
     * The permission required for a CommandSender to use this Command.
     * @return 
     */
    public String permission();
    
    /**
     * The types of CommandSenders that are allowed to use this command. Multiple sender types can be OR'd together.
     * @return 
     */
    public int senderTypes() default SenderType.ALL;
    
    /**
     * The minimum number of arguments that this Command will take.
     * @return 
     */
    public int minArgs() default 0;
    
    /**
     * The maximum number of arguments that this Command will take (or -1 for infinite).
     * @return 
     */
    public int maxArgs() default -1;
}