package com.ralitski.mc.bukkit.util;

import org.bukkit.ChatColor;

/**
 *
 * @author ralitski
 */
public class Messenger {
    
    public static final ChatColor DEFAULT_COLOR = ChatColor.BLUE;
    
    //bases
    private String name;
    private String cont;
    private ChatColor color;
    //prefixes
    private String prefix;
    private String prefixCont;
    //Add spaces
    private String prefixSpaced;
    private String prefixContSpaced;
    
    public Messenger(String name) {
        this(name, DEFAULT_COLOR);
    }
    
    public Messenger(String name, ChatColor color) {
        this(name, "...", color);
    }
    
    public Messenger(String name, String cont) {
        this(name, cont, DEFAULT_COLOR);
    }
    
    public Messenger(String name, String cont, ChatColor color) {
        this.name = name;
        this.cont = cont;
        this.color = color;
        prefix = wrap(color + name);
        prefixCont = wrap(color + cont);
        prefixSpaced = wrapSpaced(color + name);
        prefixContSpaced = wrapSpaced(color + cont);
    }

    public ChatColor getColor() {
        return color;
    }

    public String getName() {
        return name;
    }

    public String getCont() {
        return cont;
    }

    public String getPrefix() {
        return prefix;
    }

    public String getPrefixCont() {
        return prefixCont;
    }

    public String getPrefixSpaced() {
        return prefixSpaced;
    }

    public String getPrefixContSpaced() {
        return prefixContSpaced;
    }
    
    private String wrap(String s) {
        return ChatColor.DARK_GRAY + "[" + ChatColor.RESET + s + ChatColor.DARK_GRAY + "]" + ChatColor.RESET;
    }
    
    private String wrapSpaced(String s) {
        return ChatColor.DARK_GRAY + "[" + ChatColor.RESET + s + ChatColor.DARK_GRAY + "] " + ChatColor.RESET;
    }
    
    public String[] prefix(String... args) {
        if(args.length == 0) return args; //No thanks
        //Quick prefix
        else if(args.length == 1) return new String[]{prefixSpaced + args[0]};
        else {
            int len = args.length;
            String[] out = new String[len];
            out[0] = prefixSpaced + args[0];
            for(int i = 1; i < len; i++) {
                out[i] = prefixContSpaced + args[i];
            }
            return out;
        }
    }
    
    public static String combine(String[] args) {
        return combine(args, ' ');
    }
    
    public static String combine(String[] args, char glue) {
        return combine(args, glue, 0);
    }
    
    public static String combine(String[] args, char glue, int start) {
        return combine(args, glue, start, args.length);
    }
    
    public static String combine(String[] args, int start) {
        return combine(args, ' ', start);
    }
    
    public static String combine(String[] args, int start, int end) {
        return combine(args, ' ', start, end);
    }
    
    public static String combine(String[] args, char glue, int start, int end) {
        //Calculate the length of the final string
        int len = 0;
        for(int i = start; i <  end; i++) {
            String s = args[i];
            if(s != null) len += s.length();
        }
        //One character of glue between each argument
        len += (args.length - 1);
        char[] out = new char[len];
        int outIndex = 0;
        //Copy le data
        for(int argIndex = start; argIndex < end; argIndex++) {
            String s = args[argIndex];
            if(s != null) {
                char[] arg = s.toCharArray();
                System.arraycopy(arg, 0, out, outIndex, arg.length);
                outIndex += arg.length;
            }
            //Insert glue if it's between two args
            if(outIndex < len) out[outIndex++] = glue;
        }
        return String.valueOf(out);
    }
}
