package com.ralitski.mc.bukkit.nbt;

import com.ralitski.mc.bukkit.items.Unstable;
import net.minecraft.server.v1_8_R3.NBTTagIntArray;

/**
 *
 * @author ralitski
 */
public class TagIntArray extends TagBase {

    private final NBTTagIntArray handle;
    
    public TagIntArray() {
        this(new int[]{});
    }
    
    public TagIntArray(int[] value) {
        this(new NBTTagIntArray(value));
    }

    public TagIntArray(NBTTagIntArray handle) {
        super(handle);
        this.handle = handle;
    }
    
    @Override
    public NBTTagIntArray getHandle() {
        return handle;
    }
    
    @Unstable
    public int[] getIntArray() {
        //net.minecraft.server.v1_8_R3.NBTTagIntArray
        //public byte[] c()
        return handle.c();
    }
}
