package com.ralitski.mc.bukkit.nbt;

import com.ralitski.mc.bukkit.items.Unstable;
import net.minecraft.server.v1_8_R3.NBTTagByteArray;

/**
 *
 * @author ralitski
 */
public class TagByteArray extends TagBase {

    private final NBTTagByteArray handle;
    
    public TagByteArray() {
        this(new byte[]{});
    }
    
    public TagByteArray(byte[] value) {
        this(new NBTTagByteArray(value));
    }

    public TagByteArray(NBTTagByteArray handle) {
        super(handle);
        this.handle = handle;
    }
    
    @Override
    public NBTTagByteArray getHandle() {
        return handle;
    }
    
    @Unstable
    public byte[] getByteArray() {
        //net.minecraft.server.v1_8_R3.NBTTagByteArray
        //public byte[] c()
        return handle.c();
    }
}