package com.ralitski.mc.bukkit.nbt;

import com.ralitski.mc.bukkit.items.Unstable;
import net.minecraft.server.v1_8_R3.NBTReadLimiter;

/**
 * Wrapper for nms class "NBTReadLimiter" which imposes limits on buffer
 * allocation when reading NBT data. It keeps a running total of the number of
 * bits allocated, and will throw an exception if the number of bits exceeds the
 * total allowed.
 *
 * @author ralitski
 */
public class ReadLimiter {

    /**
     * A ReadLimiter that imposes no limits on input allocation.
     */
    public static final ReadLimiter unlimited = new ReadLimiter(0){
        @Override
        public void checkAllocation(long l) {}
    };
    
    //implements the wrapped methods
    private final NBTReadLimiter handle;

    /**
     * Creates a new ReadLimiter with the given buffer allocation limit.
     * @param limit The total limit (in bits) of how much may be allocated
     */
    public ReadLimiter(long limit) {
        this(new NBTReadLimiter(limit));
    }

    public ReadLimiter(NBTReadLimiter handle) {
        this.handle = handle;
    }
    
    public NBTReadLimiter getHandle() {
        return handle;
    }

    /**
     * Checks whether the given length of additional data can be allocated. If
     * not, it throws an exception.
     *
     * @param bits The number of bits to allocate next
     */
    @Unstable
    public void checkAllocation(long bits) {
        //net.minecraft.server.v1_8_R3.NBTReadLimiter
        //public void a(long l)
        handle.a(bits);
    }

}
