package com.ralitski.mc.bukkit.nbt;

import com.ralitski.mc.bukkit.items.Unstable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.server.v1_8_R3.NBTCompressedStreamTools;
import net.minecraft.server.v1_8_R3.NBTTagCompound;

/**
 * Wrapper class for NBTCompressedStreamTools
 * 
 * @author ralitski
 */
public class CompressedStreamTools {
    
    /**
     * Wraps the given input stream in a GZIPInputStream and reads NBT data.
     * @param in An InputStream that will be unzipped and read from
     * @return A TagCompound read from the given InputStream
     * @throws IOException If the nms code throws an IOException, duh
     */
    @Unstable
    public static TagCompound readFromCompressed(InputStream in) throws IOException {
        //net.minecraft.server.v1_8_R3.NBTCompressedStreamTools
        //public static NBTTagCompound a(InputStream inputstream) throws IOException
        NBTTagCompound compound = NBTCompressedStreamTools.a(in);
        return new TagCompound(compound);
    }
    
    /**
     * Reads data from the given stream, with no limits on buffer allocation.
     * @param in
     * @return
     * @throws IOException 
     */
    public static TagCompound readUnlimited(DataInputStream in) throws IOException {
        return readLimited(in, ReadLimiter.unlimited);
    }
    
    /**
     * Reads data from the given stream, with buffer allocation limits specified by the given ReadLimiter.
     * @param in
     * @param limiter
     * @return
     * @throws IOException 
     */
    @Unstable
    public static TagCompound readLimited(DataInput in, ReadLimiter limiter) throws IOException {
        //net.minecraft.server.v1_8_R3.NBTCompressedStreamTools
        //public static NBTTagCompound a(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException
        NBTTagCompound compound = NBTCompressedStreamTools.a(in, limiter.getHandle());
        return new TagCompound(compound);
    }
    
    /**
     * Wraps the given OutputStream in a GZIPOutputStream and writes the TagCompound's data.
     * @param tag
     * @param out
     * @throws IOException 
     */
    @Unstable
    public static void writeToCompressed(TagCompound tag, OutputStream out) throws IOException {
        NBTTagCompound compound = tag.getHandle();
        //net.minecraft.server.v1_8_R3.NBTCompressedStreamTools
        //public static void a(NBTTagCompound nbttagcompound, OutputStream outputstream) throws IOException
        NBTCompressedStreamTools.a(compound, out);
    }
    
    /**
     * Writes the given tag to the DataOutput stream.
     * @param tag
     * @param out
     * @throws IOException 
     */
    @Unstable
    public static void write(TagCompound tag, DataOutput out) throws IOException {
        //net.minecraft.server.v1_8_R3.NBTCompressedStreamTools
        //public static void a(NBTTagCompound nbttagcompound, DataOutput dataoutput) throws IOException
        NBTCompressedStreamTools.a(tag.getHandle(), out);
    }

//   
//
//
//
//
//   
}
