package com.ralitski.mc.bukkit.items;

import com.ralitski.mc.bukkit.util.Messenger;
import com.ralitski.mc.bukkit.util.commands.AnnotationCommandParser;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

/**
 *
 * @author ralitski
 */
public class SpecialItemPlugin extends JavaPlugin {
    
    /*
    TODO:
    -basic commands to create/remove special item data from items
    -commands to rename and duplicate special items
    */
    
    public static final String CONFIG_ITEM_MANAGER = "item-manager";
    
    private static SpecialItemPlugin instance;
    
    public static SpecialItemPlugin getInstance() {
        return instance;
    }
    
    private SpecialItemManager itemManager;
    private Messenger messenger;
    private AnnotationCommandParser commandExecutor;
    
    @Override
    public void onEnable() {
        instance = this;
        
        //Get the FileConfiguration (already loaded (and presumably automatically saved...))
        FileConfiguration config = getConfig();
        
        //Get the configuration section for the SpecialItemManager, then create it
        ConfigurationSection managerConfig = config.getConfigurationSection(CONFIG_ITEM_MANAGER);
        if(managerConfig == null) managerConfig = config.createSection(CONFIG_ITEM_MANAGER);
        itemManager = new SpecialItemManager(this, managerConfig);
        
        this.messenger = new Messenger("Special Items");
        
        commandExecutor = new AnnotationCommandParser("specialitems", messenger);
        commandExecutor.addSections(new SpecialItemCommands(messenger));
        Bukkit.getPluginCommand("specialitems").setExecutor(commandExecutor);
    }

    public Messenger getMessenger() {
        return messenger;
    }

    public AnnotationCommandParser getCommandExecutor() {
        return commandExecutor;
    }
    
    @Override
    public void onDisable() {
        instance = null;
    }
    
    public SpecialItemManager getItemManager() {
        return itemManager;
    }
    
}
