package com.ralitski.mc.bukkit.items;

import com.ralitski.mc.bukkit.nbt.TagCompound;
import org.bukkit.inventory.ItemStack;

/**
 *
 * @author ralitski
 */
public class SpecialItemInstance {

    public static SpecialItemInstance getSpecialItem(ItemStack item) {
        return SpecialItemPlugin.getInstance().getItemManager().getSpecialItem(item);
    }

    public static SpecialItemInstance createSpecialItem(ItemStack item, SpecialItem itemType) {
        return SpecialItemPlugin.getInstance().getItemManager().createSpecialItem(item, itemType);
    }

    private ItemStack item;
    private SpecialItem itemType;
    private TagCompound tag;
    
    //Only called by SpecialItemManager; package-level for safety reasons
    SpecialItemInstance(ItemStack item, SpecialItem itemType, TagCompound tag) {
        this.item = item;
        this.itemType = itemType;
        this.tag = tag;
    }

    /**
     * The special ItemStack that is represented by this SpecialItemInstance.
     * @return The ItemStack that this SpecialItemInstance represents
     */
    public ItemStack getItem() {
        return item;
    }

    /**
     * The type of SpecialItem that this item is.
     * @return The type of SpecialItem that this item is
     */
    public SpecialItem getItemType() {
        return itemType;
    }

    /**
     * A TagCompound that wraps data belonging to the ItemStack represented by this SpecialItemInstance, and can be manipulated.
     * @return A TagCompound that represents mutable data belonging to the special ItemStack represented by this SpecialItemInstance.
     */
    public TagCompound getTag() {
        return tag;
    }

    public TagCompound delete() {
        return SpecialItemPlugin.getInstance().getItemManager().deleteSpecialItem(item);
    }
    
    @Override
    public String toString() {
        return "SpecialItemInstance[type = " + itemType + ", item = " + item + ", tag = " + tag + "]";
    }
}
