package com.ralitski.mc.bukkit.items;

import com.ralitski.mc.bukkit.nbt.TagCompound;
import com.ralitski.util.Reflection;
import net.minecraft.server.v1_8_R3.ItemStack;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;

/**
 *
 * @author ralitski
 */
public class ItemTagHelper {
    
    public static TagCompound getTag(org.bukkit.inventory.ItemStack stack) {
        ItemStack iStack = getItemStack(stack);
        return (iStack != null && iStack.hasTag()) ? new TagCompound(iStack.getTag()) : null;
    }
    
    public static void setTag(org.bukkit.inventory.ItemStack stack, TagCompound tag) {
        ItemStack iStack = getItemStack(stack);
        if(iStack != null) iStack.setTag(tag.getHandle());
    }
    
    public static ItemStack getItemStack(org.bukkit.inventory.ItemStack stack) {
        if(stack instanceof CraftItemStack) {
            CraftItemStack cStack = (CraftItemStack)stack;
            return (ItemStack)Reflection.getFieldValue(cStack, "handle");
        } else return null;
    }
}
