/*
 * Decompiled with CFR 0.152.
 */
package me.kruciial;

import java.io.File;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class stats
extends JavaPlugin
implements Listener {
    private static File p;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        File f = new File("plugins/Stats/stats.yml");
        YamlConfiguration yamlFile = YamlConfiguration.loadConfiguration((File)f);
        try {
            yamlFile.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getConfig().options().copyDefaults(true);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        boolean isNull1;
        String target = null;
        if (args.length >= 1 && args[0] != null) {
            target = args[0];
            isNull1 = false;
        } else {
            isNull1 = true;
        }
        File f = new File("plugins/Stats/stats.yml");
        YamlConfiguration yamlFile = YamlConfiguration.loadConfiguration((File)f);
        if (cmd.getName().equalsIgnoreCase("stats")) {
            if (isNull1 && sender instanceof Player) {
                Player player = (Player)sender;
                stats.checkSelfStats(player, yamlFile);
                return true;
            }
            if (!isNull1 && sender instanceof Player) {
                Player player = (Player)sender;
                stats.checkOtherStats(player, target, yamlFile);
                return true;
            }
            this.getLogger().info("You must be a player to perform this action.");
            return false;
        }
        return false;
    }

    public static void checkSelfStats(Player sender, YamlConfiguration config) {
        if (sender.hasPermission("stats.see.self")) {
            int kills = config.getInt("players." + sender.getName() + ".kills");
            int deaths = config.getInt("players." + sender.getName() + ".deaths");
            int streak = config.getInt("players." + sender.getName() + ".streak");
            boolean kd = false;
            if (deaths > 0 && kills > 0) {
                int kd1 = kills / deaths;
            } else {
                boolean kd1 = false;
            }
            sender.sendMessage("\u00a78\u258f \u00a76Stats \u00a78\u258f \u00a78\u00a7m----------------\u00a78\u258f \u00a7eStats \u00a78\u258f\u00a78\u00a7m----------------");
            sender.sendMessage("\u00a78\u258f \u00a76Stats \u00a78\u258f \u00a73Kills \u00a78\u00bb \u00a7c " + ChatColor.YELLOW + kills);
            sender.sendMessage("\u00a78\u258f \u00a76Stats \u00a78\u258f \u00a73Deaths \u00a78\u00bb \u00a7c " + ChatColor.YELLOW + deaths);
            sender.sendMessage("\u00a78\u258f \u00a76Stats \u00a78\u258f \u00a73Streak \u00a78\u00bb \u00a7c " + ChatColor.YELLOW + streak);
            sender.sendMessage("\u00a78\u258f \u00a76Stats \u00a78\u258f \u00a78\u00a7m--------------------------------------");
        }
    }

    public static void checkOtherStats(Player sender, String target, YamlConfiguration config) {
        if (sender.hasPermission("stats.see.other")) {
            int kills = config.getInt("players." + target + ".kills");
            int deaths = config.getInt("players." + target + ".deaths");
            int streak = config.getInt("players." + target + ".streak");
            boolean kd = false;
            if (deaths > 0 && kills > 0) {
                int kd1 = kills / deaths;
            } else {
                boolean kd1 = false;
            }
            sender.sendMessage("\u00a78\u258f \u00a76Stats \u00a78\u258f \u00a78\u00a7m----------------\u00a78\u258f \u00a7eStats \u00a78\u258f\u00a78\u00a7m----------------");
            sender.sendMessage("\u00a78\u258f \u00a76Stats \u00a78\u258f \u00a73Kills \u00a78\u00bb \u00a7e " + ChatColor.YELLOW + kills);
            sender.sendMessage("\u00a78\u258f \u00a76Stats \u00a78\u258f \u00a73Deaths \u00a78\u00bb \u00a7e " + ChatColor.YELLOW + deaths);
            sender.sendMessage("\u00a78\u258f \u00a76Stats \u00a78\u258f \u00a73Streak \u00a78\u00bb \u00a7e " + ChatColor.YELLOW + streak);
            sender.sendMessage("\u00a78\u258f \u00a76Stats \u00a78\u258f \u00a78\u00a7m--------------------------------------");
        }
    }

    @EventHandler
    public void playerKill(EntityDeathEvent evt) {
        this.getLogger().info("Registered entity death");
        File f = new File("plugins/Stats/stats.yml");
        YamlConfiguration yamlFile = YamlConfiguration.loadConfiguration((File)f);
        if (evt instanceof PlayerDeathEvent) {
            this.getLogger().info("Recognised player death");
            PlayerDeathEvent event = (PlayerDeathEvent)evt;
            Player dead = event.getEntity();
            Player killer = dead.getKiller();
            this.getLogger().info("Dead: " + dead.getDisplayName());
            int deaths = yamlFile.getInt("players." + dead.getName() + ".deaths");
            int newDeaths = deaths + 1;
            yamlFile.set("players." + dead.getName() + ".deaths", (Object)newDeaths);
            yamlFile.set("players." + dead.getName() + ".streak", (Object)0);
            if (killer instanceof Player) {
                this.getLogger().info("Killer recognised as a player.");
                Player murderer = killer;
                this.getLogger().info("Killer: " + murderer.getName());
                int kills = yamlFile.getInt("players." + murderer.getName() + ".kills");
                int streak = yamlFile.getInt("players." + murderer.getName() + ".streak");
                int newKills = kills + 1;
                int newStreak = streak + 1;
                yamlFile.set("players." + murderer.getName() + ".streak", (Object)newStreak);
                yamlFile.set("players." + murderer.getName() + ".kills", (Object)newKills);
            }
            try {
                yamlFile.save(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getLogger().info("Set and saved stats.");
        }
    }
}

