/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogHandler
extends Handler {
    private static final DateFormat format = DateFormat.getInstance();
    private final boolean debugToFile;
    private File log;

    public LogHandler(boolean debugToFile) {
        this.debugToFile = debugToFile;
        if (this.debugToFile) {
            this.log = new File("teamspeak.log");
            if (!this.log.exists()) {
                try {
                    this.log.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < Level.WARNING.intValue()) {
            System.out.println("[DEBUG] " + record.getMessage());
        } else {
            System.err.println("[DEBUG] [" + record.getLevel() + "] " + record.getMessage());
        }
        if (this.debugToFile) {
            try {
                Throwable throwable = null;
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.log, true)));){
                    try {
                        out.println("[" + format.format(new Date()) + "][" + record.getLevel() + "] " + record.getMessage());
                    }
                    catch (Throwable var4_6) {
                        throwable = var4_6;
                        throw var4_6;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

