/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.commands;

import com.github.theholywaffle.teamspeak3.api.wrapper.QueryError;
import com.github.theholywaffle.teamspeak3.api.wrapper.Wrapper;
import com.github.theholywaffle.teamspeak3.commands.parameter.Parameter;
import com.github.theholywaffle.teamspeak3.commands.response.DefaultArrayResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Command {
    private final String command;
    private boolean sent = false;
    private boolean answered = false;
    private DefaultArrayResponse response;
    private QueryError error;
    private final ArrayList<Parameter> params = new ArrayList();
    private String raw;

    public Command(String command) {
        this.command = command;
    }

    protected void add(Parameter p) {
        this.params.add(p);
    }

    public void feed(String str) {
        this.raw = str;
        if (this.response == null) {
            this.response = new DefaultArrayResponse(str);
        }
    }

    public void feedError(String err) {
        if (this.error == null) {
            this.error = new QueryError(new DefaultArrayResponse(err).getArray().get(0));
        }
    }

    public QueryError getError() {
        return this.error;
    }

    public String getName() {
        return this.command;
    }

    public Wrapper getFirstResponse() {
        List<HashMap<String, String>> resp = this.getResponse();
        if (resp.size() > 0) {
            return new Wrapper(resp.get(0));
        }
        return new Wrapper(new HashMap<String, String>());
    }

    public List<HashMap<String, String>> getResponse() {
        if (this.response == null) {
            return new DefaultArrayResponse("").getArray();
        }
        return this.response.getArray();
    }

    public boolean isAnswered() {
        return this.answered;
    }

    public boolean isSent() {
        return this.sent;
    }

    public void setAnswered() {
        this.answered = true;
    }

    public void setSent() {
        this.sent = true;
    }

    public String toString() {
        String str = this.command;
        for (Parameter p : this.params) {
            str = String.valueOf(str) + " " + p;
        }
        return str;
    }

    public String getRaw() {
        return this.raw;
    }
}

