/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api.wrapper;

import com.github.theholywaffle.teamspeak3.StringUtil;
import com.github.theholywaffle.teamspeak3.api.ClientProperty;
import com.github.theholywaffle.teamspeak3.api.wrapper.Wrapper;
import java.util.Date;
import java.util.HashMap;

public class ClientInfo
extends Wrapper {
    public ClientInfo(HashMap<String, String> map) {
        super(map);
    }

    public boolean canTalk() {
        return this.getBoolean(ClientProperty.CLIENT_IS_TALKER);
    }

    public String getAvatar() {
        return this.get(ClientProperty.CLIENT_FLAG_AVATAR);
    }

    public String getAwayMessage() {
        return this.get(ClientProperty.CLIENT_AWAY_MESSAGE);
    }

    public long getBandwidthReceivedLastMinute() {
        return this.getLong(ClientProperty.CONNECTION_BANDWIDTH_RECEIVED_LAST_MINUTE_TOTAL);
    }

    public long getBandwidthReceivedLastSecond() {
        return this.getLong(ClientProperty.CONNECTION_BANDWIDTH_RECEIVED_LAST_SECOND_TOTAL);
    }

    public long getBandwidthSentlastMinute() {
        return this.getLong(ClientProperty.CONNECTION_BANDWIDTH_SENT_LAST_MINUTE_TOTAL);
    }

    public long getBandwidthSentLastSecond() {
        return this.getLong(ClientProperty.CONNECTION_BANDWIDTH_SENT_LAST_SECOND_TOTAL);
    }

    public String getBase64ClientUId() {
        return this.get("client_base64HashClientUID");
    }

    public int getChannelGroupId() {
        return this.getInt(ClientProperty.CLIENT_CHANNEL_GROUP_ID);
    }

    public int getChannelGroupInheritedChannelId() {
        return this.getInt(ClientProperty.CLIENT_CHANNEL_GROUP_INHERITED_CHANNEL_ID);
    }

    public int getChannelId() {
        return this.getInt(ClientProperty.CID);
    }

    public String getCountry() {
        return this.get(ClientProperty.CLIENT_COUNTRY);
    }

    public Date getCreatedDate() {
        return new Date(this.getLong(ClientProperty.CLIENT_CREATED) * 1000L);
    }

    public int getDatabaseId() {
        return this.getInt(ClientProperty.CLIENT_DATABASE_ID);
    }

    public int getDefaultChannel() {
        return StringUtil.getInt(this.get(ClientProperty.CLIENT_DEFAULT_CHANNEL).substring(1));
    }

    public String getDefaultToken() {
        return this.get(ClientProperty.CLIENT_DEFAULT_TOKEN);
    }

    public String getDescription() {
        return this.get(ClientProperty.CLIENT_DESCRIPTION);
    }

    public long getFiletransferBandwidthReceived() {
        return this.getLong(ClientProperty.CONNECTION_FILETRANSFER_BANDWIDTH_RECEIVED);
    }

    public long getFiletransferBandwidthSent() {
        return this.getLong(ClientProperty.CONNECTION_FILETRANSFER_BANDWIDTH_SENT);
    }

    public long getIconId() {
        return this.getLong(ClientProperty.CLIENT_ICON_ID);
    }

    public long getIdleTime() {
        return this.getLong(ClientProperty.CLIENT_IDLE_TIME);
    }

    public String getIp() {
        return this.get(ClientProperty.CONNECTION_CLIENT_IP);
    }

    public Date getLastConnectedDate() {
        return new Date(this.getLong(ClientProperty.CLIENT_LASTCONNECTED) * 1000L);
    }

    public String getLoginName() {
        return this.get(ClientProperty.CLIENT_LOGIN_NAME);
    }

    public String getMetaData() {
        return this.get(ClientProperty.CLIENT_META_DATA);
    }

    public long getMonthlyBytesDownloaded() {
        return this.getLong(ClientProperty.CLIENT_MONTH_BYTES_DOWNLOADED);
    }

    public long getMonthlyBytesUploaded() {
        return this.getLong(ClientProperty.CLIENT_MONTH_BYTES_UPLOADED);
    }

    public int getNeededServerQueryViewPower() {
        return this.getInt(ClientProperty.CLIENT_NEEDED_SERVERQUERY_VIEW_POWER);
    }

    public String getNickname() {
        return this.get(ClientProperty.CLIENT_NICKNAME);
    }

    public String getPhoneticNickname() {
        return this.get(ClientProperty.CLIENT_NICKNAME_PHONETIC);
    }

    public String getPlatform() {
        return this.get(ClientProperty.CLIENT_PLATFORM);
    }

    public int[] getServerGroups() {
        String str = this.get(ClientProperty.CLIENT_SERVERGROUPS);
        String[] arr = str.split(",");
        int[] groups = new int[arr.length];
        int i = 0;
        while (i < groups.length) {
            groups[i] = StringUtil.getInt(arr[i]);
            ++i;
        }
        return groups;
    }

    public int getTalkPower() {
        return this.getInt(ClientProperty.CLIENT_TALK_POWER);
    }

    public String getTalkRequestMessage() {
        return this.get(ClientProperty.CLIENT_TALK_REQUEST_MSG);
    }

    public long getTimeConnected() {
        return this.getLong(ClientProperty.CONNECTION_CONNECTED_TIME);
    }

    public long getTotalBytesDownloaded() {
        return this.getLong(ClientProperty.CLIENT_TOTAL_BYTES_DOWNLOADED);
    }

    public long getTotalBytesReceived() {
        return this.getLong(ClientProperty.CONNECTION_BYTES_RECEIVED_TOTAL);
    }

    public long getTotalBytesSent() {
        return this.getLong(ClientProperty.CONNECTION_BYTES_SENT_TOTAL);
    }

    public long getTotalBytesUploaded() {
        return this.getLong(ClientProperty.CLIENT_TOTAL_BYTES_UPLOADED);
    }

    public int getTotalConnections() {
        return this.getInt(ClientProperty.CLIENT_TOTALCONNECTIONS);
    }

    public long getTotalPacketsReceived() {
        return this.getLong(ClientProperty.CONNECTION_PACKETS_RECEIVED_TOTAL);
    }

    public long getTotalPacketsSent() {
        return this.getLong(ClientProperty.CONNECTION_PACKETS_SENT_TOTAL);
    }

    public int getType() {
        return this.getInt(ClientProperty.CLIENT_TYPE);
    }

    public String getUniqueIdentifier() {
        return this.get(ClientProperty.CLIENT_UNIQUE_IDENTIFIER);
    }

    public int getUnreadMessages() {
        return this.getInt(ClientProperty.CLIENT_UNREAD_MESSAGES);
    }

    public String getVersion() {
        return this.get(ClientProperty.CLIENT_VERSION);
    }

    public boolean isAway() {
        return this.getBoolean(ClientProperty.CLIENT_AWAY);
    }

    public boolean isChannelCommander() {
        return this.getBoolean(ClientProperty.CLIENT_IS_CHANNEL_COMMANDER);
    }

    public boolean isInputHardware() {
        return this.getBoolean(ClientProperty.CLIENT_INPUT_HARDWARE);
    }

    public boolean isInputMuted() {
        return this.getBoolean(ClientProperty.CLIENT_INPUT_MUTED);
    }

    public boolean isOutputHardware() {
        return this.getBoolean(ClientProperty.CLIENT_OUTPUT_HARDWARE);
    }

    public boolean isOutputMuted() {
        return this.getBoolean(ClientProperty.CLIENT_OUTPUT_MUTED);
    }

    public boolean isOutputOnlyMuted() {
        return this.getBoolean(ClientProperty.CLIENT_OUTPUTONLY_MUTED);
    }

    public boolean isPrioritySpeaker() {
        return this.getBoolean(ClientProperty.CLIENT_IS_PRIORITY_SPEAKER);
    }

    public boolean isRecording() {
        return this.getBoolean(ClientProperty.CLIENT_IS_RECORDING);
    }

    public boolean isRequestingToTalk() {
        return this.getBoolean(ClientProperty.CLIENT_TALK_REQUEST);
    }
}

