/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.EventManager;
import com.github.theholywaffle.teamspeak3.KeepAliveThread;
import com.github.theholywaffle.teamspeak3.SocketReader;
import com.github.theholywaffle.teamspeak3.SocketWriter;
import com.github.theholywaffle.teamspeak3.TS3Api;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.api.Callback;
import com.github.theholywaffle.teamspeak3.api.exception.TS3CommandFailedException;
import com.github.theholywaffle.teamspeak3.api.exception.TS3ConnectionFailedException;
import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.log.LogHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class TS3Query {
    private Socket socket;
    private PrintStream out;
    private BufferedReader in;
    private SocketReader socketReader;
    private SocketWriter socketWriter;
    private KeepAliveThread keepAlive;
    private ConcurrentLinkedQueue<Command> commandList = new ConcurrentLinkedQueue();
    private final EventManager eventManager = new EventManager();
    private TS3Api api;
    private final TS3Config config;
    public static final Logger log = Logger.getLogger(TS3Query.class.getName());

    public TS3Query(TS3Config config) {
        log.setUseParentHandlers(false);
        log.addHandler(new LogHandler(config.getDebugToFile()));
        log.setLevel(config.getDebugLevel());
        this.config = config;
    }

    public TS3Query connect() {
        try {
            this.socket = new Socket(this.config.getHost(), this.config.getQueryPort());
            if (this.socket.isConnected()) {
                this.out = new PrintStream(this.socket.getOutputStream(), true, "UTF-8");
                this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.socketReader = new SocketReader(this);
                this.socketReader.start();
                this.socketWriter = new SocketWriter(this, this.config.getFloodRate().getMs());
                this.socketWriter.start();
                this.keepAlive = new KeepAliveThread(this, this.socketWriter);
                this.keepAlive.start();
            }
        }
        catch (IOException e) {
            throw new TS3ConnectionFailedException(e);
        }
        TS3Api api = this.getApi();
        if (this.config.getUsername() != null && this.config.getPassword() != null) {
            api.login(this.config.getUsername(), this.config.getPassword());
        }
        return this;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public BufferedReader getIn() {
        return this.in;
    }

    public boolean doCommand(Command c) {
        this.commandList.offer(c);
        long start = System.currentTimeMillis();
        while (!c.isAnswered() && System.currentTimeMillis() - start < 4000L) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new TS3CommandFailedException(e);
            }
        }
        if (!c.isAnswered()) {
            log.severe("Command " + c.getName() + " is not answered in time.");
            this.commandList.remove(c);
            return false;
        }
        return true;
    }

    public void doCommandAsync(Command c) {
        this.doCommandAsync(c, null);
    }

    public void doCommandAsync(final Command c, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TS3Query.this.doCommand(c);
                if (callback != null) {
                    callback.handle();
                }
            }
        }).start();
    }

    public void exit() {
        if (this.out != null) {
            this.out.close();
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            if (this.socketReader != null) {
                this.socketReader.finish();
                this.socketReader.join();
            }
            if (this.socketWriter != null) {
                this.socketWriter.finish();
                this.socketWriter.join();
            }
            if (this.keepAlive != null) {
                this.keepAlive.finish();
                this.keepAlive.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.commandList.clear();
        this.commandList = null;
        Handler[] handlerArray = log.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler lh = handlerArray[n2];
            log.removeHandler(lh);
            ++n2;
        }
    }

    public ConcurrentLinkedQueue<Command> getCommandList() {
        return this.commandList;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public TS3Api getApi() {
        if (this.api == null) {
            this.api = new TS3Api(this);
        }
        return this.api;
    }

    public static enum FloodRate {
        DEFAULT(350),
        UNLIMITED(0);

        private int ms;

        private FloodRate(int ms) {
            this.ms = ms;
        }

        public int getMs() {
            return this.ms;
        }
    }
}

