/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.StringUtil;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.ChannelProperty;
import com.github.theholywaffle.teamspeak3.api.ClientProperty;
import com.github.theholywaffle.teamspeak3.api.PermissionGroupDatabaseType;
import com.github.theholywaffle.teamspeak3.api.ReasonIdentifier;
import com.github.theholywaffle.teamspeak3.api.ServerGroupType;
import com.github.theholywaffle.teamspeak3.api.ServerInstanceProperty;
import com.github.theholywaffle.teamspeak3.api.Snapshot;
import com.github.theholywaffle.teamspeak3.api.TextMessageTargetMode;
import com.github.theholywaffle.teamspeak3.api.VirtualServerProperty;
import com.github.theholywaffle.teamspeak3.api.event.TS3EventType;
import com.github.theholywaffle.teamspeak3.api.event.TS3Listener;
import com.github.theholywaffle.teamspeak3.api.wrapper.AdvancedPermission;
import com.github.theholywaffle.teamspeak3.api.wrapper.Ban;
import com.github.theholywaffle.teamspeak3.api.wrapper.Binding;
import com.github.theholywaffle.teamspeak3.api.wrapper.Channel;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelGroup;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelGroupClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Client;
import com.github.theholywaffle.teamspeak3.api.wrapper.ClientInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Complaint;
import com.github.theholywaffle.teamspeak3.api.wrapper.ConnectionInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.DatabaseClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.DatabaseClientInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.HostInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.InstanceInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Message;
import com.github.theholywaffle.teamspeak3.api.wrapper.Permission;
import com.github.theholywaffle.teamspeak3.api.wrapper.PermissionInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.PrivilegeKey;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerGroup;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerGroupClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerQueryInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Version;
import com.github.theholywaffle.teamspeak3.api.wrapper.VirtualServer;
import com.github.theholywaffle.teamspeak3.api.wrapper.VirtualServerInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Wrapper;
import com.github.theholywaffle.teamspeak3.commands.CBanAdd;
import com.github.theholywaffle.teamspeak3.commands.CBanClient;
import com.github.theholywaffle.teamspeak3.commands.CBanDel;
import com.github.theholywaffle.teamspeak3.commands.CBanDelAll;
import com.github.theholywaffle.teamspeak3.commands.CBanList;
import com.github.theholywaffle.teamspeak3.commands.CBindingList;
import com.github.theholywaffle.teamspeak3.commands.CChannelAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelClientAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelClientDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelClientPermList;
import com.github.theholywaffle.teamspeak3.commands.CChannelCreate;
import com.github.theholywaffle.teamspeak3.commands.CChannelDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelDelete;
import com.github.theholywaffle.teamspeak3.commands.CChannelEdit;
import com.github.theholywaffle.teamspeak3.commands.CChannelFind;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupAdd;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupClientList;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupCopy;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupDel;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupList;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupPermList;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupRename;
import com.github.theholywaffle.teamspeak3.commands.CChannelInfo;
import com.github.theholywaffle.teamspeak3.commands.CChannelList;
import com.github.theholywaffle.teamspeak3.commands.CChannelMove;
import com.github.theholywaffle.teamspeak3.commands.CChannelPermList;
import com.github.theholywaffle.teamspeak3.commands.CClientAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CClientDBDelelete;
import com.github.theholywaffle.teamspeak3.commands.CClientDBEdit;
import com.github.theholywaffle.teamspeak3.commands.CClientDBFind;
import com.github.theholywaffle.teamspeak3.commands.CClientDBInfo;
import com.github.theholywaffle.teamspeak3.commands.CClientDBList;
import com.github.theholywaffle.teamspeak3.commands.CClientDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CClientEdit;
import com.github.theholywaffle.teamspeak3.commands.CClientFind;
import com.github.theholywaffle.teamspeak3.commands.CClientGetDBIdFromUId;
import com.github.theholywaffle.teamspeak3.commands.CClientGetIds;
import com.github.theholywaffle.teamspeak3.commands.CClientInfo;
import com.github.theholywaffle.teamspeak3.commands.CClientKick;
import com.github.theholywaffle.teamspeak3.commands.CClientList;
import com.github.theholywaffle.teamspeak3.commands.CClientMove;
import com.github.theholywaffle.teamspeak3.commands.CClientPermList;
import com.github.theholywaffle.teamspeak3.commands.CClientPoke;
import com.github.theholywaffle.teamspeak3.commands.CClientSetServerQueryLogin;
import com.github.theholywaffle.teamspeak3.commands.CClientUpdate;
import com.github.theholywaffle.teamspeak3.commands.CComplainAdd;
import com.github.theholywaffle.teamspeak3.commands.CComplainDel;
import com.github.theholywaffle.teamspeak3.commands.CComplainDelAll;
import com.github.theholywaffle.teamspeak3.commands.CComplainList;
import com.github.theholywaffle.teamspeak3.commands.CGM;
import com.github.theholywaffle.teamspeak3.commands.CHostInfo;
import com.github.theholywaffle.teamspeak3.commands.CInstanceEdit;
import com.github.theholywaffle.teamspeak3.commands.CInstanceInfo;
import com.github.theholywaffle.teamspeak3.commands.CLogin;
import com.github.theholywaffle.teamspeak3.commands.CLogout;
import com.github.theholywaffle.teamspeak3.commands.CMessageAdd;
import com.github.theholywaffle.teamspeak3.commands.CMessageDel;
import com.github.theholywaffle.teamspeak3.commands.CMessageGet;
import com.github.theholywaffle.teamspeak3.commands.CMessageList;
import com.github.theholywaffle.teamspeak3.commands.CMessageUpdateFlag;
import com.github.theholywaffle.teamspeak3.commands.CPermFind;
import com.github.theholywaffle.teamspeak3.commands.CPermGet;
import com.github.theholywaffle.teamspeak3.commands.CPermIdGetByName;
import com.github.theholywaffle.teamspeak3.commands.CPermOverview;
import com.github.theholywaffle.teamspeak3.commands.CPermReset;
import com.github.theholywaffle.teamspeak3.commands.CPermissionList;
import com.github.theholywaffle.teamspeak3.commands.CPrivilegeKeyAdd;
import com.github.theholywaffle.teamspeak3.commands.CPrivilegeKeyDelete;
import com.github.theholywaffle.teamspeak3.commands.CPrivilegeKeyList;
import com.github.theholywaffle.teamspeak3.commands.CPrivilegeKeyUse;
import com.github.theholywaffle.teamspeak3.commands.CQuit;
import com.github.theholywaffle.teamspeak3.commands.CSendTextMessage;
import com.github.theholywaffle.teamspeak3.commands.CServerCreate;
import com.github.theholywaffle.teamspeak3.commands.CServerDelete;
import com.github.theholywaffle.teamspeak3.commands.CServerEdit;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupAdd;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupAddClient;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupAutoAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupAutoDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupClientList;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupCopy;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupDel;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupDelClient;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupList;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupPermList;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupRename;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupsByClientId;
import com.github.theholywaffle.teamspeak3.commands.CServerIdGetByPort;
import com.github.theholywaffle.teamspeak3.commands.CServerInfo;
import com.github.theholywaffle.teamspeak3.commands.CServerList;
import com.github.theholywaffle.teamspeak3.commands.CServerNotifyRegister;
import com.github.theholywaffle.teamspeak3.commands.CServerNotifyUnregister;
import com.github.theholywaffle.teamspeak3.commands.CServerProcessStop;
import com.github.theholywaffle.teamspeak3.commands.CServerRequestConnectionInfo;
import com.github.theholywaffle.teamspeak3.commands.CServerSnapshotCreate;
import com.github.theholywaffle.teamspeak3.commands.CServerSnapshotDeploy;
import com.github.theholywaffle.teamspeak3.commands.CServerStart;
import com.github.theholywaffle.teamspeak3.commands.CServerStop;
import com.github.theholywaffle.teamspeak3.commands.CSetClientChannelGroup;
import com.github.theholywaffle.teamspeak3.commands.CUse;
import com.github.theholywaffle.teamspeak3.commands.CVersion;
import com.github.theholywaffle.teamspeak3.commands.CWhoAmI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TS3Api {
    private final TS3Query query;

    public TS3Api(TS3Query query) {
        this.query = query;
    }

    public int addBan(String ip, String name, String uid, long timeInSeconds, String reason) {
        CBanAdd add = new CBanAdd(ip, name, uid, timeInSeconds, reason);
        if (this.query.doCommand(add)) {
            return StringUtil.getInt(add.getFirstResponse().get("banid"));
        }
        return -1;
    }

    public boolean addChannelClientPermission(int channelId, int clientDBId, String permName, int permValue) {
        CChannelClientAddPerm add = new CChannelClientAddPerm(channelId, clientDBId, permName, permValue);
        if (this.query.doCommand(add)) {
            return add.getError().isSuccessful();
        }
        return false;
    }

    public int addChannelGroup(String name) {
        return this.addChannelGroup(name, null);
    }

    public int addChannelGroup(String name, PermissionGroupDatabaseType t) {
        CChannelGroupAdd add = new CChannelGroupAdd(name, t);
        if (this.query.doCommand(add)) {
            return StringUtil.getInt(add.getFirstResponse().get("cgid"));
        }
        return -1;
    }

    public boolean addChannelPermission(int channelId, String permName, int permValue) {
        CChannelAddPerm perm = new CChannelAddPerm(channelId, permName, permValue);
        if (this.query.doCommand(perm)) {
            return perm.getError().isSuccessful();
        }
        return false;
    }

    public boolean addClientPermission(int clientDBId, String permName, int permValue, boolean permSkipped) {
        CClientAddPerm add = new CClientAddPerm(clientDBId, permName, permValue, permSkipped);
        if (this.query.doCommand(add)) {
            return add.getError().isSuccessful();
        }
        return false;
    }

    public boolean addClientToServerGroup(int groupId, int clientDatabaseId) {
        CServerGroupAddClient add = new CServerGroupAddClient(groupId, clientDatabaseId);
        if (this.query.doCommand(add)) {
            return add.getError().isSuccessful();
        }
        return false;
    }

    public boolean addComplain(int clientDBId, String text) {
        CComplainAdd add = new CComplainAdd(clientDBId, text);
        if (this.query.doCommand(add)) {
            return add.getError().isSuccessful();
        }
        return false;
    }

    public boolean addPermissionToAllServerGroups(ServerGroupType t, String permName, int permValue, boolean permNegated, boolean permSkipped) {
        CServerGroupAutoAddPerm add = new CServerGroupAutoAddPerm(t, permName, permValue, permNegated, permSkipped);
        if (this.query.doCommand(add)) {
            return add.getError().isSuccessful();
        }
        return false;
    }

    public boolean addPermissionToChannelGroup(int groupId, String permName, int permValue) {
        CChannelGroupAddPerm add = new CChannelGroupAddPerm(groupId, permName, permValue);
        if (this.query.doCommand(add)) {
            return add.getError().isSuccessful();
        }
        return false;
    }

    public String addPrivilegeKey(int type, int groupId, int channelId, String description) {
        CPrivilegeKeyAdd add = new CPrivilegeKeyAdd(type, groupId, channelId, description);
        if (this.query.doCommand(add)) {
            return add.getFirstResponse().get("token");
        }
        return null;
    }

    public String addPrivilegeKeyChannelGroup(int channelGroupId, int channelId, String description) {
        return this.addPrivilegeKey(1, channelGroupId, channelId, description);
    }

    public String addPrivilegeKeyServerGroup(int serverGroupId, String description) {
        return this.addPrivilegeKey(0, serverGroupId, 0, description);
    }

    public int addServerGroup(String name) {
        return this.addServerGroup(name, PermissionGroupDatabaseType.REGULAR);
    }

    public int addServerGroup(String name, PermissionGroupDatabaseType t) {
        CServerGroupAdd add = new CServerGroupAdd(name, t);
        if (this.query.doCommand(add)) {
            return StringUtil.getInt(add.getFirstResponse().get("sgid"));
        }
        return -1;
    }

    public boolean addServerGroupPermission(int groupId, String permName, int value, boolean negated, boolean skipped) {
        CServerGroupAddPerm add = new CServerGroupAddPerm(groupId, permName, value, negated, skipped);
        if (this.query.doCommand(add)) {
            return add.getError().isSuccessful();
        }
        return false;
    }

    public void addTS3Listeners(TS3Listener ... l) {
        this.query.getEventManager().addListeners(l);
    }

    public int banClient(int clientId, long timeInSeconds) {
        return this.banClient(clientId, timeInSeconds, null);
    }

    public int banClient(int clientId, long timeInSeconds, String reason) {
        CBanClient client = new CBanClient(clientId, timeInSeconds, reason);
        if (this.query.doCommand(client)) {
            return StringUtil.getInt(client.getFirstResponse().get("banid"));
        }
        return -1;
    }

    public int banClient(int clientId, String reason) {
        return this.banClient(clientId, reason);
    }

    public boolean broadcast(String message) {
        CGM broadcast = new CGM(message);
        if (this.query.doCommand(broadcast)) {
            return broadcast.getError().isSuccessful();
        }
        return false;
    }

    public boolean copyChannelGroup(int sourceGroupId, int targetGroupId, PermissionGroupDatabaseType t) {
        CChannelGroupCopy copy = new CChannelGroupCopy(sourceGroupId, targetGroupId, t);
        if (this.query.doCommand(copy)) {
            return copy.getError().isSuccessful();
        }
        return false;
    }

    public int copyChannelGroup(int sourceGroupId, String targetName, PermissionGroupDatabaseType t) {
        CChannelGroupCopy copy = new CChannelGroupCopy(sourceGroupId, targetName, t);
        if (this.query.doCommand(copy)) {
            return StringUtil.getInt(copy.getFirstResponse().get("cgid"));
        }
        return -1;
    }

    public int copyServerGroup(int idSource, int idTarget, PermissionGroupDatabaseType t) {
        return this.copyServerGroup(idSource, idTarget, "ignored", t);
    }

    private int copyServerGroup(int idSource, int idTarget, String name, PermissionGroupDatabaseType t) {
        CServerGroupCopy copy = new CServerGroupCopy(idSource, idTarget, name, t);
        if (this.query.doCommand(copy)) {
            return StringUtil.getInt(copy.getFirstResponse().get("sgid"));
        }
        return -1;
    }

    public int copyServerGroup(int idSource, String name, PermissionGroupDatabaseType t) {
        return this.copyServerGroup(idSource, 0, name, t);
    }

    public int createChannel(String name, HashMap<ChannelProperty, String> options) {
        CChannelCreate create = new CChannelCreate(name, options);
        if (this.query.doCommand(create)) {
            return StringUtil.getInt(create.getFirstResponse().get("cid"));
        }
        return -1;
    }

    public boolean createServer(String name, HashMap<VirtualServerProperty, String> map) {
        CServerCreate create = new CServerCreate(name, map);
        if (this.query.doCommand(create)) {
            return create.getError().isSuccessful();
        }
        return false;
    }

    public String createServerQueryLogin(String name) {
        CClientSetServerQueryLogin login = new CClientSetServerQueryLogin(name);
        if (this.query.doCommand(login)) {
            return login.getFirstResponse().get("client_login_password");
        }
        return null;
    }

    public Snapshot createServerSnapshot() {
        CServerSnapshotCreate create = new CServerSnapshotCreate();
        if (this.query.doCommand(create)) {
            return new Snapshot(create.getRaw());
        }
        return null;
    }

    public boolean deleteAllBans() {
        CBanDelAll del = new CBanDelAll();
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteAllComplaints(int clientDBId) {
        CComplainDelAll del = new CComplainDelAll(clientDBId);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteBan(int banId) {
        CBanDel del = new CBanDel(banId);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteChannel(int channelId) {
        CChannelDelete del = new CChannelDelete(channelId, true);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteChannelClientPermission(int channelId, int clientDBId, String permName) {
        CChannelClientDelPerm del = new CChannelClientDelPerm(channelId, clientDBId, permName);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteChannelGroup(int groupId) {
        CChannelGroupDel del = new CChannelGroupDel(groupId, true);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteChannelGroupPermission(int groupId, String permName) {
        CChannelGroupDelPerm del = new CChannelGroupDelPerm(groupId, permName);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteChannelPermission(int channelId, String permName) {
        CChannelDelPerm del = new CChannelDelPerm(channelId, permName);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteClientPermission(int clientDBId, String permName) {
        CClientDelPerm del = new CClientDelPerm(clientDBId, permName);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteComplaint(int targetClientDBId, int fromClientDBId) {
        CComplainDel del = new CComplainDel(targetClientDBId, fromClientDBId);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteDatabaseClientProperties(int clientDBId) {
        CClientDBDelelete del = new CClientDBDelelete(clientDBId);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteOfflineMessage(int messageId) {
        CMessageDel del = new CMessageDel(messageId);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deletePermissionFromAllServerGroups(ServerGroupType t, String permName) {
        CServerGroupAutoDelPerm del = new CServerGroupAutoDelPerm(t, permName);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deletePrivilegeKey(String token) {
        CPrivilegeKeyDelete del = new CPrivilegeKeyDelete(token);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteServer(int id) {
        CServerDelete delete = new CServerDelete(id);
        if (this.query.doCommand(delete)) {
            return delete.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteServerGroup(int id) {
        return this.deleteServerGroup(id, true);
    }

    public boolean deleteServerGroup(int id, boolean forced) {
        CServerGroupDel del = new CServerGroupDel(id, forced);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deleteServerGroupPermission(int groupId, String permName) {
        CServerGroupDelPerm del = new CServerGroupDelPerm(groupId, permName);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public boolean deployServerSnapshot(Snapshot snapshot) {
        CServerSnapshotDeploy deploy = new CServerSnapshotDeploy(snapshot.get());
        if (this.query.doCommand(deploy)) {
            return deploy.getError().isSuccessful();
        }
        return false;
    }

    public boolean editChannel(int channelId, HashMap<ChannelProperty, String> options) {
        CChannelEdit edit = new CChannelEdit(channelId, options);
        if (this.query.doCommand(edit)) {
            return edit.getError().isSuccessful();
        }
        return false;
    }

    public void editClient(int clientId, HashMap<ClientProperty, String> options) {
        CClientEdit edit = new CClientEdit(clientId, options);
        this.query.doCommand(edit);
    }

    public boolean editDatabaseClient(int clientDBId, HashMap<ClientProperty, String> options) {
        CClientDBEdit edit = new CClientDBEdit(clientDBId, options);
        if (this.query.doCommand(edit)) {
            return edit.getError().isSuccessful();
        }
        return false;
    }

    public boolean editInstance(ServerInstanceProperty p, String value) {
        CInstanceEdit edit;
        if (p.isChangeable() && this.query.doCommand(edit = new CInstanceEdit(p, value))) {
            return edit.getError().isSuccessful();
        }
        return false;
    }

    public boolean editServer(HashMap<VirtualServerProperty, String> map) {
        CServerEdit edit = new CServerEdit(map);
        if (this.query.doCommand(edit)) {
            return edit.getError().isSuccessful();
        }
        return false;
    }

    public List<Ban> getBans() {
        CBanList list = new CBanList();
        if (this.query.doCommand(list)) {
            ArrayList<Ban> bans = new ArrayList<Ban>();
            for (HashMap<String, String> opt : list.getResponse()) {
                bans.add(new Ban(opt));
            }
            return bans;
        }
        return null;
    }

    public List<Binding> getBindings() {
        CBindingList list = new CBindingList();
        if (this.query.doCommand(list)) {
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            for (HashMap<String, String> map : list.getResponse()) {
                bindings.add(new Binding(map));
            }
            return bindings;
        }
        return null;
    }

    public Channel getChannelByName(String name) {
        CChannelFind find = new CChannelFind(name);
        if (this.query.doCommand(find)) {
            for (Channel c : this.getChannels()) {
                if (c.getId() != StringUtil.getInt(find.getFirstResponse().get("cid"))) continue;
                return c;
            }
        }
        return null;
    }

    public List<Permission> getChannelClientPermissions(int channelId, int clientDBId) {
        CChannelClientPermList list = new CChannelClientPermList(channelId, clientDBId);
        if (this.query.doCommand(list)) {
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            for (HashMap<String, String> opt : list.getResponse()) {
                permissions.add(new Permission(opt));
            }
            return permissions;
        }
        return null;
    }

    public List<ChannelGroupClient> getChannelGroupClients(int channelId, int clientDBId, int groupId) {
        CChannelGroupClientList list = new CChannelGroupClientList(channelId, clientDBId, groupId);
        if (this.query.doCommand(list)) {
            ArrayList<ChannelGroupClient> clients = new ArrayList<ChannelGroupClient>();
            for (HashMap<String, String> opt : list.getResponse()) {
                clients.add(new ChannelGroupClient(opt));
            }
            return clients;
        }
        return null;
    }

    public List<ChannelGroupClient> getChannelGroupClientsByChannelGroupId(int groupId) {
        return this.getChannelGroupClients(-1, -1, groupId);
    }

    public List<ChannelGroupClient> getChannelGroupClientsByChannelId(int channelId) {
        return this.getChannelGroupClients(channelId, -1, -1);
    }

    public List<ChannelGroupClient> getChannelGroupClientsByClientDBId(int clientDBId) {
        return this.getChannelGroupClients(-1, clientDBId, -1);
    }

    public List<Permission> getChannelGroupPermissions(int groupId) {
        CChannelGroupPermList list = new CChannelGroupPermList(groupId);
        if (this.query.doCommand(list)) {
            ArrayList<Permission> p = new ArrayList<Permission>();
            for (HashMap<String, String> opt : list.getResponse()) {
                p.add(new Permission(opt));
            }
            return p;
        }
        return null;
    }

    public List<ChannelGroup> getChannelGroups() {
        CChannelGroupList list = new CChannelGroupList();
        if (this.query.doCommand(list)) {
            ArrayList<ChannelGroup> groups = new ArrayList<ChannelGroup>();
            for (HashMap<String, String> opt : list.getResponse()) {
                groups.add(new ChannelGroup(opt));
            }
            return groups;
        }
        return null;
    }

    public ChannelInfo getChannelInfo(int channelId) {
        CChannelInfo info = new CChannelInfo(channelId);
        if (this.query.doCommand(info)) {
            return new ChannelInfo(info.getFirstResponse().getMap());
        }
        return null;
    }

    public List<Permission> getChannelPermissions(int channelId) {
        CChannelPermList list = new CChannelPermList(channelId);
        if (this.query.doCommand(list)) {
            ArrayList<Permission> p = new ArrayList<Permission>();
            for (HashMap<String, String> opt : list.getResponse()) {
                p.add(new Permission(opt));
            }
            return p;
        }
        return null;
    }

    public List<Channel> getChannels() {
        CChannelList list = new CChannelList();
        if (this.query.doCommand(list)) {
            ArrayList<Channel> channels = new ArrayList<Channel>();
            for (HashMap<String, String> opt : list.getResponse()) {
                channels.add(new Channel(opt));
            }
            return channels;
        }
        return null;
    }

    public List<Client> getClientByName(String pattern) {
        CClientFind find = new CClientFind(pattern);
        if (this.query.doCommand(find)) {
            ArrayList<Client> clients = new ArrayList<Client>();
            for (Client c : this.getClients()) {
                for (HashMap<String, String> opt : find.getResponse()) {
                    if (c.getId() != StringUtil.getInt(new Wrapper(opt).get("clid"))) continue;
                    clients.add(c);
                }
            }
            return clients;
        }
        return null;
    }

    public ClientInfo getClientByUId(String clientUId) {
        CClientGetIds get = new CClientGetIds(clientUId);
        if (this.query.doCommand(get)) {
            return this.getClientInfo(StringUtil.getInt(get.getFirstResponse().getMap().get("clid")));
        }
        return null;
    }

    public ClientInfo getClientInfo(int clientId) {
        CClientInfo info = new CClientInfo(clientId);
        if (this.query.doCommand(info)) {
            return new ClientInfo(info.getFirstResponse().getMap());
        }
        return null;
    }

    public List<Permission> getClientPermissions(int clientDBId) {
        CClientPermList list = new CClientPermList(clientDBId);
        if (this.query.doCommand(list)) {
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            for (HashMap<String, String> opt : list.getResponse()) {
                permissions.add(new Permission(opt));
            }
            return permissions;
        }
        return null;
    }

    public List<Client> getClients() {
        CClientList list = new CClientList();
        if (this.query.doCommand(list)) {
            ArrayList<Client> clients = new ArrayList<Client>();
            for (HashMap<String, String> opt : list.getResponse()) {
                clients.add(new Client(opt));
            }
            return clients;
        }
        return null;
    }

    public List<Complaint> getComplaints() {
        return this.getComplaints(-1);
    }

    public List<Complaint> getComplaints(int clientDBId) {
        CComplainList list = new CComplainList(clientDBId);
        if (this.query.doCommand(list)) {
            ArrayList<Complaint> complaints = new ArrayList<Complaint>();
            for (HashMap<String, String> opt : list.getResponse()) {
                complaints.add(new Complaint(opt));
            }
            return complaints;
        }
        return null;
    }

    public ConnectionInfo getConnectionInfo() {
        CServerRequestConnectionInfo info = new CServerRequestConnectionInfo();
        if (this.query.doCommand(info)) {
            return new ConnectionInfo(info.getFirstResponse().getMap());
        }
        return null;
    }

    public DatabaseClientInfo getDatabaseClientByName(String name) {
        CClientDBFind find = new CClientDBFind(name, false);
        if (this.query.doCommand(find)) {
            return this.getDatabaseClientInfo(StringUtil.getInt(find.getFirstResponse().get("cldbid")));
        }
        return null;
    }

    public DatabaseClientInfo getDatabaseClientByUId(String clientUId) {
        CClientGetDBIdFromUId get = new CClientGetDBIdFromUId(clientUId);
        if (this.query.doCommand(get)) {
            return this.getDatabaseClientInfo(StringUtil.getInt(get.getFirstResponse().get("cldbid")));
        }
        return null;
    }

    public DatabaseClientInfo getDatabaseClientInfo(int clientDBId) {
        CClientDBInfo info = new CClientDBInfo(clientDBId);
        if (this.query.doCommand(info)) {
            return new DatabaseClientInfo(info.getFirstResponse().getMap());
        }
        return null;
    }

    public List<DatabaseClient> getDatabaseClients() {
        CClientDBList countList = new CClientDBList(0, 1, true);
        if (this.query.doCommand(countList)) {
            int count = StringUtil.getInt(countList.getFirstResponse().get("count"));
            ArrayList<DatabaseClient> clients = new ArrayList<DatabaseClient>();
            int i = 0;
            while (i < count) {
                CClientDBList list = new CClientDBList(i, 200, false);
                if (this.query.doCommand(list)) {
                    for (HashMap<String, String> map : list.getResponse()) {
                        clients.add(new DatabaseClient(map));
                    }
                }
                i += 200;
            }
            return clients;
        }
        return null;
    }

    public HostInfo getHostInfo() {
        CHostInfo info = new CHostInfo();
        if (this.query.doCommand(info)) {
            return new HostInfo(info.getFirstResponse().getMap());
        }
        return null;
    }

    public InstanceInfo getInstanceInfo() {
        CInstanceInfo info = new CInstanceInfo();
        if (this.query.doCommand(info)) {
            return new InstanceInfo(info.getFirstResponse().getMap());
        }
        return null;
    }

    public String getOfflineMessage(int messageId) {
        CMessageGet get = new CMessageGet(messageId);
        if (this.query.doCommand(get)) {
            return get.getFirstResponse().get("message");
        }
        return null;
    }

    public List<Message> getOfflineMessages() {
        CMessageList list = new CMessageList();
        if (this.query.doCommand(list)) {
            ArrayList<Message> msg = new ArrayList<Message>();
            for (HashMap<String, String> opt : list.getResponse()) {
                msg.add(new Message(opt));
            }
            return msg;
        }
        return null;
    }

    public void getPermission(String permName) {
        CPermFind find = new CPermFind(permName);
        this.query.doCommand(find);
    }

    public int getPermissionIdByName(String permName) {
        CPermIdGetByName get = new CPermIdGetByName(permName);
        if (this.query.doCommand(get)) {
            return StringUtil.getInt(get.getFirstResponse().get("permid"));
        }
        return -1;
    }

    public List<AdvancedPermission> getPermissionOverview(int channelId, int clientDBId) {
        CPermOverview overview = new CPermOverview(channelId, clientDBId);
        if (this.query.doCommand(overview)) {
            ArrayList<AdvancedPermission> permissions = new ArrayList<AdvancedPermission>();
            for (HashMap<String, String> opt : overview.getResponse()) {
                permissions.add(new AdvancedPermission(opt));
            }
            return permissions;
        }
        return null;
    }

    public List<PermissionInfo> getPermissions() {
        CPermissionList list = new CPermissionList();
        if (this.query.doCommand(list)) {
            ArrayList<PermissionInfo> permissions = new ArrayList<PermissionInfo>();
            for (HashMap<String, String> opt : list.getResponse()) {
                permissions.add(new PermissionInfo(opt));
            }
            return permissions;
        }
        return null;
    }

    public int getPermissionValue(String permName) {
        CPermGet get = new CPermGet(permName);
        if (this.query.doCommand(get)) {
            return StringUtil.getInt(get.getFirstResponse().get("permvalue"));
        }
        return -1;
    }

    public List<PrivilegeKey> getPrivilegeKeys() {
        CPrivilegeKeyList list = new CPrivilegeKeyList();
        if (this.query.doCommand(list)) {
            ArrayList<PrivilegeKey> keys = new ArrayList<PrivilegeKey>();
            for (HashMap<String, String> opt : list.getResponse()) {
                keys.add(new PrivilegeKey(opt));
            }
            return keys;
        }
        return null;
    }

    public List<ServerGroupClient> getServerGroupClients(int groupId) {
        CServerGroupClientList list = new CServerGroupClientList(groupId);
        if (this.query.doCommand(list)) {
            ArrayList<ServerGroupClient> clients = new ArrayList<ServerGroupClient>();
            for (HashMap<String, String> opt : list.getResponse()) {
                clients.add(new ServerGroupClient(opt));
            }
            return clients;
        }
        return null;
    }

    public List<Permission> getServerGroupPermissions(int id) {
        CServerGroupPermList list = new CServerGroupPermList(id);
        if (this.query.doCommand(list)) {
            ArrayList<Permission> p = new ArrayList<Permission>();
            for (HashMap<String, String> opt : list.getResponse()) {
                p.add(new Permission(opt));
            }
            return p;
        }
        return null;
    }

    public List<ServerGroup> getServerGroups() {
        CServerGroupList list = new CServerGroupList();
        if (this.query.doCommand(list)) {
            ArrayList<ServerGroup> groups = new ArrayList<ServerGroup>();
            for (HashMap<String, String> opt : list.getResponse()) {
                groups.add(new ServerGroup(opt));
            }
            return groups;
        }
        return null;
    }

    public List<ServerGroup> getServerGroupsByClientId(int clientDatabaseId) {
        CServerGroupsByClientId client = new CServerGroupsByClientId(clientDatabaseId);
        if (this.query.doCommand(client)) {
            ArrayList<ServerGroup> list = new ArrayList<ServerGroup>();
            List<ServerGroup> allGroups = this.getServerGroups();
            for (HashMap<String, String> opt : client.getResponse()) {
                for (ServerGroup s : allGroups) {
                    if (s.getId() != StringUtil.getInt(opt.get("sgid"))) continue;
                    list.add(s);
                }
            }
            return list;
        }
        return null;
    }

    public int getServerIdByPort(int port) {
        CServerIdGetByPort s = new CServerIdGetByPort(port);
        if (this.query.doCommand(s)) {
            return StringUtil.getInt(s.getFirstResponse().get("server_id"));
        }
        return -1;
    }

    public VirtualServerInfo getServerInfo() {
        CServerInfo info = new CServerInfo();
        if (this.query.doCommand(info)) {
            return new VirtualServerInfo(info.getFirstResponse().getMap());
        }
        return null;
    }

    public Version getVersion() {
        CVersion version = new CVersion();
        if (this.query.doCommand(version)) {
            return new Version(version.getFirstResponse().getMap());
        }
        return null;
    }

    public List<VirtualServer> getVirtualServers() {
        CServerList serverList = new CServerList();
        if (this.query.doCommand(serverList)) {
            ArrayList<VirtualServer> servers = new ArrayList<VirtualServer>();
            for (HashMap<String, String> opt : serverList.getResponse()) {
                servers.add(new VirtualServer(opt));
            }
            return servers;
        }
        return null;
    }

    public boolean kickClientFromChannel(int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, null, clientIds);
    }

    public boolean kickClientFromChannel(String message, int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, message, clientIds);
    }

    public boolean kickClientFromServer(int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, null, clientIds);
    }

    public boolean kickClientFromServer(String message, int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, message, clientIds);
    }

    private boolean kickClients(ReasonIdentifier reason, String message, int ... clientIds) {
        CClientKick kick = new CClientKick(reason, message, clientIds);
        if (this.query.doCommand(kick)) {
            return kick.getError().isSuccessful();
        }
        return false;
    }

    public boolean login(String username, String password) {
        CLogin login = new CLogin(username, password);
        if (this.query.doCommand(login)) {
            return login.getError().isSuccessful();
        }
        return false;
    }

    public boolean logout() {
        CLogout logout = new CLogout();
        return this.query.doCommand(logout);
    }

    public void moveChannel(int channelId, int channelTargetId) {
        this.moveChannel(channelId, channelTargetId, -1);
    }

    public boolean moveChannel(int channelId, int channelTargetId, int order) {
        CChannelMove move = new CChannelMove(channelId, channelTargetId, order);
        if (this.query.doCommand(move)) {
            return move.getError().isSuccessful();
        }
        return false;
    }

    public boolean moveClient(int clientId, int channelId) {
        return this.moveClient(clientId, channelId, null);
    }

    public boolean moveClient(int clientId, int channelId, String channelPassword) {
        CClientMove move = new CClientMove(clientId, channelId, channelPassword);
        if (this.query.doCommand(move)) {
            return move.getError().isSuccessful();
        }
        return false;
    }

    public boolean moveClient(int channelId) {
        return this.moveClient(this.whoAmI().getId(), channelId);
    }

    public boolean moveClient(int channelId, String channelPassword) {
        return this.moveClient(this.whoAmI().getId(), channelId, channelPassword);
    }

    public boolean pokeClient(int clientId, String message) {
        CClientPoke poke = new CClientPoke(clientId, message);
        if (this.query.doCommand(poke)) {
            return poke.getError().isSuccessful();
        }
        return false;
    }

    public boolean quit() {
        return this.query.doCommand(new CQuit());
    }

    public void registerAllEvents() {
        this.registerEvent(TS3EventType.CHANNEL, this.whoAmI().getChannelId());
        this.registerEvent(TS3EventType.SERVER);
        this.registerEvent(TS3EventType.TEXT_CHANNEL);
        this.registerEvent(TS3EventType.TEXT_PRIVATE);
        this.registerEvent(TS3EventType.TEXT_SERVER);
    }

    public boolean registerEvent(TS3EventType t) {
        return this.registerEvent(t, -1);
    }

    public boolean registerEvent(TS3EventType t, int channelId) {
        CServerNotifyRegister r = new CServerNotifyRegister(t, channelId);
        if (this.query.doCommand(r)) {
            return r.getError().isSuccessful();
        }
        return false;
    }

    public void registerEvents(TS3EventType ... t) {
        TS3EventType[] tS3EventTypeArray = t;
        int n = t.length;
        int n2 = 0;
        while (n2 < n) {
            TS3EventType type = tS3EventTypeArray[n2];
            this.registerEvent(type, -1);
            ++n2;
        }
    }

    public boolean removeClientFromServerGroup(int groupId, int clientDatabaseId) {
        CServerGroupDelClient del = new CServerGroupDelClient(groupId, clientDatabaseId);
        if (this.query.doCommand(del)) {
            return del.getError().isSuccessful();
        }
        return false;
    }

    public void removeTS3Listeners(TS3Listener ... l) {
        this.query.getEventManager().removeListeners(l);
    }

    public boolean renameChannelGroup(int groupId, String name) {
        CChannelGroupRename rename = new CChannelGroupRename(groupId, name);
        if (this.query.doCommand(rename)) {
            return rename.getError().isSuccessful();
        }
        return false;
    }

    public boolean renameServerGroup(int id, String name) {
        CServerGroupRename rename = new CServerGroupRename(id, name);
        if (this.query.doCommand(rename)) {
            return rename.getError().isSuccessful();
        }
        return false;
    }

    public String resetPermissions() {
        CPermReset reset = new CPermReset();
        if (this.query.doCommand(reset)) {
            return reset.getFirstResponse().get("token");
        }
        return null;
    }

    public boolean selectVirtualServerById(int id) {
        CUse use = new CUse(id, -1);
        if (this.query.doCommand(use)) {
            return use.getError().isSuccessful();
        }
        return false;
    }

    public boolean selectVirtualServerByPort(int port) {
        CUse use = new CUse(-1, port);
        if (this.query.doCommand(use)) {
            return use.getError().isSuccessful();
        }
        return false;
    }

    public boolean selectVirtualServer(VirtualServer server) {
        return this.selectVirtualServerById(server.getId());
    }

    public boolean sendOfflineMessage(String clientUId, String subject, String message) {
        CMessageAdd add = new CMessageAdd(clientUId, subject, message);
        if (this.query.doCommand(add)) {
            return add.getError().isSuccessful();
        }
        return false;
    }

    public boolean sendTextMessage(TextMessageTargetMode targetMode, int targetId, String message) {
        CSendTextMessage msg = new CSendTextMessage(targetMode.getIndex(), targetId, message);
        if (this.query.doCommand(msg)) {
            return msg.getError().isSuccessful();
        }
        return false;
    }

    public boolean sendChannelMessage(int channelId, String message) {
        return this.sendTextMessage(TextMessageTargetMode.CHANNEL, channelId, message);
    }

    public boolean sendChannelMessage(String message) {
        return this.sendChannelMessage(this.whoAmI().getChannelId(), message);
    }

    public boolean sendServerMessage(int serverId, String message) {
        return this.sendTextMessage(TextMessageTargetMode.SERVER, serverId, message);
    }

    public boolean sendServerMessage(String message) {
        return this.sendServerMessage(1, message);
    }

    public boolean sendPrivateMessage(int clientId, String message) {
        return this.sendTextMessage(TextMessageTargetMode.CLIENT, clientId, message);
    }

    public boolean setClientChannelGroup(int groupId, int channelId, int clientDBId) {
        CSetClientChannelGroup group = new CSetClientChannelGroup(groupId, channelId, clientDBId);
        if (this.query.doCommand(group)) {
            return group.getError().isSuccessful();
        }
        return false;
    }

    public boolean setMessageRead(int messageId) {
        return this.setMessageReadFlag(messageId, true);
    }

    public boolean setMessageReadFlag(int messageId, boolean read) {
        CMessageUpdateFlag flag = new CMessageUpdateFlag(messageId, read);
        if (this.query.doCommand(flag)) {
            return flag.getError().isSuccessful();
        }
        return read;
    }

    public boolean setNickname(String name) {
        HashMap<ClientProperty, String> options = new HashMap<ClientProperty, String>();
        options.put(ClientProperty.CLIENT_NICKNAME, name);
        return this.updateClient(options);
    }

    public boolean startServer(int id) {
        CServerStart start = new CServerStart(id);
        if (this.query.doCommand(start)) {
            return start.getError().isSuccessful();
        }
        return false;
    }

    public boolean stopServer(int id) {
        CServerStop start = new CServerStop(id);
        if (this.query.doCommand(start)) {
            return start.getError().isSuccessful();
        }
        return false;
    }

    public boolean stopServerProcess() {
        CServerProcessStop stop = new CServerProcessStop();
        if (this.query.doCommand(stop)) {
            return stop.getError().isSuccessful();
        }
        return false;
    }

    public boolean unregisterAllEvents() {
        CServerNotifyUnregister unr = new CServerNotifyUnregister();
        if (this.query.doCommand(unr)) {
            return unr.getError().isSuccessful();
        }
        return false;
    }

    public boolean updateClient(HashMap<ClientProperty, String> options) {
        CClientUpdate update = new CClientUpdate(options);
        if (this.query.doCommand(update)) {
            return update.getError().isSuccessful();
        }
        return false;
    }

    public boolean usePrivilegeKey(String token) {
        CPrivilegeKeyUse use = new CPrivilegeKeyUse(token);
        if (this.query.doCommand(use)) {
            return use.getError().isSuccessful();
        }
        return false;
    }

    public ServerQueryInfo whoAmI() {
        CWhoAmI whoAmI = new CWhoAmI();
        if (this.query.doCommand(whoAmI)) {
            return new ServerQueryInfo(whoAmI.getFirstResponse().getMap());
        }
        return null;
    }
}

