/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.commands.Command;

public class SocketWriter
extends Thread {
    private final TS3Query ts3;
    private int floodRate;
    private long lastCommand = System.currentTimeMillis();
    private volatile boolean stop;

    public SocketWriter(TS3Query ts3, int floodRate) {
        super("SocketWriter");
        this.ts3 = ts3;
        this.floodRate = floodRate > 50 ? floodRate : 50;
    }

    @Override
    public void run() {
        while (this.ts3.getSocket() != null && this.ts3.getSocket().isConnected() && this.ts3.getOut() != null && !this.stop) {
            Command c = this.ts3.getCommandList().peek();
            if (c != null && !c.isSent()) {
                String msg = c.toString();
                TS3Query.log.info("> " + msg);
                this.ts3.getOut().println(msg);
                this.lastCommand = System.currentTimeMillis();
                c.setSent();
            }
            try {
                Thread.sleep(this.floodRate);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        TS3Query.log.warning("SocketWriter has stopped!");
    }

    public long getIdleTime() {
        return System.currentTimeMillis() - this.lastCommand;
    }

    public void finish() {
        this.stop = true;
    }
}

