/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.commands.Command;
import java.io.IOException;

public class SocketReader
extends Thread {
    private final TS3Query ts3;
    private volatile boolean stop;

    public SocketReader(TS3Query ts3) {
        super("SocketReader");
        this.ts3 = ts3;
        try {
            int i = 0;
            while (i < 4 || ts3.getIn().ready()) {
                TS3Query.log.info("< " + ts3.getIn().readLine());
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (this.ts3.getSocket() != null && this.ts3.getSocket().isConnected() && this.ts3.getIn() != null && !this.stop) {
            try {
                String line;
                if (this.ts3.getIn().ready() && !(line = this.ts3.getIn().readLine()).isEmpty()) {
                    Command c = this.ts3.getCommandList().peek();
                    if (line.startsWith("notify")) {
                        TS3Query.log.info("< [event] " + line);
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                String[] arr = line.split(" ", 2);
                                SocketReader.this.ts3.getEventManager().fireEvent(arr[0], arr[1]);
                            }
                        }).start();
                    } else if (c != null && c.isSent()) {
                        TS3Query.log.info("[" + c.getName() + "] < " + line);
                        if (line.startsWith("error")) {
                            c.feedError(line.substring("error ".length()));
                            if (c.getError().getId() != 0) {
                                TS3Query.log.severe("[ERROR] " + c.getError());
                            }
                            c.setAnswered();
                            this.ts3.getCommandList().remove(c);
                        } else if (!line.isEmpty()) {
                            c.feed(line);
                        }
                    } else {
                        TS3Query.log.info("< " + line);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        TS3Query.log.warning("SocketReader has stopped!");
    }

    public void finish() {
        this.stop = true;
    }
}

