/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.SocketWriter;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.commands.CWhoAmI;

public class KeepAliveThread
extends Thread {
    private static final int SLEEP = 60000;
    private final TS3Query ts3;
    private final SocketWriter writer;
    private volatile boolean stop;

    public KeepAliveThread(TS3Query ts3, SocketWriter socketWriter) {
        super("Keep alive");
        this.ts3 = ts3;
        this.writer = socketWriter;
    }

    @Override
    public void run() {
        while (this.ts3.getSocket() != null && this.ts3.getSocket().isConnected() && this.ts3.getIn() != null && !this.stop) {
            long idleTime = this.writer.getIdleTime();
            if (idleTime >= 60000L) {
                this.ts3.doCommand(new CWhoAmI());
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        TS3Query.log.warning("KeepAlive thread has stopped!");
    }

    public void finish() {
        this.stop = true;
    }
}

