/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.api.event.ChannelCreateEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelDeletedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelDescriptionEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelMovedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelPasswordChangedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientJoinEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientLeaveEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientMovedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ServerEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.TS3EventEmitter;
import com.github.theholywaffle.teamspeak3.api.event.TS3Listener;
import com.github.theholywaffle.teamspeak3.api.event.TextMessageEvent;
import com.github.theholywaffle.teamspeak3.api.exception.TS3UnknownEventException;
import com.github.theholywaffle.teamspeak3.commands.response.DefaultArrayResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventManager {
    private final Map<String, TS3EventEmitter> map = new HashMap<String, TS3EventEmitter>();
    private final List<TS3Listener> listeners = new ArrayList<TS3Listener>();

    public EventManager() {
        this.map.put("notifytextmessage", new TextMessageEvent());
        this.map.put("notifycliententerview", new ClientJoinEvent());
        this.map.put("notifyclientleftview", new ClientLeaveEvent());
        this.map.put("notifyserveredited", new ServerEditedEvent());
        this.map.put("notifychanneledited", new ChannelEditedEvent());
        this.map.put("notifychanneldescriptionchanged", new ChannelDescriptionEditedEvent());
        this.map.put("notifyclientmoved", new ClientMovedEvent());
        this.map.put("notifychannelcreated", new ChannelCreateEvent());
        this.map.put("notifychanneldeleted", new ChannelDeletedEvent());
        this.map.put("notifychannelmoved", new ChannelMovedEvent());
        this.map.put("notifychannelpasswordchanged", new ChannelPasswordChangedEvent());
    }

    public void addListeners(TS3Listener ... listeners) {
        TS3Listener[] tS3ListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            TS3Listener l = tS3ListenerArray[n2];
            this.listeners.add(l);
            ++n2;
        }
    }

    public void removeListeners(TS3Listener ... listeners) {
        TS3Listener[] tS3ListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            TS3Listener l = tS3ListenerArray[n2];
            this.listeners.remove(l);
            ++n2;
        }
    }

    public void fireEvent(String notifyName, String notifyBody) {
        TS3EventEmitter emitter = this.map.get(notifyName);
        if (emitter != null) {
            for (TS3Listener l : this.listeners) {
                emitter.fire(l, new DefaultArrayResponse(notifyBody).getArray().get(0));
            }
        } else {
            throw new TS3UnknownEventException(String.valueOf(notifyName) + " " + notifyBody);
        }
    }
}

