/*
 * Decompiled with CFR 0.152.
 */
package net.raditz.creeperexplosionpranks;

import java.io.File;
import java.util.logging.Logger;
import net.raditz.creeperexplosionpranks.CommandReloadCreeperConfig;
import net.raditz.creeperexplosionpranks.ExplosionListener;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class CreeperExplosionPranks
extends JavaPlugin {
    public final Logger logger = this.getLogger();

    public void onDisable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.logger.info(String.valueOf(pdfFile.getName()) + " has been disabled.");
    }

    public void onEnable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.logger.info(String.valueOf(pdfFile.getName()) + " version " + pdfFile.getVersion() + " has been enabled.");
        Server server = this.getServer();
        PluginManager pm = server.getPluginManager();
        this.createConfig();
        this.getCommand("reloadcreeperconfig").setExecutor((CommandExecutor)new CommandReloadCreeperConfig(this));
        pm.registerEvents((Listener)new ExplosionListener(this), (Plugin)this);
    }

    private void createConfig() {
        try {
            File file;
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdirs();
            }
            if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
                this.logger.info("Config.yml not found, creating!");
                this.saveDefaultConfig();
            } else {
                this.logger.info("Config.yml found, loading!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

