/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.utils;

import com.projectkorra.items.ProjectKorraItems;
import com.projectkorra.items.attribute.Action;
import com.projectkorra.items.attribute.Attribute;
import com.projectkorra.items.attribute.AttributeList;
import com.projectkorra.items.customs.PKItem;
import com.projectkorra.items.utils.AttributeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;

public class ItemUtils {
    public static final ConcurrentHashMap<String, ConcurrentHashMap<String, Attribute>> currentBendingEffects = new ConcurrentHashMap();

    public static ArrayList<ItemStack> getPlayerEquipment(Player player) {
        ArrayList<ItemStack> istacks = new ArrayList<ItemStack>();
        ItemStack[] itemStackArray = player.getInventory().getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack istack = itemStackArray[n2];
            istacks.add(istack);
            ++n2;
        }
        istacks.add(player.getItemInHand());
        return istacks;
    }

    public static ArrayList<ItemStack> getPlayerValidEquipment(Player player) {
        PKItem citem;
        if (player == null) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> equipment = ItemUtils.getPlayerEquipment(player);
        PlayerInventory playerInv = player.getInventory();
        for (ItemStack invItem : playerInv) {
            if (invItem == null || invItem.getType() == Material.AIR || (citem = PKItem.getCustomItem(invItem)) == null || equipment.contains(invItem) || !citem.getBooleanAttributeValue("AllowFromInventory")) continue;
            equipment.add(invItem);
        }
        int i = 0;
        while (i < equipment.size()) {
            ItemStack istack = equipment.get(i);
            citem = PKItem.getCustomItem(istack);
            if (citem != null) {
                boolean keepItem = true;
                if (!ItemUtils.hasValidCharges(istack)) {
                    keepItem = false;
                } else if (citem.getBooleanAttributeValue("HoldOnly") && !istack.equals((Object)player.getItemInHand())) {
                    keepItem = false;
                } else if (citem.getBooleanAttributeValue("WearOnly") && istack.equals((Object)player.getItemInHand())) {
                    keepItem = false;
                } else if (!AttributeUtils.hasRequiredElement(player, citem)) {
                    keepItem = false;
                } else if (!AttributeUtils.hasRequiredWorld(player, citem)) {
                    keepItem = false;
                } else if (!AttributeUtils.hasRequiredPermission(player, citem)) {
                    keepItem = false;
                }
                if (!keepItem) {
                    equipment.remove(i);
                    --i;
                }
            }
            ++i;
        }
        return equipment;
    }

    public static boolean hasValidCharges(ItemStack item) {
        boolean validCharges = true;
        try {
            for (String line : item.getItemMeta().getLore()) {
                if (!line.startsWith(AttributeList.CHARGES_STR) && !line.startsWith(AttributeList.CLICK_CHARGES_STR) && !line.startsWith(AttributeList.SNEAK_CHARGES_STR)) continue;
                String tmpStr = line.substring(line.indexOf(": ") + 1, line.length()).trim();
                int value = Integer.parseInt(tmpStr);
                if (value <= 0) {
                    validCharges = false;
                    continue;
                }
                validCharges = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return validCharges;
    }

    public static boolean setLore(ItemStack istack, List<String> lore) {
        if (istack == null || lore == null) {
            return false;
        }
        ItemMeta meta = istack.getItemMeta();
        if (meta == null) {
            return false;
        }
        meta.setLore(lore);
        istack.setItemMeta(meta);
        return true;
    }

    public static void updateOnActionEffects(Player player, Action type) {
        if (player == null) {
            return;
        }
        ArrayList<ItemStack> istacks = ItemUtils.getPlayerValidEquipment(player);
        String[] validAttribs = null;
        validAttribs = type == Action.LEFT_CLICK ? new String[]{"Effects", "ClickEffects"} : (type == Action.RIGHT_CLICK ? new String[]{"Effects", "ClickEffects"} : (type == Action.SHIFT ? new String[]{"Effects", "SneakEffects"} : (type == Action.CONSUME ? new String[]{"Effects", "ConsumeEffects"} : new String[]{"Effects"})));
        boolean effectAdded = false;
        for (ItemStack istack : istacks) {
            PKItem citem = PKItem.getCustomItem(istack);
            if (citem == null) continue;
            for (Attribute att : citem.getAttributes()) {
                String[] stringArray = validAttribs;
                int n = validAttribs.length;
                int n2 = 0;
                while (n2 < n) {
                    String allowedEff = stringArray[n2];
                    if (att.getName().equalsIgnoreCase(allowedEff)) {
                        ArrayList<PotionEffect> potEffects = AttributeUtils.parsePotionEffects(att);
                        ArrayList<Attribute> bendEffects = AttributeUtils.parseBendingEffects(att);
                        for (PotionEffect pot : potEffects) {
                            player.addPotionEffect(pot, true);
                        }
                        effectAdded = true;
                        for (Attribute effect : bendEffects) {
                            if (!currentBendingEffects.containsKey(player.getName())) {
                                currentBendingEffects.put(player.getName(), new ConcurrentHashMap());
                            }
                            effect.setTime(System.currentTimeMillis());
                            ConcurrentHashMap<String, Attribute> playerEffList = currentBendingEffects.get(player.getName());
                            playerEffList.put(effect.getName(), effect);
                        }
                    }
                    ++n2;
                }
            }
        }
        if (effectAdded) {
            AttributeUtils.decreaseCharges(player, type);
        }
    }

    public static void handleItemSource(Player player, String attrib, ItemStack istack) {
        ConcurrentHashMap<String, Double> attribs = AttributeUtils.getSimplePlayerAttributeMap(player);
        if (attribs.containsKey(attrib) && attribs.get(attrib) == 1.0) {
            final PlayerInventory inv = player.getInventory();
            int slot = -1;
            int i = 9;
            while (i < inv.getSize()) {
                if (inv.getItem(i) == null || inv.getItem(i).getType() == Material.AIR) {
                    slot = i;
                    break;
                }
                ++i;
            }
            if (slot < 0) {
                slot = inv.first(Material.AIR);
            }
            if (slot < 0) {
                return;
            }
            inv.setItem(slot, istack);
            player.updateInventory();
            final int fslot = slot;
            new BukkitRunnable(){

                public void run() {
                    inv.setItem(fslot, new ItemStack(Material.AIR));
                }
            }.runTaskLater((Plugin)ProjectKorraItems.plugin, 10L);
        }
    }
}

