/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.utils;

import com.projectkorra.items.Messages;
import com.projectkorra.items.attribute.Action;
import com.projectkorra.items.attribute.Attribute;
import com.projectkorra.items.attribute.AttributeList;
import com.projectkorra.items.attribute.AttributeListener;
import com.projectkorra.items.customs.PKItem;
import com.projectkorra.items.utils.ElementUtils;
import com.projectkorra.items.utils.ItemUtils;
import com.projectkorra.projectkorra.Element;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class AttributeUtils {
    public static ConcurrentHashMap<String, Double> getSimplePlayerAttributeMap(Player player) {
        ArrayList<ItemStack> equipment = ItemUtils.getPlayerValidEquipment(player);
        ConcurrentHashMap<String, Double> attribMap = new ConcurrentHashMap<String, Double>();
        ArrayList<Attribute> totalAttribs = new ArrayList<Attribute>();
        if (AttributeListener.currentBendingEffects.containsKey(player.getName())) {
            ConcurrentHashMap<String, Attribute> effects = AttributeListener.currentBendingEffects.get(player.getName());
            for (Attribute attribute : effects.values()) {
                if (!((double)System.currentTimeMillis() - attribute.getTime() < attribute.getDuration())) continue;
                totalAttribs.add(attribute);
            }
        }
        for (ItemStack istack : equipment) {
            PKItem citem = PKItem.getCustomItem(istack);
            if (citem == null) continue;
            for (Attribute attr : citem.getAttributes()) {
                totalAttribs.add(attr);
            }
        }
        ArrayList<Attribute> fullElementAttribs = new ArrayList<Attribute>();
        for (Attribute attribute : totalAttribs) {
            fullElementAttribs.addAll(AttributeUtils.getFullElementAttributes(attribute));
        }
        totalAttribs.addAll(fullElementAttribs);
        for (Attribute attribute : totalAttribs) {
            if (attribute.getValues().size() != 1) continue;
            double val = 0.0;
            if (attribMap.containsKey(attribute.getName())) {
                val = attribMap.get(attribute.getName());
            }
            attribMap.put(attribute.getName(), val += attribute.getValueAsDouble());
        }
        return attribMap;
    }

    public static ArrayList<PotionEffect> parsePotionEffects(Attribute attr) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        if (attr.getValues() == null) {
            return effects;
        }
        for (String val : attr.getValues()) {
            String[] colSplit = val.split(":");
            try {
                PotionEffectType type = PotionEffectType.getByName((String)colSplit[0].trim());
                int strength = Integer.parseInt(colSplit[1].trim());
                double duration = Double.parseDouble(colSplit[2].trim());
                PotionEffect pot = new PotionEffect(type, (int)(duration * 20.0), strength - 1);
                effects.add(pot);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return effects;
    }

    public static ArrayList<Attribute> parseBendingEffects(Attribute attr) {
        ArrayList<Attribute> effects = new ArrayList<Attribute>();
        if (attr.getValues() == null) {
            return effects;
        }
        for (String val : attr.getValues()) {
            String[] colSplit = val.split(":");
            if (colSplit.length < 3) {
                Messages.logTimedMessage("an effect is missing values (Effect:Power:Duration): " + val, 30000L);
                continue;
            }
            try {
                String name = colSplit[0].trim();
                PotionEffectType type = PotionEffectType.getByName((String)name);
                if (type != null) continue;
                String modifier = colSplit[1].trim();
                double duration = Double.parseDouble(colSplit[2].trim());
                Attribute newAttr = new Attribute(Attribute.getAttribute(name));
                ArrayList<String> vals = new ArrayList<String>();
                vals.add(modifier);
                newAttr.setValues(vals);
                newAttr.setDuration(duration * 1000.0);
                effects.add(newAttr);
            }
            catch (Exception e) {
                Messages.logTimedMessage("an issue occured with this value: " + val, 30000L);
            }
        }
        return effects;
    }

    public static void decreaseCharges(Player player, Action type) {
        if (player == null) {
            return;
        }
        ArrayList<ItemStack> istacks = ItemUtils.getPlayerValidEquipment(player);
        for (ItemStack istack : istacks) {
            ItemMeta meta;
            List lore;
            PKItem citem = PKItem.getCustomItem(istack);
            if (citem == null || (lore = (meta = istack.getItemMeta()).getLore()) == null) continue;
            boolean displayDestroyMsg = false;
            ArrayList<String> newLore = new ArrayList<String>();
            Iterator iterator = lore.iterator();
            while (iterator.hasNext()) {
                String line;
                String newLine = line = (String)iterator.next();
                try {
                    if (line.startsWith(AttributeList.CHARGES_STR) || line.startsWith(AttributeList.CLICK_CHARGES_STR) && type == Action.LEFT_CLICK || type == Action.RIGHT_CLICK || type == null || line.startsWith(AttributeList.SNEAK_CHARGES_STR) && type == Action.SHIFT || type == null) {
                        String start = line.substring(0, line.indexOf(": "));
                        Object end = line.substring(line.indexOf(": ") + 1, line.length());
                        int val = Integer.parseInt((String)(end = ((String)end).trim())) - 1;
                        if (val == 0) {
                            displayDestroyMsg = true;
                        }
                        if (val >= 0) {
                            newLine = String.valueOf(start) + ": " + val;
                        }
                    }
                }
                catch (Exception start) {
                    // empty catch block
                }
                newLore.add(newLine);
            }
            meta.setLore(newLore);
            istack.setItemMeta(meta);
            boolean hasDestroyAttr = false;
            boolean hasIgnoreDestroyMsg = false;
            if (citem.getBooleanAttributeValue("DestroyAfterCharges")) {
                hasDestroyAttr = true;
            }
            if (citem.getBooleanAttributeValue("IgnoreDestroyMessage")) {
                hasIgnoreDestroyMsg = true;
            }
            boolean hasChargesLeft = true;
            for (String line : newLore) {
                try {
                    if (!line.startsWith(AttributeList.CHARGES_STR) && !line.startsWith(AttributeList.CLICK_CHARGES_STR) && !line.startsWith(AttributeList.SNEAK_CHARGES_STR)) continue;
                    String tmpStr = line.substring(line.indexOf(": ") + 1, line.length()).trim();
                    int value = Integer.parseInt(tmpStr);
                    if (value <= 0) {
                        hasChargesLeft = false;
                        continue;
                    }
                    hasChargesLeft = true;
                    break;
                }
                catch (Exception tmpStr) {
                    // empty catch block
                }
            }
            if (!hasChargesLeft && !hasIgnoreDestroyMsg && displayDestroyMsg) {
                player.sendMessage(String.valueOf(citem.getDisplayName()) + " " + Messages.ITEM_DESTROYED);
            }
            if (!hasDestroyAttr || hasChargesLeft) continue;
            if (player.getInventory().contains(istack)) {
                if (istack.getAmount() > 1) {
                    istack.setAmount(istack.getAmount() - 1);
                    ItemStack newStack = citem.generateItem();
                    ItemUtils.setLore(istack, newStack.getItemMeta().getLore());
                    continue;
                }
                player.getInventory().remove(istack);
                continue;
            }
            ItemStack[] armor = player.getInventory().getArmorContents();
            int i = 0;
            while (i < armor.length) {
                if (armor[i].equals((Object)istack)) {
                    if (istack.getAmount() > 1) {
                        armor[i].setAmount(armor[i].getAmount() - 1);
                        ItemStack newStack = citem.generateItem();
                        ItemUtils.setLore(armor[i], newStack.getItemMeta().getLore());
                        break;
                    }
                    armor[i] = new ItemStack(Material.AIR);
                    break;
                }
                ++i;
            }
            player.getInventory().setArmorContents(armor);
        }
    }

    public static ArrayList<Attribute> getFullElementAttributes(Attribute attr) {
        return AttributeUtils.getFullElementAttributes(attr.getName(), attr.getValueAsDouble());
    }

    public static ArrayList<Attribute> getFullElementAttributes(String name, double value) {
        ArrayList<Attribute> lst = new ArrayList<Attribute>();
        if (name == null) {
            return lst;
        }
        Element elem = Element.getElement((String)name);
        if (elem != null) {
            for (Attribute listAttr : AttributeList.ATTRIBUTES) {
                if (listAttr.getElement() != elem) continue;
                Attribute newAttr = new Attribute(listAttr);
                newAttr.setValues(value * (double)newAttr.getBenefit());
                lst.add(newAttr);
            }
        }
        return lst;
    }

    public static boolean hasRequiredElement(Player player, PKItem citem) {
        if (player == null || citem == null) {
            return false;
        }
        Attribute requireElem = citem.getAttribute("RequireElement");
        if (requireElem != null) {
            boolean allowed = false;
            for (String val : requireElem.getValues()) {
                try {
                    if (!ElementUtils.hasElement(player, val)) continue;
                    allowed = true;
                    break;
                }
                catch (IllegalArgumentException e) {
                    Messages.logTimedMessage(e.getMessage());
                }
            }
            return allowed;
        }
        return true;
    }

    public static boolean hasRequiredWorld(Player player, PKItem citem) {
        if (player == null || citem == null) {
            return false;
        }
        Attribute require = citem.getAttribute("RequireWorld");
        if (require != null) {
            return require.getValues().contains(player.getWorld().getName());
        }
        return true;
    }

    public static boolean hasRequiredPermission(Player player, PKItem citem) {
        if (player == null || citem == null) {
            return false;
        }
        Attribute require = citem.getAttribute("RequirePermission");
        if (require != null) {
            for (String perm : require.getValues()) {
                if (!player.hasPermission(perm)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

