/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.items;

import com.projectkorra.items.ProjectKorraItems;
import com.projectkorra.items.attribute.Action;
import com.projectkorra.items.utils.ElementUtils;
import com.projectkorra.projectkorra.GeneralMethods;
import com.projectkorra.projectkorra.util.ParticleEffect;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class GrapplingHook {
    public static final ConcurrentHashMap<String, GrapplingHook> INSTANCES = new ConcurrentHashMap();
    public static final double SPEED = 5.0;
    public static final double RANGE = 30.0;
    private State state;
    private Player player;
    private GrapplingHookTask task;
    private Location currentLoc;
    private Vector direction;
    private double speed;
    private double range;
    private double red;
    private double green;
    private double blue;

    public GrapplingHook(Player player, Action action) {
        if (INSTANCES.containsKey(player.getName())) {
            GrapplingHook hook = INSTANCES.get(player.getName());
            if (hook.state == State.HOOKED && action != Action.LEFT_CLICK && action != Action.RIGHT_CLICK) {
            }
            return;
        }
        this.state = State.START;
        this.player = player;
        this.speed = 5.0;
        this.range = 30.0;
        INSTANCES.put(player.getName(), this);
        this.task = new GrapplingHookTask(this);
        this.task.runTaskTimer((Plugin)ProjectKorraItems.plugin, 0L, 1L);
    }

    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
        }
        INSTANCES.remove(this.player.getName());
    }

    public static void playAnimation(Location loc1, Location loc2, double incr, float density, float r, float g, float b) {
        Location iter = loc1.clone();
        Vector dir = GeneralMethods.getDirection((Location)loc1, (Location)loc2).normalize();
        while (iter.distanceSquared(loc1) <= iter.distanceSquared(loc2)) {
            ParticleEffect.RED_DUST.display(r, g, b, density, 0, iter, 256.0);
            iter = iter.add(dir.clone().multiply(incr));
        }
    }

    public static void playAnimation(Location loc1, Location loc2, double incr, float density) {
        GrapplingHook.playAnimation(loc1, loc2, incr, density, 0.0f, 0.0f, 0.0f);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Player getPlayer() {
        return this.player;
    }

    public GrapplingHookTask getTask() {
        return this.task;
    }

    public void setTask(GrapplingHookTask task) {
        this.task = task;
    }

    public Location getCurrentLoc() {
        return this.currentLoc;
    }

    public void setCurrentLoc(Location currentLoc) {
        this.currentLoc = currentLoc;
    }

    public Vector getDirection() {
        return this.direction;
    }

    public void setDirection(Vector direction) {
        this.direction = direction;
    }

    public class GrapplingHookTask
    extends BukkitRunnable {
        GrapplingHook hook;

        public GrapplingHookTask(GrapplingHook hook) {
            this.hook = hook;
        }

        public void run() {
            if (GrapplingHook.this.player == null || GrapplingHook.this.player.isDead() || !GrapplingHook.this.player.isOnline()) {
                this.cancel();
                return;
            }
            if (GrapplingHook.this.currentLoc != null && (!GrapplingHook.this.player.getWorld().equals(GrapplingHook.this.currentLoc.getWorld()) || GrapplingHook.this.currentLoc.distanceSquared(GrapplingHook.this.player.getEyeLocation()) > Math.pow(GrapplingHook.this.range, 2.0))) {
                this.cancel();
                return;
            }
            if (GrapplingHook.this.state == State.START) {
                GrapplingHook.this.state = State.SHOOTING;
                GrapplingHook.this.direction = GrapplingHook.this.player.getEyeLocation().toVector().normalize();
                GrapplingHook.this.currentLoc = GrapplingHook.this.player.getEyeLocation();
            } else if (GrapplingHook.this.state == State.SHOOTING) {
                GrapplingHook.playAnimation(GrapplingHook.this.player.getEyeLocation().add(0.0, -0.5, 0.0), GrapplingHook.this.currentLoc, 1.0, 0.1f, (float)GrapplingHook.this.red, (float)GrapplingHook.this.green, (float)GrapplingHook.this.blue);
                BlockIterator iter = new BlockIterator(GrapplingHook.this.currentLoc.getWorld(), GrapplingHook.this.currentLoc.toVector(), GrapplingHook.this.direction, 0.0, (int)GrapplingHook.this.speed + 1);
                GrapplingHook.this.currentLoc = GrapplingHook.this.currentLoc.add(GrapplingHook.this.direction.clone().multiply(GrapplingHook.this.speed));
                while (iter.hasNext()) {
                    Block block = iter.next();
                    if (ElementUtils.isTransparent(block.getType())) continue;
                    GrapplingHook.this.currentLoc = block.getLocation();
                    GrapplingHook.this.state = State.HOOKED;
                    break;
                }
            } else if (GrapplingHook.this.state == State.HOOKED) {
                GrapplingHook.playAnimation(GrapplingHook.this.player.getEyeLocation().add(0.0, -0.5, 0.0), GrapplingHook.this.currentLoc, 1.0, 0.1f, (float)GrapplingHook.this.red, (float)GrapplingHook.this.green, (float)GrapplingHook.this.blue);
            }
        }

        public void cancel() {
            super.cancel();
            this.hook.task = null;
            this.hook.cancel();
        }
    }

    public static enum State {
        START,
        SHOOTING,
        HOOKED,
        FLUNG,
        CLIMBING;

    }
}

